<?php

namespace App\Models\Hr;

use App\Helpers\Helper;
use App\Helpers\IDate;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;


class GenAttend extends Model
{

    /*
    |--------------------------------------------------------------------------
    | GLOBAL VARIABLES
    |--------------------------------------------------------------------------
    */

    protected $table = 'gen_attends';
    // protected $primaryKey = 'id';
    // public $timestamps = false;
    // protected $guarded = ['id'];
    protected $fillable = [];
    // protected $hidden = [];
    // protected $dates = [];

    /*
    |--------------------------------------------------------------------------
    | FUNCTIONS
    |--------------------------------------------------------------------------
    */
    public static function getRealDayWork($emp_id, $from_date, $to_date)
    {
        $d_all = IDate::createDateRangeIncHoliday($from_date, $to_date);
        $total_h = 0;
        $total_p = 0;
        if (is_array($d_all)) {
            if (count($d_all) > 0) {
                foreach ($d_all as $d) {
                    if ($d['type'] == 'h') {
                        $total_h++;
                    } else if ($d['type'] == 'n') {

                        $d_work = TimeAttend::where('emp_id', $emp_id)
                            // ->whereDate('attend','>=',$from_date)
                            ->whereDate('attend', $d['date'])
                            //->whereRaw(" DAYNAME(attend) NOT IN ('Saturday', 'Sunday') ")
                            ->groupBy(\DB::raw('DATE(attend)'))
                            ->count(\DB::raw(' DISTINCT DATE(attend) '));

                        if ($d_work > 0) {
                            $total_p++;
                        }

                    }
                }
            }
        }

        return $total_p + $total_h;
    }

    public static function getNormalWorkingDay($emp_id, $from_date, $to_date)
    {
        $d_all = IDate::createDateRangeIncHoliday($from_date, $to_date);
//dd($d_all);
        $total_day = 0;
        $absent_before_hol = 0;

        if (is_array($d_all)) {
            if (count($d_all) > 0) {
                foreach ($d_all as $d) {
//                    if ($d['type'] == 'n' || $d['type'] == 'h' || $d['type'] == 'w') {
                    if ($d['type'] == 'n') {
                        $total_day++;
                    }
                }
            }
        }
        return $total_day;
    }

    public static function getSpouseChild($emp_id)
    {
        $s = 0;
        $c = 0;
        $total_amt = 0;
        $total = 0;
        $emp = Employee::where('id', $emp_id)
            ->first();
        $exchange_rate = Helper::getTaxExRate();

        if ($emp != null) {
            $s = isset($emp->spouse) > 0 ? $emp->spouse : 0;
            $c = isset($emp->children) > 0 ? $emp->children : 0;
        }
        $total = $c + $s;
        $total = $total > 0 ? $total : 0;
        $total_amt = ($total * 150000) / $exchange_rate;
        return $total_amt > 0 ? $total_amt : 0;

    }

    public static function getAbsence($emp_id, $from_date, $to_date)
    {
        $d_all = IDate::createDateRangeIncHoliday($from_date, $to_date);

        $total_h = 0;
        $absent_before_hol = 0;

        if (is_array($d_all)) {
            if (count($d_all) > 0) {
                foreach ($d_all as $d) {
                    if ($d['type'] == 'h') {
                        $total_h++;
                    } else if ($d['type'] == 'n') {

                        $d_work = TimeAttend::where('emp_id', $emp_id)
                            // ->whereDate('attend','>=',$from_date)
                            ->whereDate('attend', $d['date'])
                            //->whereRaw(" DAYNAME(attend) NOT IN ('Saturday', 'Sunday') ")
                            ->groupBy(\DB::raw('DATE(attend)'))
                            ->count(\DB::raw(' DISTINCT DATE(attend) '));

                        if ($d_work > 0) {
                        } else {
                            $getPermissionCal = self::getPermissionCal($emp_id, $d['date'], $d['date']);
                            if ($getPermissionCal == 0) {
                                $absent_before_hol = $absent_before_hol + 1;
                            } else if ($getPermissionCal == 0.5) {
                                $absent_before_hol = $absent_before_hol + 0.5;
                            }

                        }

                    }
                }
            }
        }

        return $absent_before_hol;
    }

    public static function getSpouseChildView($emp_id)
    {
        $s = 0;
        $c = 0;
        $total_amt = 0;
        $total = 0;
        $emp = Employee::where('id', $emp_id)
            ->first();
        $exchange_rate = Helper::getTaxExRate();

        if ($emp != null) {
            $s = isset($emp->spouse) > 0 ? $emp->spouse : 0;
            $c = isset($emp->children) > 0 ? $emp->children : 0;
        }
        $total = $c + $s;
        $total = $total > 0 ? $total : 0;
        $total_amt = $total * 150000;
        $total_amt = $total_amt > 0 ? $total_amt : 0;

        return [
            'num' => $total,
            'total_amt' => $total_amt
        ];

    }

    public static function getAbsentWorking($emp_id, $from_date, $to_date)
    {
        $absent = TimeAttendGen::where('emp_id', $emp_id)
            ->whereDate('att_date', '>=', $from_date)
            ->whereDate('att_date', "<=", $to_date)
            ->select(DB::raw("SUM(missing) as num_absent"))
            ->first();
        $absent = $absent->num_absent > 0 ? $absent->num_absent : 0;
        return $absent;

    }

    public static function getAbsence_($emp_id, $from_date, $to_date)
    {
        $d_all = IDate::createDateRangeIncHoliday($from_date, $to_date);

        $total_h = 0;
        $absent_before_hol = 0;

        if (is_array($d_all)) {
            if (count($d_all) > 0) {
                foreach ($d_all as $d) {
                    if ($d['type'] == 'h') {
                        $total_h++;
                    } else if ($d['type'] == 'n') {

                        $d_work = TimeAttend::where('emp_id', $emp_id)
                            ->whereDate('attend', '>=', $from_date)
                            ->whereDate('attend', $d['date'])
                            ->whereRaw(" DAYNAME(attend) NOT IN ('Saturday', 'Sunday') ")
                            ->groupBy(DB::raw('DATE(attend)'))
                            ->count(DB::raw(' DISTINCT DATE(attend) '));

                        if ($d_work > 0) {
                        } else {
                            $getPermissionCal = self::getPermissionCal($emp_id, $d['date'], $d['date']);
                            if ($getPermissionCal == 0) {
                                $absent_before_hol = $absent_before_hol + 1;
                            } else if ($getPermissionCal == 0.5) {
                                $absent_before_hol = $absent_before_hol + 0.5;
                            }

                        }

                    }
                }
            }
        }

        return $absent_before_hol;
    }

    public static function getPermission($emp_id, $from_date, $to_date)
    {
        $day_num = EmpLeaveDetail::where('emp_id', $emp_id)
            ->whereDate('leave_date', '>=', $from_date)
            ->whereDate('leave_date', '<=', $to_date)
            ->where('approve', 1)
            ->sum('day_num');
        return $day_num > 0 ? $day_num : 0;
    }

    public static function getPermissionCal($emp_id, $from_date, $to_date)
    {
        $day_amt = EmpLeaveDetail::where('emp_id', $emp_id)
            ->whereDate('leave_date', '>=', $from_date)
            ->whereDate('leave_date', '<=', $to_date)
            ->where('approve', 0)
            ->sum('day_amt');

        return $day_amt > 0 ? $day_amt : 0;
    }


    public static function getAnnualLeave($emp_id, $from_date, $to_date)
    {
        $day_num = EmpLeaveDetail::where('emp_id', $emp_id)
            ->whereDate('leave_date', '>=', $from_date)
            ->whereDate('leave_date', '<=', $to_date)
            ->where('approve', 1)
            ->whereIn('leave_type', ['annual_leave', 'sick_leave', 'special_leave'])
            ->whereRaw("DAYNAME(leave_date) NOT IN ('Sunday') ")
            //  ->where('leave_type',">" ,0.5)
            ->sum('day_num');
        return $day_num > 0 ? $day_num : 0;
    }

    public static function getMM($emp_id, $day_for_working, $day_for_leave, $month)
    {//dd($month);
    //dd($emp_id,$day_for_leave,$day_for_working,$month);
        $rate_normal_working = 0;
        $rate_m_leave = 0;
        $total_n_w = 0;
        $total_m_l =0;
        $rate_allowance =0;
        $t_leave =0;
        $allowance =0;
        $total_amount = 0;
        $month = IDate::getLastDayMonth($month);
        //dd($month);
        $month = Carbon::parse($month)->format('d');
        $month = $month * 1;
        //dd($month);
        $day_for_working = $day_for_working * 1;
        if($day_for_working >=20){
            $day_for_working = 20;
        }else{
            $day_for_working = $day_for_working * 1;
        }
        $day_for_leave = $day_for_leave * 1;
        $emp = Employee::where('id', $emp_id)->first();
        $monthly_rate = $emp->getOriginal('monthly_rate');
        if($monthly_rate != null){
            $rate_allowance = Helper::getAfterRate2019();
            $rate_allowance = $rate_allowance/20;

            $rate_normal_working =  $monthly_rate / $month;
            $rate_normal_working = $rate_normal_working > 0 ? $rate_normal_working:0;

            $monthly_rate = $monthly_rate / 2;
            $rate_m_leave =  $monthly_rate / $month;
            $rate_m_leave = $rate_m_leave >0? $rate_m_leave:0;

            $total_n_w = $rate_normal_working * $day_for_working;
            $total_n_w = $total_n_w > 0 ? $total_n_w :0;

            $t_leave = $month - $day_for_working;
            $t_leave = $t_leave > 0? $t_leave :0;
            $total_m_l = $t_leave * $rate_m_leave;
            $total_m_l = $total_m_l > 0 ? $total_m_l :0;

            $total_amount  = round($total_n_w  + $total_m_l,2);
            $total_amount = $total_amount >0 ? $total_amount:0;


            $allowance = $day_for_working - $day_for_leave;
            //$allowance = $rate_allowance * $allowance;
            $allowance =$allowance >0 ? $allowance :0;
        }

        return [
            'total_amount' => $total_amount,
            'allowance'=>$allowance
        ];
    }

    public static function getMaterLongsick($from_date, $to_date)
    {
        $emp = EmpLeaveDetail::whereDate('leave_date', '>=', Carbon::parse($from_date)->format('Y-m-d'))
            ->whereDate('leave_date', '<=', Carbon::parse($to_date)->format('Y-m-d'))
            ->sum('day_amt');
        return $emp;
    }

    public static function getEmpResign2($emp_id, $f_year,$f_month)
    {

        //dd($to_date);
        $emp = Employee::where('id', $emp_id)
            ->where('status', 'Inactive')
            ->where(DB::raw("DATE_FORMAT(resign_date ,'%Y')"), $f_year)
            ->where(DB::raw("DATE_FORMAT(resign_date ,'%m')"), $f_month)
            ->first();
        return $emp;
    }
    public static function getEmpResign($emp_id, $from_date, $to_date)
    {
       // dd($emp_id,$to_date);
        $total_leave = 0;
        $to_date = dateAdd($to_date, 10);
        $y_month = Carbon::parse($to_date)->format('Y/m');
       // $y_month = '2019/09';
        //  dd($year);
        //dd($to_date);
        $emp = Employee::where('id',$emp_id)
            ->where('status','Inactive')
            ->where(DB::raw("DATE_FORMAT(resign_date ,'%Y/%m')"), $y_month)
            ->first();


        if ($emp != null) {

            $from_date = Carbon::parse($from_date)->format('Y-m-d');
            $from_date = IDate::getLastDayMonth($from_date);
            $from_date = dateAdd($from_date,1);

            $to_date = Carbon::parse($emp->resign_date)->format('Y-m-d');
            $last_day_m = IDate::getLastDayMonth($to_date);
            $leave_use = GenAttend::getTotalLeaveFirst($emp_id,$from_date,$to_date);

            $last_day_m = Carbon::parse($last_day_m)->format('d');
            $last_day_m = $last_day_m * 1;

            $monthly_rate = isset($emp->monthly_rate) ? $emp->monthly_rate: 0;
            $actual_working  = dateDiff($from_date,$to_date);
            //dd($to_date,$from_date,$leave_use, $emp_id);

            $monthly_rate = round(($monthly_rate / $last_day_m) * $actual_working - ($monthly_rate / 26) * $leave_use,2);
            $monthly_rate = $monthly_rate >0 ?$monthly_rate:0;
            return $monthly_rate;
        }
    }
    public static function getMaternityLeave_($emp_id, $from_date, $to_date)
    {
        //dd(Carbon::parse($from_date)->format('Y-m-d').' 00:00:00');
        //  dd($emp_id,$from_date, $to_date);
        $total_leave = 0;
//dd($emp_id);
        //dd($from_date,$to_date);
        $to_date = dateAdd($to_date, 10);
        $year = Carbon::parse($to_date)->format('Y');
        //  dd($year);
        $leave = EmpLeaveDetail::where('emp_id', $emp_id)
            ->where(DB::raw("DATE_FORMAT(leave_date ,'%Y')"), "$year")
            ->where('leave_type', 'maternity_leave')
            ->first();
        // dd($leave,$from_date,$to_date,$emp_id,$leave != null);

        if ($leave != null) {
            $year = Carbon::parse($leave->leave_date)->format('Y');
            // dd($year);
            $emp_leave = EmpLeave::where('emp_id', $emp_id)
                ->where(DB::raw("DATE_FORMAT(from_date ,'%Y')"), "$year")
                ->where('leave_type', 'maternity_leave')
                ->first();
            // dd($emp_leave,$from_date,$to_date);

            $l_from_date = Carbon::parse($emp_leave->from_date)->format('Y-m-d');
            $l_to_date = Carbon::parse($emp_leave->to_date)->format('Y-m-d');
            // dd($emp_id, $from_date, $to_date, $l_from_date, $l_to_date);
            $total_leave = self::MaternityLeave($emp_id, $from_date, $to_date, $l_from_date, $l_to_date);
            return $total_leave;
        }
    }

    public static function MaternityLeave($emp_id, $from_date, $to_date, $l_from_date, $l_to_date)
    {

        if (strtotime($from_date) <= strtotime($l_from_date) && strtotime($l_from_date) <= strtotime($to_date)) {
            //dd("asdf");
            $total_leave = 0;
            $total_actual_working = 0;

            $bs_work_amt_rate = 0;
            $bs_leave_amt_rate = 0;
            $allowance = 0;
            $salary_amt_leave = 0;
            $salary_amt_work = 0;
            $total_salary = 0;

            $from_date = $l_from_date;
            $to_date = IDate::getLastDayMonth($from_date);
            $last_day_month = Carbon::parse($to_date)->format('d');
            $last_day_month = $last_day_month * 1;
            $ot = self::getManualRequestOTFirst($emp_id, $from_date, $to_date);

            $total_leave = dateDiff($from_date, $to_date) + 1;
            $total_actual_working = $last_day_month - $total_leave;
            $total_leave = 28;
            $total_actual_working = 2;


            //dd($last_day_month , $total_leave,$total_actual_working,$emp_id);
            $emp = Employee::where('id', $emp_id)->first();
            $monthly_rate = $emp->monthly_rate > 0 ? $emp->monthly_rate : 0;
            $join_date = Carbon::parse($emp->joined_date)->format('Y');
            $join_date = $join_date * 1;
            $allowance_rate_b_2019 = Helper::getBeforeRate2019();
            $allowance_rate_b_2019 = $allowance_rate_b_2019 / 20;
            $allowance_rate_a_2019 = Helper::getAfterRate2019();
            $allowance_rate_a_2019 = $allowance_rate_a_2019 / 20;

            //dd($allowance_rate_a_2019,$allowance_rate_b_2019,$join_date < 2019);
            if ($total_leave != 0) {
                $bs_leave_amt_rate = ($monthly_rate / 2) / $last_day_month;
                $salary_amt_leave = $total_leave * $bs_leave_amt_rate;
            }
            if ($total_actual_working != 0) {

                if ($join_date < 2019) {
                    $allowance = $total_actual_working * $allowance_rate_b_2019;
                } else {
                    $allowance = $total_actual_working * $allowance_rate_a_2019;
                }
                $allowance = $allowance > 0 ? $allowance : 0;

                $bs_work_amt_rate = $monthly_rate / $last_day_month;
                $salary_amt_work = $bs_work_amt_rate * $total_actual_working;
            }
            $total_salary = ($salary_amt_work + $salary_amt_leave) / 2;

            //dd($total_salary, $allowance, $monthly_rate);
            return [
                'monthly_rate' => $total_salary,
                'day_for_meal' => $allowance,
                'ot' => $ot

            ];
        }
        if (strtotime($l_from_date) <= strtotime($from_date) && strtotime($to_date) <= strtotime($l_to_date)) {

            // dd("check last day of leave,$emp_id");
            // dd($from_date,$to_date);
            $emp_leave = EmpLeave::where('emp_id', $emp_id)
                ->where(DB::raw("DATE_FORMAT(from_date ,'%Y')"), "$year")
                ->where('leave_type', 'maternity_leave')
                ->first();
            $total_leave = 0;
            $total_actual_working = 0;

            $bs_work_amt_rate = 0;
            $bs_leave_amt_rate = 0;
            $allowance = 0;
            $salary_amt_leave = 0;
            $salary_amt_work = 0;
            $total_salary = 0;

            $from_date = $l_from_date;
            $to_date = IDate::getLastDayMonth($from_date);
            $last_day_month = Carbon::parse($to_date)->format('d');
            $last_day_month = $last_day_month * 1;
            $ot = self::getManualRequestOTFirst($emp_id, $from_date, $to_date);

            $total_leave = dateDiff($from_date, $to_date) + 1;
            $total_actual_working = $last_day_month - $total_leave;
            $total_leave = 28;
            $total_actual_working = 2;


            //dd($last_day_month , $total_leave,$total_actual_working,$emp_id);
            $emp = Employee::where('id', $emp_id)->first();
            $monthly_rate = $emp->monthly_rate > 0 ? $emp->monthly_rate : 0;
            $join_date = Carbon::parse($emp->joined_date)->format('Y');
            $join_date = $join_date * 1;
            $allowance_rate_b_2019 = Helper::getBeforeRate2019();
            $allowance_rate_b_2019 = $allowance_rate_b_2019 / 20;
            $allowance_rate_a_2019 = Helper::getAfterRate2019();
            $allowance_rate_a_2019 = $allowance_rate_a_2019 / 20;

            //dd($allowance_rate_a_2019,$allowance_rate_b_2019,$join_date < 2019);
            if ($total_leave != 0) {
                $bs_leave_amt_rate = ($monthly_rate / 2) / $last_day_month;
                $salary_amt_leave = $total_leave * $bs_leave_amt_rate;
            }
            if ($total_actual_working != 0) {

                if ($join_date < 2019) {
                    $allowance = $total_actual_working * $allowance_rate_b_2019;
                } else {
                    $allowance = $total_actual_working * $allowance_rate_a_2019;
                }
                $allowance = $allowance > 0 ? $allowance : 0;

                $bs_work_amt_rate = $monthly_rate / $last_day_month;
                $salary_amt_work = $bs_work_amt_rate * $total_actual_working;
            }
            $total_salary = ($salary_amt_work + $salary_amt_leave) / 2;

            //dd($total_salary, $allowance, $monthly_rate);
            return [
                'monthly_rate' => $total_salary,
                'day_for_meal' => $allowance,
                'ot' => $ot

            ];
        }
        if (strtotime($from_date) <= strtotime($l_to_date) && strtotime($l_to_date) <= strtotime($to_date)) {
            dd($emp_id, $from_date);
            //status leave = 0
            $from_date = $from_date;
            $last_day_month = IDate::getLastDayMonth($from_date);
            $to_date = $l_to_date;
            if (strtotime($last_day_month) >= strtotime($l_to_date)) {
                //dd($from_date,$to_date);

                $from_date = $last_day_month;
                $from_date = dateAdd($from_date, 1);
                $to_date = dateAdd($from_date, 9);

                $emp = Employee::where('id', $emp_id)->first();
                $monthly_rate = $emp->getOriginal('monthly_rate');
                $monthly_rate = $monthly_rate > 0 ? $monthly_rate : 0;

                $ot = null;
                $day_for_meal = 0;
            } else {

                $emp = Employee::where('id', $emp_id)->first();
                $monthly_rate = $emp->getOriginal('monthly_rate');
                $monthly_rate = round($monthly_rate / 2, 2);
                $monthly_rate = $monthly_rate > 0 ? $monthly_rate : 0;
                $ot = null;
                $day_for_meal = 0;
            }
            return [
                'monthly_rate' => $monthly_rate,
                'day_for_meal' => $day_for_meal,
                'ot' => $ot,

            ];

        }
    }

    public static function getMaternityLeaveGenSalary($emp_id, $from_date, $to_date)
    {
        //dd(Carbon::parse($from_date)->format('Y-m-d').' 00:00:00');
        //  dd($emp_id,$from_date, $to_date);
        $total_leave = 0;

        $leave = EmpLeaveDetail::where('emp_id', $emp_id)
            ->whereDate('leave_date', '>=', Carbon::parse($from_date)->format('Y-m-d'))
            ->whereDate('leave_date', '<=', Carbon::parse($to_date)->format('Y-m-d'))
            ->where('leave_type', 'maternity_leave')
            ->first();

        if ($leave != null) {
            $year = Carbon::parse($leave->leave_date)->format('Y');
            $year = $year * 1;
            $emp_leave = EmpLeave::where('emp_id', $emp_id)
                ->where(DB::raw("DATE_FORMAT(to_date ,'%Y')"), "$year")
                ->where('leave_type', 'maternity_leave')
                ->first();
            $l_from_date = Carbon::parse($emp_leave->from_date)->format('Y-m-d');
            $l_to_date = Carbon::parse($emp_leave->to_date)->format('Y-m-d');
            $total_leave = self::MaternityLeaveGenSalary($emp_id, $from_date, $to_date, $l_from_date, $l_to_date);
            return $total_leave;
        }
    }

    public static function MaternityLeaveGenSalary($emp_id, $from_date, $to_date, $l_from_date, $l_to_date)
    {

        $total_leave = 0;
        if (strtotime($from_date) <= strtotime($l_from_date) && strtotime($l_from_date) <= strtotime($to_date)) {
            //dd($l_from_date,$to_date,dateDiff($l_from_date,$to_date) + 1);
            $total_leave = dateDiff($l_from_date, $to_date) + 1;
            $from_date = $from_date;
            $to_date = dateAdd($l_from_date, -1);
            $day_for_meal = dateDiff($from_date, $to_date) + 1;
            // dd($from_date,$to_date,$day_for_meal);
            $sat_sun = self::getSat($from_date, $to_date);
            if (array($sat_sun)) {
                $total_sat_sun = $sat_sun['sun_sat'];
            }
            $hol = IDate::getHolidayAmt($from_date, $to_date);
            $leave_use = self::getTotalLeaveFirst($emp_id, $from_date, $to_date);
            $emp = Employee::where('id', $emp_id)->first();
            $joined_date = $emp->getOriginal('joined_date');
            $joined_date = Carbon::parse($joined_date)->format('Y') * 1;
            if ($joined_date < 2019) {
                $allowance_rate = Helper::getBeforeRate2019();
            } else {
                $allowance_rate = Helper::getAfterRate2019();
            }
            $day_for_meal = $day_for_meal - ($total_sat_sun + $hol + $leave_use);
            $allowance_rate = $allowance_rate / 20;
            $day_for_meal = round($day_for_meal * $allowance_rate, 2);

            $monthly_rate = $emp->getOriginal('monthly_rate');
            $monthly_rate = $monthly_rate > 0 ? $monthly_rate : 0;

            $ot = self::getManualRequestOTFirst($emp_id, $from_date, $to_date);
            return [
                'monthly_rate' => $monthly_rate,
                'day_for_meal' => $day_for_meal,
                'ot' => $ot,

            ];
        }
        if (strtotime($l_to_date) > strtotime($to_date)) {
            // >  15
            $total_leave = dateDiff($from_date, $to_date) + 1;

            $day_for_meal = 0;
            $emp = Employee::where('id', $emp_id)->first();
            $monthly_rate = $emp->getOriginal('monthly_rate');
            $monthly_rate = $monthly_rate > 0 ? $monthly_rate : 0;

            $ot = self::getManualRequestOTFirst($emp_id, $from_date, $to_date);
            return [
                'monthly_rate' => $monthly_rate,
                'day_for_meal' => $day_for_meal,
                'ot' => $ot,
            ];
        }
        if (strtotime($from_date) <= strtotime($l_to_date) && strtotime($l_to_date) <= strtotime($to_date)) {
            $total_leave = dateDiff($from_date, $l_to_date) + 1;
            //dd($from_date,$to_date,$l_from_date,$l_to_date,$l_to_date,$to_date);
            $from_date = dateAdd($l_to_date, 1);
            $to_date = $to_date;
            $day_for_meal = dateDiff($from_date, $to_date) + 1;
            //dd($from_date,$to_date,$day_for_meal);
            $sat_sun = self::getSat($from_date, $to_date);
            if (array($sat_sun)) {
                $total_sat_sun = $sat_sun['sun_sat'];
            }
            $hol = IDate::getHolidayAmt($from_date, $to_date);
            $leave_use = self::getTotalLeaveFirst($emp_id, $from_date, $to_date);
            $emp = Employee::where('id', $emp_id)->first();
            $joined_date = $emp->getOriginal('joined_date');
            $joined_date = Carbon::parse($joined_date)->format('Y') * 1;
            if ($joined_date < 2019) {
                $allowance_rate = Helper::getBeforeRate2019();
            } else {
                $allowance_rate = Helper::getAfterRate2019();
            }

            $day_for_meal = $day_for_meal - ($total_sat_sun + $hol + $leave_use);
            $allowance_rate = $allowance_rate / 20;
            $day_for_meal = round($day_for_meal * $allowance_rate, 2);


            $monthly_rate = $emp->getOriginal('monthly_rate');
            $monthly_rate = $monthly_rate > 0 ? $monthly_rate : 0;

            $ot = self::getManualRequestOTFirst($emp_id, $from_date, $to_date);
            return [
                'monthly_rate' => $monthly_rate,
                'day_for_meal' => $day_for_meal,
                'ot' => $ot,

            ];
        }
    }

    public static function getMaterLongsickAsc($emp_id, $from_date, $to_date)
    {
        $emp = EmpLeaveDetail::where('emp_id', $emp_id)
            ->whereDate('leave_date', '>=', $from_date)
            ->whereDate('leave_date', '<=', $to_date)
            ->whereIn('leave_type', ['long_sick_leave', 'maternity_leave', 'leave_without_pay'])
            ->orderBy('leave_date', 'ASC')
            ->first();
        return $emp != null ? $emp->leave_date : '';
    }

    public static function getNotAnnualLeave($emp_id, $from_date, $to_date)
    {
        $day_amt = EmpLeaveDetail::where('emp_id', $emp_id)
            ->whereDate('leave_date', '>=', Carbon::parse($from_date)->format('Y-m-d'))
            ->whereDate('leave_date', '<=', Carbon::parse($to_date)->format('Y-m-d'))
            ->where('leave_type', '<>', 'annual_leave')
            // ->where('approve', 1)
            ->sum('day_amt');

        return $day_amt > 0 ? $day_amt : 0;
    }

    public static function getTotalAnnualLeave($emp_id)
    {
        $day_amt = EmpLeaveDetail::where('emp_id', $emp_id)
//            ->whereDate('leave_date', '>=', Carbon::parse($from_date)->format('Y-m-d'))
//            ->whereDate('leave_date', '<=', Carbon::parse($to_date)->format('Y-m-d'))
            ->where('leave_type', 'special_leave')
            // ->where('approve', 1)
            ->sum('day_amt');

        return $day_amt > 0 ? $day_amt : 0;
    }

    public static function getTotalSpecialLeaveUse($emp_id, $year)
    {
        $day_amt = EmpLeaveDetail::where('emp_id', $emp_id)
            ->where(DB::raw("DATE_FORMAT(leave_date ,'%Y')"), "$year")
            ->where('leave_type', 'special_leave')
            // ->where('approve', 1)
            ->sum('day_amt');

        return $day_amt > 0 ? $day_amt : 0;
    }

    public static function getTotalAnnualLeaveUse($emp_id, $year)
    {
        $day_amt = EmpLeaveDetail::where('emp_id', $emp_id)
            ->where(DB::raw("DATE_FORMAT(leave_date ,'%Y')"), "$year")
            ->where('leave_type', 'annual_leave')
            // ->where('approve', 1)
            ->sum('day_amt');

        return $day_amt > 0 ? $day_amt : 0;
    }

    public static function getTotalSpecialLeave($emp_id, $year)
    {
        $leaveTotal = DB::table('emp_leave_total')
            ->select('*')
            ->where('emp_id', $emp_id)
            ->where('leave_year', $year)
            ->first();
        return $leaveTotal;
    }

    public static function getTotalAnnuallLeave($emp_id, $year)
    {
        $leaveTotal = DB::table('emp_leave_total')
            ->select('*')
            ->where('emp_id', $emp_id)
            ->where('leave_year', $year)
            ->first();
        return $leaveTotal;
    }

    public static function getTotalLeave($emp_id, $from_date, $to_date)
    {

        $total_day = EmpLeaveDetail::where('emp_id', $emp_id)
            ->whereDate('leave_date', '>=', Carbon::parse($from_date)->format('Y-m-d'))
            ->whereDate('leave_date', '<=', Carbon::parse($to_date)->format('Y-m-d'))
            ->where('approve', 1)
            ->sum('day_amt');

        return $total_day > 0 ? $total_day : 0;
    }

    public static function getTotalLeaveFirst($emp_id, $from_date, $to_date)
    {
        $total_day = EmpLeaveDetail::where('emp_id', $emp_id)
            ->whereDate('leave_date', '>=', Carbon::parse($from_date)->format('Y-m-d'))
            ->whereDate('leave_date', '<=', Carbon::parse($to_date)->format('Y-m-d'))
            ->where('approve', 1)
            ->sum('day_amt');

        return $total_day > 0 ? $total_day : 0;
    }

    public static function getTotalLeaveSecond($emp_id, $from_date, $to_date)
    {
        $to_date = Carbon::parse($to_date)->format('Y/m');
        $to_date = $to_date . '/26';
        $total_day = EmpLeaveDetail::where('emp_id', $emp_id)
            ->whereDate('leave_date', '>=', Carbon::parse($from_date)->format('Y-m-d'))
            ->whereDate('leave_date', '<=', Carbon::parse($to_date)->format('Y-m-d'))
            ->where('approve', 1)
            ->sum('day_amt');

        return $total_day > 0 ? $total_day : 0;
    }

    public static function getOnlyAnnualLeave($emp_id, $from_date, $to_date)
    {

        $day_amt = EmpLeaveDetail::where('emp_id', $emp_id)
            ->whereDate('leave_date', '>=', Carbon::parse($from_date)->format('Y-m-d'))
            ->whereDate('leave_date', '<=', Carbon::parse($to_date)->format('Y-m-d'))
            ->where('leave_type', 'annual_leave')
            ->where('approve', 1)
            ->sum('day_amt');

        return $day_amt > 0 ? $day_amt : 0;
    }

    public static function getAdvanceDayWork_($emp_id, $from_date, $to_date)
    {
        $total_date = 0;
        $_range = IDate::createDateRange($from_date, $to_date, $format = "Y-m-d");
        $total_date_range = IDate::dateDiff($from_date, $to_date) + 1;

        if (count($_range) > 0) {
            foreach ($_range as $date) {
                $att = \App\Models\TimeAttendGen::where('emp_id', $emp_id)
                    ->whereDate('att_date', '>=', Carbon::parse($from_date)->format('Y-m-d'))
                    ->whereDate('att_date', '<=', Carbon::parse($to_date)->format('Y-m-d'))
                    ->selectRaw(' TIME(cin) AS cin,  TIME(cout) AS cout,missing ')
                    ->first();
                $absent = 0;
                if ($att != null) {
                    if ($att->cin == '' || $att == '')
                        $absent += $att->missing;
                }
            }

        }

        if ($emp_id != null) {
            $pol_id = Employee::select(DB::raw('pol_id'))
                ->where('status', '=', 'Active')
                ->where('id', $emp_id)
                ->first();
        }

        if ($pol_id != null) {
            if ($pol_id->pol_id == 1) {
                $total_leave = self::getTotalLeave($emp_id, $from_date, $to_date);
                $total_hol = IDate::getHolidayAmt($from_date, $to_date);

                $total_sun = self::getSat($from_date, $to_date);
                if (is_array($total_sun)) {
                    $total_sun = $total_sun['sun_sat'];
                };
            }
        }
        //dd($absent);
        return $total_date_range - ($total_leave + $total_hol + $total_sun + $absent);
    }

    public static function getAdvanceDayWork($emp_id, $from_date, $to_date)
    {

        $_range = IDate::createDateRange($from_date, $to_date, null);

        $range = [];

        $total_h_ot = 0;


        if (count($_range) > 0) {
            foreach ($_range as $date) {
                //=================

                $em_policy = getOne("SELECT pol_id FROM em_dialy_policy WHERE 
                                                    emp_id = '{$emp_id}'
                                                    AND  DATE(pol_date) BETWEEN '{$date->format('Y-m-d')}' AND '{$date->format('Y-m-d')}'
                                                 ");
                if ($em_policy <= 0 || $em_policy == '') {
                    $__mmm = Employee::select('pol_id')->where('id', $emp_id)->first();
                    if ($__mmm != null) {
                        $em_policy = $__mmm->pol_id;
                    }
                }

                //=================
                $gethol = IDate::getHolidayAmt($date->format('Y-m-d'), $date->format('Y-m-d'));
                $annual_leave = \App\Models\GenAttend::getAnnualLeave($emp_id, $date->format('Y-m-d'), $date->format('Y-m-d'));

                $total_leave = $annual_leave > 0 ? $annual_leave * 480 : 0;
                $total_hol = $gethol > 0 ? $gethol * 480 : 0;

                $_data = \DB::select("SELECT
                                                      Sum(c.h_working_hour_day) as t_h_working_hour_day,
                                                     Sum(c.TOTALLATE) as t_total_late
                                                    FROM
                                                    em_checkinout AS c
                                                    WHERE DATE(c.normal_CHECKTIME) BETWEEN '{$date->format('Y-m-d')}'
                                                    AND '{$date->format('Y-m-d')}' AND
                                                     c.emp_id = '{$emp_id}' 
                                                     
                                                     GROUP BY
                                                     c.emp_id");
                $total_hour = 0;
                if ($_data != null) {
                    $data_ = $_data[0];
                    $total_hour = $data_->t_h_working_hour_day;

                }

                $getsun = IDate::getDayName($date->format('Y-m-d'));
                if ($em_policy == 4 || $em_policy == 7 || $em_policy == 8 || $em_policy == 12 || $em_policy == 13) {
                    // =========
                    $data_ot = \DB::select("SELECT
                                                    t.emp_id,
                                                    Sum(t.total) AS total_ot
                                                    FROM
                                                    em_checkinoutot AS t
                                                    WHERE DATE(t.normal_CHECKTIME) BETWEEN '{$date->format('Y-m-d')}' AND '{$date->format('Y-m-d')}'
                                                    AND t.emp_id = '{$emp_id}'
                                                    GROUP BY
                                                    t.emp_id");

                    //============ ot =============
                    $total_ot = 0;

                    if ($getsun != 'Sunday') {
                        if (is_array($data_ot) || is_object($data_ot)) {
                            if (count($data_ot) > 0) {
                                $data_ot = $data_ot[0];
                                $total_ot = $data_ot->total_ot;
                            }
                        }

                        if ($total_hol > 0) {
                            $total_leave = 0;
                        }
                        $total_h_ot += ($total_hour + $total_ot + $total_leave + $total_hol) >= 480 ? 480 : ($total_hour + $total_ot + $total_leave + $total_hol);

                    }
                } else {
                    if ($getsun != 'Sunday') {

                        if ($total_hol > 0) {

                            $total_leave = 0;
                        }

                        $total_h_ot += ($total_hour + $total_leave + $total_hol) >= 480 ? 480 : ($total_hour + $total_leave + $total_hol);
                    }
                }
            }
        }
        return $total_h_ot > 0 ? $total_h_ot : 0;
    }

    public static function getNightBonus($emp_id, $from_date, $to_date, $ots)
    {
        $_range = IDate::createDateRange($from_date, $to_date, null);
        $range = [];
        $bonus = 0;
        $total_hour = 0;
        if (count($_range) > 0) {
            foreach ($_range as $date) {
                $_data = \DB::select("SELECT
                                                      Sum(c.h_working_hour_day) as t_h_working_hour_day,
                                                     Sum(c.TOTALLATE) as t_total_late
                                                    FROM
                                                    em_checkinout AS c
                                                    WHERE DATE(c.normal_CHECKTIME) BETWEEN '{$date->format('Y-m-d')}'
                                                    AND '{$date->format('Y-m-d')}' AND
                                                     c.emp_id = '{$emp_id}' 
                                                     
                                                     GROUP BY
                                                     c.emp_id");
                $getsun = IDate::getDayName($date->format('Y-m-d'));
                $late = 0;
                $gethol = IDate::getHolidayAmt($date->format('Y-m-d'), $date->format('Y-m-d'));

                $annual_leave = self::getOnlyAnnualLeave($emp_id, $date->format('Y-m-d'), $date->format('Y-m-d'));
                $not_annl_leave = self::getNotAnnualLeave($emp_id, $date->format('Y-m-d'), $date->format('Y-m-d'));
                $annual_leave = $annual_leave * 8;

                if ($_data != null) {
                    $late_ = $_data[0];
                    $total_hour = $late_->t_h_working_hour_day + $ots;
                    $late = $late_->t_total_late;
                    $total_hour = $total_hour / 60;
                    if ($getsun != 'Sunday') {
                        if ($late > 0) {
                            if ($annual_leave + $total_hour >= 7) {
                                $bonus = 10;
                            } else {

                                return 0;
                            }

                        } else {
                            if ($gethol >= 1) {
                                $bonus = 10;
                            } else if ($gethol <= 0) {

                                if (($total_hour + $annual_leave) >= 7) {

                                    $bonus = 10;
                                } else {
                                    $bonus = 0;
                                    return $bonus;
                                }
                            }
                        }
                    }

                } else {
                    if ($getsun != 'Sunday') {
                        if ($gethol >= 1) {
                            $bonus = 10;
                        } else {
                            if ($annual_leave >= 8) {
                                $bonus = 10;
                            } else {

                                $bonus = 0;
                                return $bonus;
                            }

                        }

                    }

                }
            }
        }
        return $bonus;
    }

    public static function getBonus($emp_id, $from_date, $to_date)
    {
        $_range = IDate::createDateRange($from_date, $to_date, null);
        $range = [];
        $bonus = 0;
        $total_hour = 0;
        if (count($_range) > 0) {
            foreach ($_range as $date) {
                $_data = \DB::select("SELECT
                                                      Sum(c.h_working_hour_day) as t_h_working_hour_day,
                                                     Sum(c.TOTALLATE) as t_total_late
                                                    FROM
                                                    em_checkinout AS c
                                                    WHERE DATE(c.normal_CHECKTIME) BETWEEN '{$date->format('Y-m-d')}'
                                                    AND '{$date->format('Y-m-d')}' AND
                                                     c.emp_id = '{$emp_id}' 
                                                     
                                                     GROUP BY
                                                     c.emp_id");
                $getsun = IDate::getDayName($date->format('Y-m-d'));
                $late = 0;
                $gethol = IDate::getHolidayAmt($date->format('Y-m-d'), $date->format('Y-m-d'));

                $annual_leave = self::getOnlyAnnualLeave($emp_id, $date->format('Y-m-d'), $date->format('Y-m-d'));
                $not_annl_leave = self::getNotAnnualLeave($emp_id, $date->format('Y-m-d'), $date->format('Y-m-d'));
                $annual_leave = $annual_leave * 8;
                if ($_data != null) {
                    $late_ = $_data[0];
                    $total_hour = $late_->t_h_working_hour_day;
                    $late = $late_->t_total_late;
                    $total_hour = $total_hour / 60;
                    if ($getsun != 'Sunday') {
                        if ($gethol >= 1) {
                            $bonus = 10;
                        } else if ($gethol <= 0) {

                            if (($total_hour + $annual_leave) >= 8) {
                                //dd($total_hour + $annual_leave);
                                $bonus = 10;
                            } else {

                                $bonus = 0;
                                return $bonus;
                            }
                        }
                    }

                } else {
                    if ($getsun != 'Sunday') {
                        if ($gethol >= 1) {
                            $bonus = 10;
                        } else {
                            if ($annual_leave >= 8) {
                                $bonus = 10;
                            } else {
                                $bonus = 0;
                                return $bonus;
                            }

                        }

                    }

                }
            }
        }
        return $bonus;
    }

    public static function getOnlySickLeave($emp_id, $from_date, $to_date)
    {

        $day_amt = EmpLeaveDetail::where('emp_id', $emp_id)
            ->whereDate('leave_date', '>=', Carbon::parse($from_date)->format('Y-m-d'))
            ->whereDate('leave_date', '<=', Carbon::parse($to_date)->format('Y-m-d'))
            ->where('leave_type', 'sick_leave')
            ->where('approve', 1)
            ->sum('day_amt');

        return $day_amt > 0 ? $day_amt : 0;
    }


    public static function getMissing($emp_id, $from_date, $to_date)
    {
        return 0;
    }

    public static function getLate($emp_id, $from_date, $to_date)
    {
        return 0;
    }


    static function getOT($emp_id, $from_date, $to_date)
    {
        $ot_request_total = 0;
        $total_ot = TimeAttendGen::where('emp_id', $emp_id)
            ->whereDate('att_date', '>=', $from_date)
            ->whereDate('att_date', '<=', $to_date)
            //->where('ot_approve', 1)
            ->selectRaw('sum(total_ot) as tt_ot')
            ->selectRaw('sum(total_hol) as ot_hol')
            ->selectRaw('sum(total_sun) as ot_sun')
            ->first();

        $ot_request = self::getRequestOT($emp_id, $from_date, $to_date);

        if ($ot_request < 300) {
            $ot_request_total = $ot_request;
        } elseif ($ot_request >= 300 && $ot_request <= 780) { //+1
            $ot_request_total = $ot_request - 60;
        } elseif ($ot_request > 780 && $ot_request <= 1380) { //+2
            $ot_request_total = $ot_request - 120;
        } elseif ($ot_request > 1380 && $ot_request <= 1920) { //+3
            $ot_request_total = $ot_request - 180;
        } elseif ($ot_request > 1920 && $ot_request <= 2460) { //+4
            $ot_request_total = $ot_request - 240;
        } elseif ($ot_request > 2460 && $ot_request <= 3000) { //+5
            $ot_request_total = $ot_request - 300;
        } elseif ($ot_request > 3000 && $ot_request <= 3540) { //+6
            $ot_request_total = $ot_request - 360;
        } elseif ($ot_request > 3540 && $ot_request <= 4080) { //+7
            $ot_request_total = $ot_request - 420;
        }

        return [
            'ot_100' => ($total_ot != null ? round($total_ot->tt_ot / 60, 2) : 0),
            'ot_150' => 0,
            //'ot_200' => ($total_ot != null ? round($ot_request_total / 60, 2) : 0),
            'ot_200' => ($total_ot != null ? round($total_ot->tt_ot / 60, 2) : 0),
            'ot_sun_100' => 0,
            'ot_sun_150' => 0,
            'ot_sun_200' => ($total_ot != null ? round($total_ot->ot_sun / 60, 2) : 0),
            'ot_hol_100' => 0,
            'ot_hol_150' => 0,
            'ot_hol_200' => ($total_ot != null ? round($total_ot->ot_hol / 60, 2) : 0)
        ];
    }

    public static function getRequestOT($emp_id, $from_date, $to_date)
    {
        $total_ot = 0;
        $ot = RequestOTDetail::where('emp_id', $emp_id)
            ->whereDate('ot_date', '>=', $from_date)
            ->whereDate('ot_date', '<=', $to_date)
            ->whereRaw("DAYNAME(ot_date) NOT IN ('Saturday', 'Sunday') ")
            ->get();

        if ($ot != null) {
            if (is_array($ot) || is_object($ot)) {
                if ($ot != null && $ot != null) {
                    foreach ($ot as $rows) {
                        $total_ot += getTimDiffMinute($rows->time_in, $rows->time_out);
                    }
                }
            }
        }

        return $total_ot;

    }


    public static function getManualRequestOTSecond($emp_id, $from_date, $to_date)
    {
        // dd($emp_id,$from_date,$to_date);

        $to_date = Carbon::parse($to_date)->format('Y/m');
        $to_date = $to_date . '/25';
        $ot_sun_100 = ManualRequestOT::where('emp_id', $emp_id)
            ->whereDate('ot_date', '>=', $from_date)
            ->whereDate('ot_date', '<=', $to_date)
            ->where('ot_type', '=', 'sun_sat')
            ->where('ot_rate', 1)
            ->sum('total_hour');
        $ot_sun_150 = ManualRequestOT::where('emp_id', $emp_id)
            ->whereDate('ot_date', '>=', $from_date)
            ->whereDate('ot_date', '<=', $to_date)
            ->where('ot_type', '=', 'sun_sat')
            ->where('ot_rate', 1.5)
            ->sum('total_hour');
        $ot_sun_200 = ManualRequestOT::where('emp_id', $emp_id)
            ->whereDate('ot_date', '>=', $from_date)
            ->whereDate('ot_date', '<=', $to_date)
            ->where('ot_type', '=', 'sun_sat')
            ->where('ot_rate', 2)
            ->sum('total_hour');
        $ot_100 = ManualRequestOT::where('emp_id', $emp_id)
            ->whereDate('ot_date', '>=', $from_date)
            ->whereDate('ot_date', '<=', $to_date)
            ->where('ot_type', '=', 'normal')
            ->where('ot_rate', 1)
            ->sum('total_hour');
        $ot_150 = ManualRequestOT::where('emp_id', $emp_id)
            ->whereDate('ot_date', '>=', $from_date)
            ->whereDate('ot_date', '<=', $to_date)
            ->where('ot_type', '=', 'normal')
            ->where('ot_rate', 1.5)
            ->sum('total_hour');
        $ot_200 = ManualRequestOT::where('emp_id', $emp_id)
            ->whereDate('ot_date', '>=', $from_date)
            ->whereDate('ot_date', '<=', $to_date)
            ->where('ot_type', '=', 'normal')
            ->where('ot_rate', 2)
            ->sum('total_hour');
        $ot_hol_100 = ManualRequestOT::where('emp_id', $emp_id)
            ->whereDate('ot_date', '>=', $from_date)
            ->whereDate('ot_date', '<=', $to_date)
            ->where('ot_type', '=', 'hol')
            ->where('ot_rate', 1)
            ->sum('total_hour');
        $ot_hol_150 = ManualRequestOT::where('emp_id', $emp_id)
            ->whereDate('ot_date', '>=', $from_date)
            ->whereDate('ot_date', '<=', $to_date)
            ->where('ot_type', '=', 'hol')
            ->where('ot_rate', 1.5)
            ->sum('total_hour');
        $ot_hol_200 = ManualRequestOT::where('emp_id', $emp_id)
            ->whereDate('ot_date', '>=', $from_date)
            ->whereDate('ot_date', '<=', $to_date)
            ->where('ot_type', '=', 'hol')
            ->where('ot_rate', 2)
            ->sum('total_hour');
        $fix_ot_amount = ManualRequestOT::where('emp_id', $emp_id)
            ->whereDate('ot_date', '>=', $from_date)
            ->whereDate('ot_date', '<=', $to_date)
            ->where('ot_type', '=', 'other')
            ->sum('total_amount');
        return [
            'ot_100' => $ot_100 > 0 ? $ot_100 : 0,
            'ot_150' => $ot_150 > 0 ? $ot_150 : 0,
            'ot_200' => $ot_200 > 0 ? $ot_200 : 0,
            'ot_sun_100' => $ot_sun_100 > 0 ? $ot_sun_100 : 0,
            'ot_sun_150' => $ot_sun_150 > 0 ? $ot_sun_150 : 0,
            'ot_sun_200' => $ot_sun_200 > 0 ? $ot_sun_200 : 0,
            'ot_hol_100' => $ot_hol_100 > 0 ? $ot_hol_100 : 0,
            'ot_hol_150' => $ot_hol_150 > 0 ? $ot_hol_150 : 0,
            'ot_hol_200' => $ot_hol_200 > 0 ? $ot_hol_200 : 0,
            'fix_ot_amount' => $fix_ot_amount

        ];
    }

    public static function getManualRequestOTFirst($emp_id, $from_date, $to_date)
    {

        $ot_sun_100 = ManualRequestOT::where('emp_id', $emp_id)
            ->whereDate('ot_date', '>=', $from_date)
            ->whereDate('ot_date', '<=', $to_date)
            ->where('ot_type', '=', 'sun_sat')
            ->where('ot_rate', 1)
            ->sum('total_hour');
        $ot_sun_150 = ManualRequestOT::where('emp_id', $emp_id)
            ->whereDate('ot_date', '>=', $from_date)
            ->whereDate('ot_date', '<=', $to_date)
            ->where('ot_type', '=', 'sun_sat')
            ->where('ot_rate', 1.5)
            ->sum('total_hour');
        $ot_sun_200 = ManualRequestOT::where('emp_id', $emp_id)
            ->whereDate('ot_date', '>=', $from_date)
            ->whereDate('ot_date', '<=', $to_date)
            ->where('ot_type', '=', 'sun_sat')
            ->where('ot_rate', 2)
            ->sum('total_hour');
        $ot_100 = ManualRequestOT::where('emp_id', $emp_id)
            ->whereDate('ot_date', '>=', $from_date)
            ->whereDate('ot_date', '<=', $to_date)
            ->where('ot_type', '=', 'normal')
            ->where('ot_rate', 1)
            ->sum('total_hour');
        $ot_150 = ManualRequestOT::where('emp_id', $emp_id)
            ->whereDate('ot_date', '>=', $from_date)
            ->whereDate('ot_date', '<=', $to_date)
            ->where('ot_type', '=', 'normal')
            ->where('ot_rate', 1.5)
            ->sum('total_hour');
        $ot_200 = ManualRequestOT::where('emp_id', $emp_id)
            ->whereDate('ot_date', '>=', $from_date)
            ->whereDate('ot_date', '<=', $to_date)
            ->where('ot_type', '=', 'normal')
            ->where('ot_rate', 2)
            ->sum('total_hour');
        $ot_hol_100 = ManualRequestOT::where('emp_id', $emp_id)
            ->whereDate('ot_date', '>=', $from_date)
            ->whereDate('ot_date', '<=', $to_date)
            ->where('ot_type', '=', 'hol')
            ->where('ot_rate', 1)
            ->sum('total_hour');
        $ot_hol_150 = ManualRequestOT::where('emp_id', $emp_id)
            ->whereDate('ot_date', '>=', $from_date)
            ->whereDate('ot_date', '<=', $to_date)
            ->where('ot_type', '=', 'hol')
            ->where('ot_rate', 1.5)
            ->sum('total_hour');
        $ot_hol_200 = ManualRequestOT::where('emp_id', $emp_id)
            ->whereDate('ot_date', '>=', $from_date)
            ->whereDate('ot_date', '<=', $to_date)
            ->where('ot_type', '=', 'hol')
            ->where('ot_rate', 2)
            ->sum('total_hour');
        $fix_ot_amount = ManualRequestOT::where('emp_id', $emp_id)
            ->whereDate('ot_date', '>=', $from_date)
            ->whereDate('ot_date', '<=', $to_date)
            ->where('ot_type', '=', 'other')
            ->sum('total_amount');
        return [
            'ot_100' => $ot_100 > 0 ? $ot_100 : 0,
            'ot_150' => $ot_150 > 0 ? $ot_150 : 0,
            'ot_200' => $ot_200 > 0 ? $ot_200 : 0,
            'ot_sun_100' => $ot_sun_100 > 0 ? $ot_sun_100 : 0,
            'ot_sun_150' => $ot_sun_150 > 0 ? $ot_sun_150 : 0,
            'ot_sun_200' => $ot_sun_200 > 0 ? $ot_sun_200 : 0,
            'ot_hol_100' => $ot_hol_100 > 0 ? $ot_hol_100 : 0,
            'ot_hol_150' => $ot_hol_150 > 0 ? $ot_hol_150 : 0,
            'ot_hol_200' => $ot_hol_200 > 0 ? $ot_hol_200 : 0,
            'fix_ot_amount' => $fix_ot_amount

        ];
    }

    public static function getAdvanceSalary($emp_id, $f_y, $f_m)
    {
        $ot_100 = 0;
        $ot_150 = 0;
        $ot_200 = 0;
        $ot_sun_100 = 0;
        $ot_sun_150 = 0;
        $ot_sun_200 = 0;
        $ot_hol_100 = 0;
        $ot_hol_150 = 0;
        $ot_hol_200 = 0;
        $fix_ot_amount = 0;
        $advance_sal = 0;
        $meal_amt = 0;
        $f_y = $f_y * 1;
        $f_m = $f_m * 1;
        $total_salary_before = 0;

        $ot = AdvanceSalary::where('emp_id', $emp_id)
            ->where('f_year', $f_y)
            ->where('f_month', $f_m)
            ->first();
        if ($ot != null) {
            $ot_100 = $ot['ot_100'] > 0 ? $ot['ot_100'] : 0;
            $ot_150 = $ot['ot_150'] > 0 ? $ot['ot_150'] : 0;
            $ot_200 = $ot['ot_200'] > 0 ? $ot['ot_200'] : 0;

            $ot_sun_100 = $ot['ot_sun_100'] > 0 ? $ot['ot_sun_100'] : 0;
            $ot_sun_150 = $ot['ot_sun_150'] > 0 ? $ot['ot_sun_150'] : 0;
            $ot_sun_200 = $ot['ot_sun_200'] > 0 ? $ot['ot_sun_200'] : 0;

            $ot_hol_100 = $ot['ot_hol_100'] > 0 ? $ot['ot_hol_100'] : 0;
            $ot_hol_150 = $ot['ot_hol_150'] > 0 ? $ot['ot_hol_150'] : 0;
            $ot_hol_200 = $ot['ot_hol_200'] > 0 ? $ot['ot_hol_200'] : 0;

            $fix_ot_amount = $ot['fix_ot_amount'] > 0 ? $ot['fix_ot_amount'] : 0;
            $meal_amt = $ot['day_for_meal_b_month_amt'] > 0 ? $ot['day_for_meal_b_month_amt'] : 0;
            $advance_sal = $ot['advance_sal'] > 0 ? $ot['advance_sal'] : 0;

            $total_salary_before = $ot->net_pay > 0 ? $ot->net_pay : 0;

        }

        $ot_100 = $ot_100 > 0 ? $ot_100 : 0;
        $ot_150 = $ot_150 > 0 ? $ot_150 : 0;
        $ot_200 = $ot_200 > 0 ? $ot_200 : 0;
        $ot_sun_100 = $ot_sun_100 > 0 ? $ot_sun_100 : 0;
        $ot_sun_150 = $ot_sun_150 > 0 ? $ot_sun_150 : 0;
        $ot_sun_200 = $ot_sun_200 > 0 ? $ot_sun_200 : 0;
        $ot_hol_100 = $ot_hol_100 > 0 ? $ot_hol_100 : 0;
        $ot_hol_150 = $ot_hol_150 > 0 ? $ot_hol_150 : 0;
        $ot_hol_200 = $ot_hol_200 > 0 ? $ot_hol_200 : 0;
        $fix_ot_amount = $fix_ot_amount > 0 ? $fix_ot_amount : 0;

        $total_ot = $ot_100 + $ot_150 + $ot_200 +
            $ot_sun_100 + $ot_sun_150 + $ot_sun_200 +
            $ot_hol_100 + $ot_hol_150 + $ot_hol_200 + $fix_ot_amount;
        $meal_amt = $meal_amt > 0 ? $meal_amt : 0;
        $advance_sal = $advance_sal > 0 ? $advance_sal : 0;

        return [
            "total_ot" => $total_ot,
            "meal_amt" => $meal_amt,
            "advance_sal" => $advance_sal,
            'total_salary_before' => $total_salary_before
        ];
    }


    public
    static function getSat($from_date, $to_date)
    {
        $d_all = IDate::createDateRangeIncHoliday($from_date, $to_date);
        $total_sat = 0;
        $total_sun = 0;
        if (is_array($d_all)) {
            if (count($d_all) > 0) {
                foreach ($d_all as $d) {
                    if ($d['type'] == 's') {
                        $total_sat++;
                    } else if ($d['type'] == 'w') {
                        $total_sun++;
                    }
                }
            }
        }
        return [
            'sat' => $total_sat,
            'sun' => $total_sun,
            'sun_sat' => $total_sat + $total_sun
        ];

    }

    public
    static function getUseLeave($emp_id, $date)
    {
        $leaves = EmpLeaveDetail::where('emp_id', $emp_id)
            ->where(DB::raw("DATE_FORMAT(leave_date ,'%Y/%m')"), $date)
            ->select(DB::raw('SUM(day_num) as num_leave,leave_type,emp_id'))
            ->groupBy(DB::raw('leave_type,emp_id'))
            ->get();
        return $leaves;
    }

    public
    static function getLeaveByMonth($emp_id, $end_date, $y)
    {
        $all_date = self::getTotalMonth("$y/01/01", $end_date);
        $leave = 0;
        $total_leave = 0;
        $getYearLeave = self::getLeaveTotal($emp_id, $y);
        if ($all_date > 0) {
            $i = 0;
            for ($kk = 1; $kk <= $all_date; $kk++) {
                $i++;
                $total_ = 0;
                if ($i < 10) {
                    $i = "0$i";
                }
                $leaves = EmpLeaveDetail::where('emp_id', $emp_id)
                    ->where(DB::raw("DATE_FORMAT(leave_date ,'%Y/%m')"), "$y/$i")
                    ->where('leave_type', "annual_leave")
                    ->select(DB::raw('SUM(day_num) as num_leave'))
                    ->first();

                if ($i == 01) {
                    if ($getYearLeave != null) {
                        $getYearLeave = $getYearLeave->annual_leave > 18 ? $getYearLeave->annual_leave - 18 : 0;
                    }
                }
                if ($i > 01) {
                    if ($getYearLeave > 0) {
                        $total_leave = $total_leave - $getYearLeave;
                    }
                }
                if ($leaves != null) {
                    $leave = $leaves->num_leave;
                    if ($leave > 0) {
                        $total_ = 1.5 + $getYearLeave - $leave;
                    } else {
                        $total_ = 1.5 + $getYearLeave;
                    }
                    $total_leave = $total_leave + $total_;
                }
            }
        }
        return $total_leave > 0 ? $total_leave : 0;
    }

    public
    static function getAnnualLeaveByMonth($emp_id, $date)
    {
        $annual_leave_by_month = EmpLeaveDetail::where('emp_id', $emp_id)
            ->where(DB::raw("DATE_FORMAT(leave_date ,'%Y/%m')"), $date)
            ->where('leave_type', "annual_leave")
            ->select(DB::raw('SUM(day_num) as num_leave'))
            ->first();
        return $annual_leave_by_month;
    }

    public
    static function getTotalWork($emp_id, $month, $year)
    {
        $total_day = GenAttend::where('emp_id', $emp_id)
            ->where('f_year', $year)
            ->where('f_month', $month)
            ->sum('total_day_cal');
        return $total_day > 0 ? $total_day : 0;
    }

    public static function getSeniorityBonus($emp_id, $month, $year)
    {
        $amount = SeniorityBonus::where('emp_id', $emp_id)
            ->where('f_month', $month)
            ->where('f_year', $year)
            ->sum('amount');
        return $amount > 0 ? $amount : 0;
    }

    public static function getLongSickLeave($emp_id, $month, $year)
    {
        $month = $month * 1;
        $amount = EmpLongSickLeave::where('emp_id', $emp_id)
            ->where('f_month', $month)
            ->where('f_year', $year)
            ->sum('amount');
        return $amount > 0 ? $amount : 0;
    }

    public static function getLongSickLeave_($emp_id, $from_date, $to_date)
    {
        $amount = EmpLongSickLeave::where('emp_id', $emp_id)
            ->whereDate('date', '>=', $from_date)
            ->whereDate('date', '<=', $to_date)
            ->sum('amount');
        return [
            'monthly_rate' => $monthly_rate,
            'day_for_meal' => $day_for_meal,
            'ot' => $ot,

        ];

        dd($amount);
        return $amount > 0 ? $amount : 0;
    }

    public static function getImportIncentive($emp_id, $month, $year)
    {
        $amount = ImportIncentive::where('emp_id', $emp_id)
            ->where('f_month', $month)
            ->where('f_year', $year)
            ->sum('amount');
        return $amount > 0 ? $amount : 0;
    }

    public static function getMCClaim($emp_id, $month, $year)
    {
        $amount = MCClaim::where('emp_id', $emp_id)
            ->where('f_month', $month)
            ->where('f_year', $year)
            ->sum('amount');
        return $amount > 0 ? $amount : 0;
    }

    public static function getPhoneCard($emp_id, $month, $year)
    {
        $m = $month * 1;
        $amount = PhoneCard::where('emp_id', $emp_id)
            ->where('f_month', $m)
            ->where('f_year', $year)
            ->sum('amount');
        return $amount > 0 ? $amount : 0;
    }

    public static function getAllowance($emp_id, $month, $year)
    {
        //$m = $month * 1;
        $amount = EmpAllowance::where('emp_id', $emp_id)
            ->where('f_month', $month)
            ->where('f_year', $year)
            ->sum('amount');
        return $amount > 0 ? $amount : 0;
    }

    public static function getSeniorityS($emp_id, $month, $year)
    {
        //$m = $month * 1;
        $amount = Seniority::where('emp_id', $emp_id)
            ->where('f_month', $month)
            ->where('f_year', $year)
            ->sum('amount');
        return $amount > 0 ? $amount : 0;
    }

    public static function getBabyVoucher($emp_id, $month, $year)
    { //dd($emp_id);
        $m = $month * 1;
        $amount = BabyVoucher::where('emp_id', $emp_id)
            ->where('f_month', $m)
            ->where('f_year', $year)
            ->sum('amount');
        return $amount > 0 ? $amount : 0;
    }

    public static function getBirthdayVoucher($emp_id, $month, $year)
    {
        //$m = $month * 1;
        $amount = BirthdayVoucher::where('emp_id', $emp_id)
            ->where('f_month', $month)
            ->where('f_year', $year)
            ->sum('amount');
        return $amount > 0 ? $amount : 0;
    }

    public static function getOtherBenefit($emp_id, $month, $year)
    {
        //$m = $month * 1;
        $amount = OtherBenefit::where('emp_id', $emp_id)
            ->where('f_month', $month)
            ->where('f_year', $year)
            ->sum('amount');
        return $amount > 0 ? $amount : 0;
    }

    public static function getManualDeduction($emp_id, $month, $year)
    {
        //$m = $month * 1;
        $amount = ManualDeduction::where('emp_id', $emp_id)
            ->where('f_month', $month)
            ->where('f_year', $year)
            ->sum('amount');
        return $amount > 0 ? $amount : 0;
    }

    public static function getMaternityLeave($emp_id, $from_date, $to_date)
    {
        if ($emp_id != null && $to_date != null) {
            $date = dateAdd($to_date, 10);
            $month = Carbon::parse($date)->format('m');
            $year = Carbon::parse($date)->format('Y');

            $month = $month * 1;
            $year = $year * 1;

            $amount = EmpMaternity::where('emp_id', $emp_id)
                ->where('f_month', $month)
                ->where('f_year', $year)
                ->sum('amount');
            return $amount > 0 ? $amount : 0;
        }

    }

    public static function getMaternityLeave2($emp_id, $y_month)
    {

        if ($emp_id != null && $y_month != null) {
            $date = $y_month;
            $month = Carbon::parse($date)->format('m');
            $year = Carbon::parse($date)->format('Y');

            $month = $month * 1;
            $year = $year * 1;

            $amount = EmpMaternity::where('emp_id', $emp_id)
                ->selectRaw('amount,allowance')
                ->where('f_month', $month)
                ->where('f_year', $year)
                ->first();
            return $amount;
        }

    }

    public
    static function getTotalSickLeaveUse($emp_id, $date)
    {
        $annual_leave_by_month = EmpLeaveDetail::where('emp_id', $emp_id)
            ->where(DB::raw("DATE_FORMAT(leave_date ,'%Y/%m')"), $date)
            ->where('leave_type', "sick_leave")
            ->select(DB::raw('SUM(day_num) as num_leave'))
            ->first();
        return $annual_leave_by_month;
    }

    public
    static function getTotalMonth($from_date, $to_date)
    {
        // SELECT TIMESTAMPDIFF(MONTH, '2015-12-20', '2015-12-25') + 1 as t_m
        $sql = "SELECT TIMESTAMPDIFF(MONTH,'{$from_date}','{$to_date}') + 1 as d";
        $d = DB::select($sql);
        if (count($d) > 0) {
            return $d[0]->d;
        } else {
            return null;
        }
    }

    public
    static function getLeaveTotal($emp_id, $year)
    {
        $leaveTotal = DB::table('emp_leave_total')
            ->select('*')
            ->where('emp_id', $emp_id)
            ->where('leave_year', $year)
            ->first();
        return $leaveTotal;
    }


    public
    static function totalSickLeave($emp_id, $year)
    {
        $leave = DB::table('emp_leave_total')
            ->select(DB::raw('sick_leave'))
            ->where('emp_id', $emp_id)
            ->where(DB::raw('leave_year', '%Y'), $year)
            ->first();
        return $leave;

    }

    public
    static function getAttLeave($pol_id, $emp_id, $from_date, $to_date)
    {
        $d_all = IDate::createDateRange($from_date, $to_date);
        $total_p = 0;
        $whereDay = '';


        if (array($d_all)) {
            foreach ($d_all as $d) {
                if ($pol_id == 1) {
                    $d_work = TimeAttendGen::where('emp_id', $emp_id)
                        ->whereDate('att_date', $d)
                        ->whereRaw(" DAYNAME(att_date) NOT IN ('Saturday','Sunday') ")
                        ->groupBy(\DB::raw('DATE(att_date)'))
                        ->count(\DB::raw(' DISTINCT DATE(att_date) '));
                    if ($d_work > 0) {
                        $total_p++;
                    }

                }
//                else if ($pol_id == 3) {
//                    //  sat  & sun
//                    $d_work = TimeAttendGen::where('emp_id', $emp_id)
//                        ->whereDate('att_date', $d)
//                        ->whereRaw(" DAYNAME(attend) NOT IN ( 'Saturday','Sunday') ")
//                        ->groupBy(\DB::raw('DATE(att_date)'))
//                        ->count(\DB::raw(' DISTINCT DATE(att_date) '));
//                    if ($d_work > 0) {
//                        $total_p++;
//                    }
//                } else {
//                    //  all day
//                    $d_work = TimeAttendGen::where('emp_id', $emp_id)
//                        ->whereDate('att_date', $d)
//                        //  ->whereRaw(" DAYNAME(attend) NOT IN ( 'Saturday','Sunday') ")
//                        ->groupBy(\DB::raw('DATE(att_date)'))
//                        ->count(\DB::raw(' DISTINCT DATE(att_date) '));
//                    if ($d_work > 0) {
//                        $total_p++;
//                    }
//                }
            }
        }
        return $total_p;
    }

    public
    static function getOffDay($emp_id, $from_date, $to_date)
    {
        $d_all = IDate::createDateRange($from_date, $to_date);
        $total = 0;
        foreach ($d_all as $dates) {
            $day_work = OffDay::where('emp_id', $emp_id)
                ->whereDate('off_date', $dates)
                ->groupBy(DB::raw('DATE(off_date)'))
                ->count(DB::raw(' DISTINCT DATE(off_date)'));
            $total += $day_work;
        }
        return $total;
    }

    public
    static function getDayAs($emp_id, $dates)
    {
        $d_work = TimeAttendGen::where('emp_id', $emp_id)
            // ->whereDate('attend','>=',$from_date)
            ->whereDate('att_date', $dates)
            //  ->whereRaw(" DAYNAME(attend) NOT IN ('Saturday', 'Sunday') ")
            ->groupBy(\DB::raw('DATE(att_date)'))
            ->count(\DB::raw(' DISTINCT DATE(att_date) '));
        return $d_work;
    }


    public
    static function getdayOff($emp_id, $from_date, $to_date)
    {
        $d_all = IDate::createDateRangeIncHoliday($from_date, $to_date);
        $total_day = 0;
        foreach ($d_all as $d) {
            $total = self::getOfDay($emp_id, $d['date']);

            if ($total > 0) {
                $total_day++;
            }
        }
        return $total_day;
    }

    public
    static function getOfDay($emp_id, $dates)
    {
        $offDay = OffDay::where('emp_id', $emp_id)
            ->whereDate('off_date', $dates)
            ->groupBy(DB::raw('DATE(off_date)'))
            ->count(DB::raw(' DISTINCT DATE(off_date) '));
        return $offDay;
    }


    public
    static function getWorkingDay($emp_id, $from_date, $to_date)
    {
        $d_all = IDate::createDateRangeIncHoliday($from_date, $to_date);
        $getPol = Employee::where('id', $emp_id)->select('pol_id')->first();
        $pol1 = 0;
        if ($getPol != null) {
            $pol1 = $getPol->pol_id;
        }


        $totalWork = 0;
        $total_h = 0;
        $t = 0;
        if (is_array($d_all)) {
            if (count($d_all) > 0) {

                foreach ($d_all as $d) {

                    if ($pol1 != null) {

                        $dates = getDay($d['date']);
                        $pol_g = PolicyGroupDetail::select('pol_id')->where('date', $dates)->where("group_id", $pol1)->first();
                        if ($pol_g != null) {
                            $pol = $pol_g->pol_id;
                        }

                        if ($pol == 1) {

                            if ($d['type'] == 'h' || $d['type'] == 'w') {
                                $total_h++;
                            } else if ($d['type'] == 'n' || $d['type'] == 's') {
                                $working_day = TimeAttendGen::where('emp_id', $emp_id)
                                    ->whereDate('att_date', $d['date'])
                                    ->groupBy(\DB::raw('DATE(att_date)'))
//                                    ->whereRaw(" DAYNAME(att_date) NOT IN ( 'Sunday') ")
                                    ->count(\DB::raw(' DISTINCT DATE(att_date) '));
                                $total_offday = self::getOfDay($emp_id, $d['date']);
                                if ($working_day > 0 || $total_offday > 0) {
                                    $totalWork++;
                                } else {
                                    $getPermissionCal = self::getPermissionCal($emp_id, $d['date'], $d['date']);
                                    $totalWork = $totalWork + $getPermissionCal;
                                }

                            }

                        } else if ($pol == 2) {

                            if ($d['type'] == 'h' || $d['type'] == 'w') {
                                $total_h++;
                            } else if ($d['type'] == 'n' || $d['type'] == 's') {
                                $working_day = TimeAttendGen::where('emp_id', $emp_id)
                                    ->whereDate('att_date', $d['date'])
                                    ->groupBy(\DB::raw('DATE(att_date)'))
//                                    ->whereRaw(" DAYNAME(att_date) NOT IN ( 'Saturday') ")
                                    ->count(\DB::raw(' DISTINCT DATE(att_date) '));
                                $total_offday = self::getOfDay($emp_id, $d['date']);

                                if ($d['type'] == 's') {
                                    if ($working_day > 0 || $total_offday > 0) {
                                        $t += 0.5;
                                    }
                                } else {
                                    if ($working_day > 0 || $total_offday > 0) {
                                        $totalWork++;
                                    } else {
                                        $getPermissionCal = self::getPermissionCal($emp_id, $d['date'], $d['date']);
                                        $totalWork = $totalWork + $getPermissionCal;
                                    }
                                }

                            }


                        } else if ($pol == 3) {
                            if ($d['type'] == 'h' || $d['type'] == 'w' || $d['type'] == 's') {
                                $total_h++;
                            } else if ($d['type'] == 'n') {
                                $working_day = TimeAttendGen::where('emp_id', $emp_id)
                                    ->whereDate('att_date', $d['date'])
                                    ->groupBy(\DB::raw('DATE(att_date)'))
//                                    ->whereRaw(" DAYNAME(att_date) NOT IN ( 'Saturday') ")
                                    ->count(\DB::raw(' DISTINCT DATE(att_date) '));
                                $total_offday = self::getOfDay($emp_id, $d['date']);
                                if ($working_day > 0 || $total_offday > 0) {
                                    $totalWork++;
                                } else {
                                    $getPermissionCal = self::getPermissionCal($emp_id, $d['date'], $d['date']);
                                    $totalWork = $totalWork + $getPermissionCal;
                                }
                            }

                        } else if ($pol == 4 || $pol == 5 || $pol == 6 || $pol == 7 || $pol == 8 || $pol == 9 || $pol == 10 || $pol == 11 || $pol == 12 || $pol == 13 || $pol == 14 || $pol == 15) {
                            $offDay = OffDay::where('emp_id', $emp_id)
                                ->whereDate('off_date', $d['date'])
                                ->groupBy(\DB::raw('DATE(off_date)'))
                                ->count(\DB::raw(' DISTINCT DATE(off_date) '));


                            if ($offDay > 0 || $d['type'] == 'h') {
                                $total_h++;
                            } else if ($d['type'] == 'w' || $d['type'] == 's' || $d['type'] == 'n') {
                                $working_day = TimeAttendGen::where('emp_id', $emp_id)
                                    ->whereDate('att_date', $d['date'])
                                    ->groupBy(\DB::raw('DATE(att_date)'))
//                                    ->whereRaw(" DAYNAME(att_date) NOT IN ( 'Saturday',Sunday') ")
                                    ->count(\DB::raw(' DISTINCT DATE(att_date) '));

                                $total_offday = self::getOfDay($emp_id, $d['date']);
                                if ($working_day > 0 || $total_offday > 0) {
                                    $totalWork++;
                                } else {
                                    $getPermissionCal = self::getPermissionCal($emp_id, $d['date'], $d['date']);
                                    $totalWork = $totalWork + $getPermissionCal;
                                }
                            }
                        }
                    }
                }
            }
        }

        return $totalWork + $total_h + $t;
    }

    public
    static function countDayWork($from_date, $to_date)
    {
        $dd = IDate::createDateRangeIncHoliday($from_date, $to_date);
        $day_work = 0;
        if (array($dd)) {
            if (count(array($dd))) {
                foreach ($dd as $d) {
                    $day_work++;
                }
            }
        }
        return $day_work;
    }

    /*
    |--------------------------------------------------------------------------
    | RELATIONS
    |--------------------------------------------------------------------------
    */
    public
    function employee()
    {
        return $this->belongsTo('App\Models\Employee', 'emp_id');
    }

    /*
    |--------------------------------------------------------------------------
    | SCOPES
    |--------------------------------------------------------------------------
    */

    /*
    |--------------------------------------------------------------------------
    | ACCESORS
    |--------------------------------------------------------------------------
    */

    /*
    |--------------------------------------------------------------------------
    | MUTATORS
    |--------------------------------------------------------------------------
    */
}
