<?php

namespace App\Models\Hr;


use App\User;

class Employee extends User
{
    protected $table = 'users';

    function getName()
    {
        return $this->user_firstname.$this->user_lastname;
    }

    public static function getEmployeeWithJoinedDate($emp_id = null)
    {
        if ($emp_id)
        {
            return Self::select('id', 'joined_date')->where(function ($q) use($emp_id)
            {
                if ($emp_id != null)
                {
                    if (is_array($emp_id))
                    {
                        if (count($emp_id))
                        {
                            $q->whereIn('id', $emp_id);
                        }
                    }else{
                        $q->where('id', $emp_id);
                    }
                }
            })->whereNotNull('joined_date')->groupBy('id')->get();
        }
        return Self::select('id', 'joined_date')->whereNotNull('joined_date')->groupBy('id')->get();
    }

    function leave()
    {
            return $this->hasMany(EmpLeave::class, 'emp_id');
    }

    public function getFullNameAttribute()
    {
        return "{$this->user_firstname} {$this->user_lastname}";
    }

    public static function getEmp($request)
    {

        $from_date      = $request->from_date;
        $to_date        = $request->to_date;

        $emp_id         = $request->emp_id;
        $department_id  = $request->department_id;
        $branch_id      = $request->branch_id;
        $position_id    = $request->position_id;

        $_em = User::where('status', 1)
        ->where(function ($q) use($emp_id){
            if(is_array($emp_id)){
                if(count($emp_id)>0){
                    $q->whereIn('id',$emp_id);
                }
            }
        })
        ->where(function ($q) use ($branch_id){
            if(is_array($branch_id)){
                if(count($branch_id)>0){
                    $q->whereIn('branch_id', $branch_id);
                }
            }
        })
        ->where(function ($q) use ($department_id){
            if(is_array($department_id)){
                if(count($department_id)>0){
                    $q->whereIn('department_id', $department_id);
                }
            }
        })
        ->where(function ($q) use ($position_id){
            if(is_array($position_id)){
                if(count($position_id)>0){
                    $q->whereIn('position_id', $position_id);
                }
            }
        })
        ->orderBy('branch_id','ASC');

        $em = $_em->get();
        
        $id = [];
        if(count($em)>0){
            foreach ($em as $row){
                $id[] = $row->id;
            }

        }
        return ['em_id'=>$id,'rows'=>$em];
    }




}
