<?php
/**
 * Created by PhpStorm.
 * User: DEV1776
 * Date: 1/3/2020
 * Time: 4:00 PM
 */

namespace App\Models;
use Illuminate\Database\Eloquent\Builder;


use App\User;
use phpDocumentor\Reflection\Types\Self_;

class Employee extends User
{
    protected $table = 'users';


    function getName(){
        return $this->user_firstname.$this->user_lastname;
    }

    public static function getEmployeeWithJoinedDate($emp_id = null){
        if ($emp_id){
            Return Self::select('id', 'joined_date')->where(function ($q) use($emp_id){
                if ($emp_id != null){
                    if (is_array($emp_id)){
                        if (count($emp_id)){
                            $q->whereIn('id', $emp_id);
                        }
                    }else{
                        $q->where('id', $emp_id);
                    }
                }
            })->whereNotNull('joined_date')->groupBy('id')->get();
        }
        return Self::select('id', 'joined_date')->whereNotNull('joined_date')->groupBy('id')->get();
    }

   function leave(){
        return $this->hasMany(EmpLeave::class, 'emp_id');
   }

    public function getFullNameAttribute()
    {
        return "{$this->user_firstname} {$this->user_lastname}";
    }




}