<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use App\User;

class RedirectIfAuthenticated
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string|null  $guard
     * @return mixed
     */
    public function handle($request, Closure $next, $guard = null)
    {
        // if(Auth::check()) return redirect('/home');
        
        if (Auth::guard($guard)->check()) {
            return redirect('/');
        }
        //Check user status
        $user=User::where("email",$request->email)->first();
        if(!empty($user)){
            auth()->logout();
            if($user->status==0){
                return redirect()->route('login')->withError('Your account was blocked.');
            }elseif($user->status==2){
                return redirect()->route("login")->withError("Your account was deleted.");
            }
        }
        //End
        
        return $next($request);
    }
}
