<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\SupplierModel;
use Image;
use Crypt;

class SupplierController extends Controller
{
    function __construct()
    {
         $this->middleware('permission:Supplier-List', ['only' => ['index']]);
         $this->middleware('permission:Supplier-Create', ['only' => ['create','store']]);
         $this->middleware('permission:Supplier-Edit', ['only' => ['update']]);
    }
    public function index(){
        $suppliers=SupplierModel::all();
        return view("suppliers.index",['suppliers'=>$suppliers]);
    }
    public function create(){
        return view('suppliers.create');
    }
    public function store(Request $request){
        $this->validate($request,[
            'supp_name'=>'required',
            'supp_phone'=>'required'
        ]);
        $image = $request->file('photo');
        $imagename="";
        if($image){
            $input['imagename'] = "supplier".time().'.'.$image->getClientOriginalExtension();

            $destinationPath = public_path('/assets/img/upload');
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath.'/'.$input['imagename']);
            $imagename=$input['imagename'];
        }
        $supplier=new SupplierModel;
        $supplier->supp_name=$request->input('supp_name');
        $supplier->supp_phone=$request->input('supp_phone');
        $supplier->supp_des=$request->input('supp_des');
        $supplier->image = $imagename;
        $supplier->save();
        return redirect()->route('suppliers.index')->with('success','supplier created!');
    }
    public function edit($id)
    {
        $id=Crypt::decrypt($id);
        $supplier=SupplierModel::where("id",$id)->first();
        return view("suppliers.edit",compact('supplier'));
    }
    public function update(Request $request){
        $this->validate($request,[
            'supp_name'=>'required',
            'supp_phone'=>'required'
        ]);
        $id=$request->input('id');
        $supplier=SupplierModel::find($id);
        $photo = $request->file('image');
        $imagename="";
        if($photo){
            $imagename = time().'.'.$photo->getClientOriginalExtension();
            $destinationPath = public_path('/assets/img/upload');
            $img = Image::make($photo->getRealPath());
            $img->save($destinationPath.'/'.$imagename);
             $supplier->image=$imagename;
        }else{
            if(empty($request->cpImage))
                $supplier->image=$imagename;//empty or remove image
        }
        $supplier->supp_name=$request->input("supp_name");
        $supplier->supp_phone=$request->input("supp_phone");
        $supplier->supp_des = $request->supp_des;
        $supplier->save();
        return redirect()->route("suppliers.index");
    }
}
