<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use DataTables;
use Auth;
use App\SubCategories;
use App\User;
use Gate;

class SubCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
         $this->middleware('permission:Sub-Category-List', ['only' => ['index','get_subcategory']]);
         $this->middleware('permission:Sub-Category-Create', ['only' => ['create','store']]);
         $this->middleware('permission:Sub-Category-Edit', ['only' => ['edit','update']]);
         $this->middleware('permission:Sub-Category-Delete', ['only' => ['delete']]);
    }
    public function index()
    {
        return view("subcategory.index");
    }

    public function get_subcategory(Request $request)
    {
        if($request->isMethod('get')){
            $search = $request->input('search.value');
            $count_total =SubCategories::join("users","users.id","nso007_sub_category.user_id")
                            ->where("nso007_sub_category.status",1)
                            ->count();
            $count_filter =SubCategories::join("users","users.id","nso007_sub_category.user_id")
                            ->where(function($query) use ($search){
                                $query->orWhere('nso007_sub_category.name' , 'LIKE' , '%'.$search.'%');
                                $query->orWhere('nso007_sub_category.description' , 'LIKE' , '%'.$search.'%');
                            })
                            ->where("nso007_sub_category.status",1)
                            ->count();

            $category = SubCategories::select("nso007_sub_category.*")
                                ->orderBy('nso007_sub_category.id','asc')
                                ->where("nso007_sub_category.status",1)
                                ->take(20);
            return Datatables::of($category)
                ->addIndexColumn()
                ->setRowId('id')
                ->with([
                    "recordsTotal" => $count_total,
                     "recordsFiltered" => $count_filter,
                  ])
                ->addColumn('action',function($category){
                    $button="";
                    if(Gate::check('Sub-Category-Edit'))
                        $button.= ' <button class="btn btn-success btn-sm" data-toggle="modal" data-target="#" title="Edit" onclick="edit_category(this)"><i class="fas fa-edit"></i></button> ';
                    if(Gate::check('Sub-Category-Delete')){
                        if($category->delete_status==0){
                            $button .= ' <button type="button" disabled title="Delete" class="btn btn-sm btn-danger"><i class="fa fa-trash"></i></button>';
                        }elseif($category->delete_status==1){
                            $button .= ' <button type="button" data-toggle="modal" data-target="#modal-danger'.$category->id.'" title="Delete" class="btn btn-sm btn-danger"><i class="fa fa-trash"></i></button>
                             <div class="modal fade" id="modal-danger'.$category->id.'">
                                <form action="'.route("sub_category.delete",$category->id).'" method="GET" style="display:inline">
                              <div class="modal-dialog">
                                <div class="modal-content bg-danger">
                                  <div class="modal-header">
                                    <h4 class="modal-title">'.__("application.Delete")." ".__("application.Subcategory").'</h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                      <span aria-hidden="true">&times;</span>
                                    </button>
                                  </div>
                                  <div class="modal-body">
                                    <p style="font-size: 120%;">'.__("application.Are you sure want to delete this").' ?</p>
                                  </div>
                                  <div class="modal-footer justify-content-between">
                                    <a>&nbsp;</a>
                                    <button type="submit" class="btn btn-default btn-sm fa fa-save"> '.__("application.OK").'</button>
                                  </div>
                                </div>
                                <!-- /.modal-content -->
                              </div>
                              <!-- /.modal-dialog -->
                              </form>
                            </div>
                            <!-- /.modal -->
                            ';
                        }else{

                        }
                    }
                    
                    return $button;
                })
                ->rawColumns([
                    'action' => 'action',
                ])
                ->make(true); 
        }
        else{

            $id=$request->id;
            $data=SubCategories::where("id",$id)->first();
            return json_encode($data);

        }
        
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'name'=>'required|unique:nso007_sub_category,name'
            // 'code'=>'required|unique:nso007_category_stock,code'
        ]);
        $subcategory=new SubCategories;
        $subcategory->name=$request->name;
        $subcategory->description=$request->description;
        $subcategory->user_id=Auth::user()->id;
        $subcategory->save();

        User::where("id",Auth::user()->id)->update(['status_delete'=>0]);//couldn't delete user

        return redirect()->route("sub_category.index")->with("success","Create successfully !");
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'name'=>'required | unique:nso007_sub_category,name,'.$id
        ]);
        $Subcategory=SubCategories::find($id);
        $Subcategory->name=$request->name;
        $Subcategory->description=$request->des;
        $Subcategory->save();
        return json_encode(['id'=>$id,'name'=>$request->name,'description'=>$request->des]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        SubCategories::where("id",$id)->delete();
        return \back()->with("success","successfully !");
    }
}
