<?php

namespace App\Http\Controllers;

use App\AgencyModel;
use Illuminate\Http\Request;
use App\ItemModel;
use DataTables;
use DB;
use App\LoanProcessModel;
use App\LoanPaidModel;
use App\LoanModel;
use App\CommissionModel;
use App\CommissionHistoryModel;
use App\BlockModel;
use Auth;

class ReportController extends Controller
{
    function __construct()
    {
         $this->middleware('permission:Payment-Collection', ['only' => ['collection','get_collection']]);
         $this->middleware('permission:Payment-Collected', ['only' => ['collected','get_collected']]);
         $this->middleware('permission:Payment-Completed', ['only' => ['completed','get_completed']]);
         $this->middleware('permission:Client-Payment', ['only' => ['payment','get_payment']]);
         $this->middleware('permission:Commission', ['only' => ['commission','get_commission']]);
         $this->middleware('permission:Commission-History', ['only' => ['commission_history','get_commission_history']]);
         $this->middleware('permission:Item-Stock', ['only' => ['all_item','get_all_item']]);
         $this->middleware('permission:Item-Sold', ['only' => ['sold_item','get_sold_item']]);
    }
    /************Block Report Stock***************/
    public function all_item()
    {
    	$categories = DB::table("nso007_category_stock")->pluck("name","id");
    	$projects = DB::table("nso007_project_stock")->pluck("name","id");
    	$items = DB::table("nso007_item_stock")->pluck("name","id");
    	return view("report.report-stock.item",compact("categories","projects",'items'));
    }
    public function get_all_item(Request $request)
    {
    	if($request->isMethod("POST")){
            if(isset($request->request_type)){
                if($request->request_type=="project"){
                    $category_id = $request->category_id;
                    $project_id = $request->project_id;
                    $items = DB::table("nso007_item_stock")
                                ->when(request("category_id",""),function($query) use($category_id){
                                    $query->whereIn("nso007_item_stock.category_id",$category_id);
                                })
                                ->when(request("project_id",""),function($query) use($project_id){
                                    $query->whereIn("nso007_item_stock.project_id",$project_id);
                                })
                                ->get();
                    return json_encode($items);
                }
                if($request->request_type=="get-block"){
                    $data=BlockModel::whereIn("project_id",$request->project_id)->where("status",1)->get();
                    return json_encode($data);
                }
            }
        }else{
            $input=$request->all();
            $search = $request->input('search.value');
            $count_total =ItemModel::join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                            ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                            ->where("nso007_item_stock.status",1)
                            ->where("nso007_category_stock.status",1)
                            ->where("nso007_project_stock.status",1)
                            ->count();
            $count_filter =ItemModel::join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                            ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                            ->where(function($query) use ($search){
                                $query->orWhere('nso007_item_stock.name' , 'LIKE' , '%'.$search.'%');
                                $query->orWhere('nso007_item_stock.size' , 'LIKE' , '%'.$search.'%');
                                $query->orWhere('nso007_project_stock.name' , 'LIKE' , '%'.$search.'%');
                                $query->orWhere('nso007_category_stock.name' , 'LIKE' , '%'.$search.'%');
                            })
                            ->where(function($query) use ($input){
                                if(!empty($input['item_id']))
                                    $query->whereIn('nso007_item_stock.id' ,$input["item_id"]);
                                if(!empty($input['item_size']))
                                    $query->where('nso007_item_stock.size' , 'LIKE' , '%'.$input["item_size"].'%');
                                if(!empty($input['item_price']))
                                    $query->where('nso007_item_stock.price' , 'LIKE' , '%'.$input["item_price"].'%');
                                if(!empty($input['item_status'])){
                                    if($input['item_status']==0){

                                    }else{
                                        $query->whereIn('nso007_item_stock.stock_status', $input["item_status"]);
                                    }
                                }
                                if(!empty($input['project_id']))
                                    $query->whereIn('nso007_project_stock.id' ,$input['project_id']);
                                if(!empty($input['category_id']))
                                    $query->whereIn('nso007_category_stock.id' ,$input['category_id']);
                                if(!empty($input['block_id']))
                                    $query->whereIn('nso007_item_stock.block_id' ,$input['block_id']);
                            })
                            ->where("nso007_item_stock.status",1)
                            ->where("nso007_category_stock.status",1)
                            ->where("nso007_project_stock.status",1)
                            ->count();

            $items = ItemModel::join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                            ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                            ->where(function($query) use ($input){
                                if(!empty($input['item_id']))
                                    $query->whereIn('nso007_item_stock.id' ,$input["item_id"]);
                                if(!empty($input['item_size']))
                                    $query->where('nso007_item_stock.size' , 'LIKE' , '%'.$input["item_size"].'%');
                                if(!empty($input['item_price']))
                                    $query->where('nso007_item_stock.price' , 'LIKE' , '%'.$input["item_price"].'%');
                                if(!empty($input['item_status'])){
                                    if($input['item_status']==0){

                                    }else{
                                        $query->whereIn('nso007_item_stock.stock_status' ,$input["item_status"]);
                                    }
                                }
                                if(!empty($input['project_id']))
                                    $query->whereIn('nso007_project_stock.id' ,$input['project_id']);
                                if(!empty($input['category_id']))
                                    $query->whereIn('nso007_category_stock.id' ,$input['category_id']);
                                if(!empty($input['block_id']))
                                    $query->whereIn('nso007_item_stock.block_id' ,$input['block_id']);
                            })
                            ->select("nso007_item_stock.*","nso007_project_stock.name as project_name","nso007_category_stock.name as category_name")
                            ->where("nso007_item_stock.status",1)
                            ->where("nso007_category_stock.status",1)
                            ->where("nso007_project_stock.status",1)
                            ->orderBy('nso007_item_stock.id','asc')
                            ->take(20);
            return Datatables::of($items)
                ->addIndexColumn()
                ->with([
                    "recordsTotal" => $count_total,
                     "recordsFiltered" => $count_filter,
                  ])
                  ->editColumn('price',function($items){
                    return "$".number_format($items->price,2);
                })
                ->editColumn('cost',function($items){
                    return "$".number_format($items->cost,2);
                })
                ->editColumn('block',function($items){
                    return BlockModel::find($items->block_id)->name;
                })
                ->addColumn("status",function($items){
                    if($items->stock_status==1) return "In Stock";
                    if($items->stock_status==2) return "Out Stock";
                })
                ->make(true);
        }
    }
    public function sold_item()
    {
        $categories = DB::table("nso007_category_stock")->pluck("name","id");
        $projects = DB::table("nso007_project_stock")->pluck("name","id");
        $items = DB::table("nso007_item_stock")->pluck("name","id");
        return view('report.report-stock.item-sold',compact("categories","projects",'items'));
    }
    public function get_sold_item(Request $request)
    {
    	if($request->isMethod("POST")){
            if(isset($request->request_type)){
                if($request->request_type=="project"){
                    $category_id = $request->category_id;
                    $project_id = $request->project_id;
                    $items = DB::table("nso007_item_stock")
                                ->when(request("category_id",""),function($query) use($category_id){
                                    $query->whereIn("nso007_item_stock.category_id",$category_id);
                                })
                                ->when(request("project_id",""),function($query) use($project_id){
                                    $query->whereIn("nso007_item_stock.project_id",$project_id);
                                })
                                ->where("nso007_item_stock.stock_status",2)
                                ->get();
                    return json_encode($items);
                }
            }
        }else{
            $search = $request->input('search.value');
            $input=$request->all();
            $count_total =ItemModel::join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                            ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                            ->where("nso007_item_stock.status",1)
                            ->where("nso007_category_stock.status",1)
                            ->where("nso007_project_stock.status",1)
                            ->where("nso007_item_stock.stock_status",2)
                            ->count();
            $count_filter =ItemModel::join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                            ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                            ->where(function($query) use ($search){
                                $query->orWhere('nso007_item_stock.name' , 'LIKE' , '%'.$search.'%');
                                $query->orWhere('nso007_item_stock.size' , 'LIKE' , '%'.$search.'%');
                                $query->orWhere('nso007_project_stock.name' , 'LIKE' , '%'.$search.'%');
                                $query->orWhere('nso007_category_stock.name' , 'LIKE' , '%'.$search.'%');
                            })
                            ->where(function($query) use ($input){
                                if(!empty($input['item_id']))
                                    $query->whereIn('nso007_item_stock.id' ,$input["item_id"]);
                                if(!empty($input['item_size']))
                                    $query->where('nso007_item_stock.size' , 'LIKE' , '%'.$input["item_size"].'%');
                                if(!empty($input['item_price']))
                                    $query->where('nso007_item_stock.price' , 'LIKE' , '%'.$input["item_price"].'%');
                                if(!empty($input['item_cost'])){
                                    $query->where('nso007_item_stock.cost' , 'LIKE' , '%'.$input["item_cost"].'%');
                                }
                                if(!empty($input['project_id']))
                                    $query->whereIn('nso007_project_stock.id' ,$input['project_id']);
                                if(!empty($input['category_id']))
                                    $query->whereIn('nso007_category_stock.id' ,$input['category_id']);
                                if(!empty($input['block_id']))
                                    $query->whereIn('nso007_item_stock.block_id' ,$input['block_id']);
                                if(!empty($input['item_status'])){
                                    if($input['item_status']==0){

                                    }else{
                                        $query->whereIn('nso007_item_stock.sale_stock' , $input["item_status"]);
                                    }
                                }
                            })
                            ->where("nso007_item_stock.status",1)
                            ->where("nso007_category_stock.status",1)
                            ->where("nso007_project_stock.status",1)
                            ->where("nso007_item_stock.stock_status",2)
                            ->count();

            $items = ItemModel::join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                            ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                                ->select("nso007_item_stock.*","nso007_project_stock.name as project_name","nso007_category_stock.name as category_name")
                                ->where("nso007_item_stock.status",1)
                                ->where("nso007_category_stock.status",1)
                                ->where("nso007_project_stock.status",1)
                                ->where("nso007_item_stock.stock_status",2)
                                ->where(function($query) use ($input){
                                    if(!empty($input['item_id']))
                                        $query->whereIn('nso007_item_stock.id' ,$input["item_id"]);
                                    if(!empty($input['item_size']))
                                        $query->where('nso007_item_stock.size' , 'LIKE' , '%'.$input["item_size"].'%');
                                    if(!empty($input['item_price']))
                                        $query->where('nso007_item_stock.price' , 'LIKE' , '%'.$input["item_price"].'%');
                                    if(!empty($input['item_cost'])){
                                        $query->where('nso007_item_stock.cost' , 'LIKE' , '%'.$input["item_cost"].'%');
                                    }
                                    if(!empty($input['project_id']))
                                        $query->whereIn('nso007_project_stock.id' ,$input['project_id']);
                                    if(!empty($input['category_id']))
                                        $query->whereIn('nso007_category_stock.id' ,$input['category_id']);
                                    if(!empty($input['block_id']))
                                        $query->whereIn('nso007_item_stock.block_id' ,$input['block_id']);
                                    if(!empty($input['item_status'])){
                                        if($input['item_status']==0){

                                        }else{
                                            $query->whereIn('nso007_item_stock.sale_stock',$input["item_status"]);
                                        }
                                    }
                                })
                                ->orderBy('nso007_item_stock.id','asc')
                                ->take(20);
            return Datatables::of($items)
                ->addIndexColumn()
                ->with([
                    "recordsTotal" => $count_total,
                     "recordsFiltered" => $count_filter,
                  ])
                ->editColumn('price',function($items){
                    return "$".number_format($items->price,2);
                })
                ->editColumn('cost',function($items){
                    return "$".number_format($items->cost,2);
                })
                ->addColumn("status",function($items){
                    if($items->sale_stock==1) return "Deposit";
                    if($items->sale_stock==2) return "Sale Installment";
                })
                ->make(true);
        }
    }
    /************End Block Report Stock*************/

    /************Block Report Operation*************/

    public function collection(){
        $categories = DB::table("nso007_category_stock")->pluck("name","id");
        $projects = DB::table("nso007_project_stock")->pluck("name","id");
        $items = DB::table("nso007_item_stock")->pluck("name","id");
        $payment_policy = DB::table("nso007_payment_policy_detail")->join("nso007_payment_policy","nso007_payment_policy.id","nso007_payment_policy_detail.policy_id")->select("nso007_payment_policy_detail.id",DB::raw("CONCAT(nso007_payment_policy.name,' : ',nso007_payment_policy_detail.name) as payment_policy_name"))->pluck("payment_policy_name","id");
        return view('report.operation.collection',compact("categories","projects",'items','payment_policy'));
    }
    public function get_collection(Request $request)
    {
        if($request->isMethod("POST")){
            if(isset($request->request_type)){
                if($request->request_type=="project"){
                    $category_id = $request->category_id;
                    $project_id = $request->project_id;
                    $items = DB::table("nso007_item_stock")
                                ->when(request("category_id",""),function($query) use($category_id){
                                    $query->where("nso007_item_stock.category_id",$category_id);
                                })
                                ->when(request("project_id",""),function($query) use($project_id){
                                    $query->where("nso007_item_stock.project_id",$project_id);
                                })
                                ->where("nso007_item_stock.stock_status",2)
                                ->get();
                    return json_encode($items);
                }
            }
        }else{
            $search = $request->input('search.value');
            $input=$request->all();
            $count_total =LoanProcessModel::join("nso007_loan","nso007_loan.id","nso007_loan_process.loan_id")
                    // ->join("nso007_sale_detail_stock","nso007_loan.sale_id","nso007_sale_detail_stock.sale_id")
                    // ->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
                    // ->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                    // ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                    ->join("nso007_client","nso007_client.id","nso007_loan.client_id")
                    // ->where("nso007_item_stock.status",1)
                    ->where("nso007_loan.status",1)
                    // ->where("nso007_sale_detail_stock.status",1)
                    // ->where("nso007_category_stock.status",1)
                    // ->where("nso007_project_stock.status",1)
                    ->where("nso007_client.status",1)
                    ->where("nso007_loan_process.status",1)
                    ->where("nso007_loan_process.owe_amount_pay",">",0)
                    ->count();
            $count_filter =LoanProcessModel::join("nso007_loan","nso007_loan.id","nso007_loan_process.loan_id")
                    ->join("nso007_sale_stock","nso007_sale_stock.id","nso007_loan.sale_id")
                    ->join("nso007_sale_detail_stock","nso007_loan.sale_id","nso007_sale_detail_stock.sale_id")
                    ->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
                    ->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                    ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                    ->join("nso007_client","nso007_client.id","nso007_loan.client_id")
                    ->where("nso007_item_stock.status",1)
                    ->where("nso007_loan.status",1)
                    ->where("nso007_sale_detail_stock.status",1)
                    ->where("nso007_category_stock.status",1)
                    ->where("nso007_project_stock.status",1)
                    ->where("nso007_client.status",1)
                    ->where("nso007_loan_process.status",1)
                    ->where("nso007_loan_process.owe_amount_pay",">",0)
                    ->where(function($query) use ($search){
                        $query->orWhere('nso007_item_stock.name' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_item_stock.size' , 'LIKE' , '%'.$search.'%');
                        // $query->orWhere('nso007_project_stock.name' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_category_stock.name' , 'LIKE' , '%'.$search.'%');
                    })
                    ->where(function($query) use ($input){
                        if(!empty($input['item_id']))
                            $query->whereIn('nso007_item_stock.id' ,$input["item_id"]);
                        if(!empty($input['project_id']))
                            $query->whereIn('nso007_project_stock.id' ,$input['project_id']);
                        if(!empty($input['category_id']))
                            $query->whereIn('nso007_category_stock.id' ,$input['category_id']);
                        if(!empty($input['client_gender']))
                            $query->where('nso007_client.gender' , 'LIKE' , '%'.$input["client_gender"].'%');
                        if(!empty($input['client_name']))
                            $query->where('nso007_client.name' , 'LIKE' , '%'.$input["client_name"].'%');
                        if(!empty($input['client_phone'])){
                            $query->where('nso007_client.phone' , 'LIKE' , '%'.$input["client_phone"].'%');
                        }
                        if(!empty($input['payment_policy'])){
                            $query->whereIn('nso007_sale_stock.policy_payment_detail_id' ,$input['payment_policy']);
                        }
                        if(!empty($input['start_date'])&&!empty($input["end_date"])){
                            $query->whereBetween("date_payment",[date("Y-m-d",strtotime($input['start_date'])),date("Y-m-d",strtotime($input['end_date']))]);
                        }
                        if(!empty($input['last_months'])){
                            $query->whereBetween("date_payment",\Globals::the_last_month($input['last_months']));
                        }
                    })
                    ->groupBy("nso007_loan_process.id")
                    ->get();

            $collections = LoanProcessModel::join("nso007_loan","nso007_loan.id","nso007_loan_process.loan_id")
                    ->join("nso007_sale_stock","nso007_sale_stock.id","nso007_loan.sale_id")
                    ->join("nso007_sale_detail_stock","nso007_loan.sale_id","nso007_sale_detail_stock.sale_id")
                    ->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
                    ->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                    ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                    ->join("nso007_client","nso007_client.id","nso007_loan.client_id")
                    ->where("nso007_item_stock.status",1)
                    ->where("nso007_loan.status",1)
                    ->where("nso007_sale_detail_stock.status",1)
                    ->where("nso007_category_stock.status",1)
                    ->where("nso007_project_stock.status",1)
                    ->where("nso007_client.status",1)
                    ->where("nso007_loan_process.status",1)
                    ->where("nso007_loan_process.owe_amount_pay",">",0)
                    ->where(function($query) use ($input){
                        if(!empty($input['item_id']))
                            $query->whereIn('nso007_item_stock.id' ,$input["item_id"]);
                        if(!empty($input['project_id']))
                            $query->whereIn('nso007_project_stock.id' ,$input['project_id']);
                        if(!empty($input['category_id']))
                            $query->whereIn('nso007_category_stock.id' ,$input['category_id']);
                        if(!empty($input['client_gender']))
                            $query->where('nso007_client.gender' , 'LIKE' , '%'.$input["client_gender"].'%');
                        if(!empty($input['client_name']))
                            $query->where('nso007_client.name' , 'LIKE' , '%'.$input["client_name"].'%');
                        if(!empty($input['client_phone'])){
                            $query->where('nso007_client.phone' , 'LIKE' , '%'.$input["client_phone"].'%');
                        }
                        if(!empty($input['payment_policy'])){
                            $query->whereIn('nso007_sale_stock.policy_payment_detail_id' ,$input['payment_policy']);
                        }
                        if(!empty($input['start_date'])&&!empty($input["end_date"])){
                            $query->whereBetween("date_payment",[date("Y-m-d",strtotime($input['start_date'])),date("Y-m-d",strtotime($input['end_date']))]);
                        }
                        if(!empty($input['last_months'])){
                            $query->whereBetween("date_payment",\Globals::the_last_month($input['last_months']));
                        }
                    })
                    ->select(
                        "nso007_loan.sale_id",
                        "nso007_loan_process.*",
                        "nso007_client.name as client_name",
                        "nso007_client.phone as client_phone",
                        "nso007_client.gender as client_gender",
                        "nso007_category_stock.name as category_name",
                        "nso007_project_stock.name as project_name",
                        DB::raw("GROUP_CONCAT(nso007_item_stock.name) as item_name"),
                        "nso007_sale_stock.policy_payment_id",
                        "nso007_sale_stock.policy_payment_detail_id",
                    )
                    ->groupBy("nso007_loan_process.id")
                    ->take(20);
            return Datatables::of($collections)
                ->addIndexColumn()
                ->with([
                    "recordsTotal" => $count_total,
                     "recordsFiltered" => !empty($count_filter)?count($count_filter):0,
                  ])
                ->editColumn("date_payment",function($collections){
                    if(empty($collections->date_payment)) return "";
                    else return date("d-m-Y",strtotime($collections->date_payment));
                })
                ->editColumn("principle_pay",function($collections){
                    return "$".number_format($collections->principle_pay,2);
                })
                ->editColumn("interest_amount_pay",function($collections){
                    return "$".number_format($collections->interest_amount_pay,2);
                })
                ->editColumn("owe_amount_pay",function($collections){
                    return "$".number_format($collections->owe_amount_pay,2);
                })
                ->editColumn('payment_policy',function($collections){
                    $payment_policy = DB::table("nso007_payment_policy")->where("id",$collections->policy_payment_id)->first();
                    $payment_policy_detail = DB::table("nso007_payment_policy_detail")->where("id",$collections->policy_payment_detail_id)->first();
                    $data = "";
                    if(isset($payment_policy)&&!empty($payment_policy)&&!empty($payment_policy->name)){
                        if(isset($payment_policy_detail)&&!empty($payment_policy_detail)&&!empty($payment_policy_detail->name))
                            $data = optional($payment_policy)->name." : ".optional($payment_policy_detail)->name;
                        else $data = optional($payment_policy)->name;
                    }else{
                        $data = "";
                    }
                    return $data;
                })
                ->editColumn('item_name',function($collections)
                {
                    $sale_item = DB::table("nso007_sale_detail_stock")->where("sale_id",$collections->sale_id)->select("item_id")->get();
                    $item_names="";
                    foreach ($sale_item as $key => $value) {
                        $item_names.=DB::table("nso007_item_stock")->where("id",$value->item_id)->select("name")->first()->name;
                        if(isset($sale_item[$key+1])) $item_names.=",";
                    }
                    return $item_names;
                })
                ->make(true);
        }
    }

    public function collected(){
        $categories = DB::table("nso007_category_stock")->pluck("name","id");
        $projects = DB::table("nso007_project_stock")->pluck("name","id");
        $items = DB::table("nso007_item_stock")->pluck("name","id");
        return view('report.operation.collected',compact("categories","projects",'items'));
    }
    public function get_collected(Request $request)
    {
        if($request->isMethod("POST")){
            if(isset($request->request_type)){
                if($request->request_type=="project"){
                    $category_id = $request->category_id;
                    $project_id = $request->project_id;
                    $items = DB::table("nso007_item_stock")
                                ->when(request("category_id",""),function($query) use($category_id){
                                    $query->where("nso007_item_stock.category_id",$category_id);
                                })
                                ->when(request("project_id",""),function($query) use($project_id){
                                    $query->where("nso007_item_stock.project_id",$project_id);
                                })
                                ->where("nso007_item_stock.stock_status",2)
                                ->get();
                    return json_encode($items);
                }
            }
        }else{
            $input=$request->all();
            $search = $request->input('search.value');
            $count_total =LoanPaidModel::join("nso007_loan_process","nso007_loan_process.id","nso007_loan_paid.loan_process_id")->join("nso007_loan","nso007_loan.id","nso007_loan_process.loan_id")
                    // ->join("nso007_sale_detail_stock","nso007_loan.sale_id","nso007_sale_detail_stock.sale_id")
                    // ->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
                    // ->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                    // ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                    ->join("nso007_client","nso007_client.id","nso007_loan.client_id")
                    // ->where("nso007_item_stock.status",1)
                    ->where("nso007_loan.status",1)
                    // ->where("nso007_sale_detail_stock.status",1)
                    // ->where("nso007_category_stock.status",1)
                    // ->where("nso007_project_stock.status",1)
                    // ->where("nso007_item_stock.status",1)
                    ->where("nso007_client.status",1)
                    ->where("nso007_loan_process.status",1)
                    ->where("nso007_loan_paid.status",1)
                    // ->groupBy("nso007_loan_paid.id")
                    ->count();
            $count_filter =LoanPaidModel::join("nso007_loan_process","nso007_loan_process.id","nso007_loan_paid.loan_process_id")->join("nso007_loan","nso007_loan.id","nso007_loan_process.loan_id")
                    ->join("nso007_sale_detail_stock","nso007_loan.sale_id","nso007_sale_detail_stock.sale_id")
                    ->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
                    ->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                    ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                    ->join("nso007_client","nso007_client.id","nso007_loan.client_id")
                    ->where("nso007_item_stock.status",1)
                    ->where("nso007_loan.status",1)
                    ->where("nso007_sale_detail_stock.status",1)
                    ->where("nso007_category_stock.status",1)
                    ->where("nso007_project_stock.status",1)
                    ->where("nso007_item_stock.status",1)
                    ->where("nso007_client.status",1)
                    ->where("nso007_loan_process.status",1)
                    ->where("nso007_loan_paid.status",1)
                    ->where(function($query) use ($search){
                        $query->orWhere('nso007_item_stock.name' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_item_stock.size' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_project_stock.name' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_category_stock.name' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_client.name' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_client.phone' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_client.gender' , 'LIKE' , '%'.$search.'%');
                    })
                    ->where(function($query) use ($input){
                        if(!empty($input['item_id']))
                            $query->whereIn('nso007_item_stock.id' ,$input["item_id"]);
                        if(!empty($input['project_id']))
                            $query->whereIn('nso007_project_stock.id' ,$input['project_id']);
                        if(!empty($input['category_id']))
                            $query->whereIn('nso007_category_stock.id' ,$input['category_id']);
                        if(!empty($input['client_gender']))
                            $query->where('nso007_client.gender' , 'LIKE' , '%'.$input["client_gender"].'%');
                        if(!empty($input['client_name']))
                            $query->where('nso007_client.name' , 'LIKE' , '%'.$input["client_name"].'%');
                        if(!empty($input['client_phone'])){
                            $query->where('nso007_client.phone' , 'LIKE' , '%'.$input["client_phone"].'%');
                        }
                        if(!empty($input['start_date'])&&!empty($input["end_date"])){
                            $query->whereBetween("payment_date",[date("Y-m-d",strtotime($input['start_date'])),date("Y-m-d",strtotime($input['end_date']))]);
                        }
                        if(!empty($input['last_months'])){
                            $query->whereBetween("payment_date",\Globals::the_last_month($input['last_months']));
                        }
                    })
                    ->groupBy("nso007_loan_paid.id")
                    ->get();

            $collected = LoanPaidModel::join("nso007_loan_process","nso007_loan_process.id","nso007_loan_paid.loan_process_id")->join("nso007_loan","nso007_loan.id","nso007_loan_process.loan_id")
                    ->join("nso007_sale_detail_stock","nso007_loan.sale_id","nso007_sale_detail_stock.sale_id")
                    ->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
                    ->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                    ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                    ->join("nso007_client","nso007_client.id","nso007_loan.client_id")
                    ->where("nso007_item_stock.status",1)
                    ->where("nso007_loan.status",1)
                    ->where("nso007_sale_detail_stock.status",1)
                    ->where("nso007_category_stock.status",1)
                    ->where("nso007_project_stock.status",1)
                    ->where("nso007_item_stock.status",1)
                    ->where("nso007_client.status",1)
                    ->where("nso007_loan_process.status",1)
                    ->where("nso007_loan_paid.status",1)
                    ->where(function($query) use ($input){
                        if(!empty($input['item_id']))
                            $query->whereIn('nso007_item_stock.id' ,$input["item_id"]);
                        if(!empty($input['project_id']))
                            $query->whereIn('nso007_project_stock.id' ,$input['project_id']);
                        if(!empty($input['category_id']))
                            $query->whereIn('nso007_category_stock.id' ,$input['category_id']);
                        if(!empty($input['client_gender']))
                            $query->where('nso007_client.gender' , 'LIKE' , '%'.$input["client_gender"].'%');
                        if(!empty($input['client_name']))
                            $query->where('nso007_client.name' , 'LIKE' , '%'.$input["client_name"].'%');
                        if(!empty($input['client_phone'])){
                            $query->where('nso007_client.phone' , 'LIKE' , '%'.$input["client_phone"].'%');
                        }
                        if(!empty($input['start_date'])&&!empty($input["end_date"])){
                            $query->whereBetween("payment_date",[date("Y-m-d",strtotime($input['start_date'])),date("Y-m-d",strtotime($input['end_date']))]);
                        }
                        if(!empty($input['last_months'])){
                            $query->whereBetween("payment_date",\Globals::the_last_month($input['last_months']));
                        }
                    })
                    ->select(
                        "nso007_loan.sale_id",
                        "nso007_loan_paid.*",
                        "nso007_client.name as client_name",
                        "nso007_client.phone as client_phone",
                        "nso007_client.gender as client_gender",
                        "nso007_category_stock.name as category_name",
                        "nso007_project_stock.name as project_name",
                        DB::raw("GROUP_CONCAT(nso007_item_stock.name) as item_name")
                    )
                    ->groupBy("nso007_loan_paid.id")
                    ->take(20);
            return Datatables::of($collected)
                ->addIndexColumn()
                ->with([
                    "recordsTotal" => $count_total,
                     "recordsFiltered" => !empty($count_filter)?count($count_filter):0,
                  ])
                ->editColumn("payment_date",function($collected){
                    return date("d-m-Y",strtotime($collected->payment_date));
                })
                ->editColumn("principle",function($collected){
                    return "$".number_format($collected->principle,2);
                })
                ->editColumn("interest",function($collected){
                    return "$".number_format($collected->interest,2);
                })
                ->editColumn("penalty",function($collected){
                    return "$".number_format($collected->penalty,2);
                })
                ->editColumn("total_amount",function($collected){
                    return "$".number_format($collected->total_amount,2);
                })
                ->editColumn('item_name',function($collected)
                {
                    $sale_item = DB::table("nso007_sale_detail_stock")->where("sale_id",$collected->sale_id)->select("item_id")->get();
                    $item_names="";
                    foreach ($sale_item as $key => $value) {
                        $item_names.=DB::table("nso007_item_stock")->where("id",$value->item_id)->select("name")->first()->name;
                        if(isset($sale_item[$key+1])) $item_names.=",";
                    }
                    return $item_names;
                })
                ->make(true);
        }
    }


    public function completed(){
        $categories = DB::table("nso007_category_stock")->pluck("name","id");
        $projects = DB::table("nso007_project_stock")->pluck("name","id");
        $items = DB::table("nso007_item_stock")->pluck("name","id");
        return view('report.operation.completed',compact("categories","projects",'items'));
    }
    public function get_completed(Request $request)
    {
        if($request->isMethod("POST")){
            if(isset($request->request_type)){
                if($request->request_type=="project"){
                    $category_id = $request->category_id;
                    $project_id = $request->project_id;
                    $items = DB::table("nso007_item_stock")
                                ->when(request("category_id",""),function($query) use($category_id){
                                    $query->where("nso007_item_stock.category_id",$category_id);
                                })
                                ->when(request("project_id",""),function($query) use($project_id){
                                    $query->where("nso007_item_stock.project_id",$project_id);
                                })
                                ->where("nso007_item_stock.stock_status",2)
                                ->get();
                    return json_encode($items);
                }
            }
        }else{
            $input=$request->all();
            $search = $request->input('search.value');
            $count_total =LoanModel::join("nso007_client","nso007_client.id","nso007_loan.client_id")
                    ->where("nso007_loan.status",1)
                    ->where("nso007_client.status",1)
                    ->where("nso007_loan.amount_os","<=",1)
                    ->groupBy("nso007_loan.id")
                    ->count();
            $count_filter =LoanModel::join("nso007_sale_detail_stock","nso007_loan.sale_id","nso007_sale_detail_stock.sale_id")
                    ->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
                    ->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                    ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                    ->join("nso007_client","nso007_client.id","nso007_loan.client_id")
                    ->where("nso007_item_stock.status",1)
                    ->where("nso007_loan.status",1)
                    ->where("nso007_sale_detail_stock.status",1)
                    ->where("nso007_category_stock.status",1)
                    ->where("nso007_project_stock.status",1)
                    ->where("nso007_item_stock.status",1)
                    ->where("nso007_client.status",1)
                    ->where("nso007_loan.amount_os","<=",1)
                    ->where(function($query) use ($search){
                        $query->orWhere('nso007_item_stock.name' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_item_stock.size' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_project_stock.name' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_category_stock.name' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_client.name' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_client.phone' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_client.gender' , 'LIKE' , '%'.$search.'%');
                    })
                    ->where(function($query) use ($input){
                        if(!empty($input['item_id']))
                            $query->whereIn('nso007_item_stock.id' ,$input["item_id"]);
                        if(!empty($input['project_id']))
                            $query->whereIn('nso007_project_stock.id' ,$input['project_id']);
                        if(!empty($input['category_id']))
                            $query->whereIn('nso007_category_stock.id' ,$input['category_id']);
                        if(!empty($input['client_gender']))
                            $query->where('nso007_client.gender' , 'LIKE' , '%'.$input["client_gender"].'%');
                        if(!empty($input['client_name']))
                            $query->where('nso007_client.name' , 'LIKE' , '%'.$input["client_name"].'%');
                        if(!empty($input['client_phone'])){
                            $query->where('nso007_client.phone' , 'LIKE' , '%'.$input["client_phone"].'%');
                        }
                        if(!empty($input['start_date'])&&!empty($input["end_date"])){
                            $query->whereBetween("diburment_date",[date("Y-m-d",strtotime($input['start_date'])),date("Y-m-d",strtotime($input['end_date']))]);
                        }
                        if(!empty($input['last_months'])){
                            $query->whereBetween("diburment_date",\Globals::the_last_month($input['last_months']));
                        }
                    })
                    ->groupBy("nso007_loan.id")
                    ->count();

            $completed = LoanModel::join("nso007_sale_detail_stock","nso007_loan.sale_id","nso007_sale_detail_stock.sale_id")
                    ->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
                    ->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                    ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                    ->join("nso007_client","nso007_client.id","nso007_loan.client_id")
                    ->where("nso007_item_stock.status",1)
                    ->where("nso007_loan.status",1)
                    ->where("nso007_sale_detail_stock.status",1)
                    ->where("nso007_category_stock.status",1)
                    ->where("nso007_project_stock.status",1)
                    ->where("nso007_item_stock.status",1)
                    ->where("nso007_client.status",1)
                    ->where("nso007_loan.amount_os","<=",1)
                    ->where(function($query) use ($input){
                        if(!empty($input['item_id']))
                            $query->whereIn('nso007_item_stock.id' ,$input["item_id"]);
                        if(!empty($input['project_id']))
                            $query->whereIn('nso007_project_stock.id' ,$input['project_id']);
                        if(!empty($input['category_id']))
                            $query->whereIn('nso007_category_stock.id' ,$input['category_id']);
                        if(!empty($input['client_gender']))
                            $query->where('nso007_client.gender' , 'LIKE' , '%'.$input["client_gender"].'%');
                        if(!empty($input['client_name']))
                            $query->where('nso007_client.name' , 'LIKE' , '%'.$input["client_name"].'%');
                        if(!empty($input['client_phone'])){
                            $query->where('nso007_client.phone' , 'LIKE' , '%'.$input["client_phone"].'%');
                        }
                        if(!empty($input['start_date'])&&!empty($input["end_date"])){
                            $query->whereBetween("diburment_date",[date("Y-m-d",strtotime($input['start_date'])),date("Y-m-d",strtotime($input['end_date']))]);
                        }
                        if(!empty($input['last_months'])){
                            $query->whereBetween("diburment_date",\Globals::the_last_month($input['last_months']));
                        }
                    })
                    ->select(
                        "nso007_loan.*",
                        "nso007_client.name as client_name",
                        "nso007_client.phone as client_phone",
                        "nso007_client.gender as client_gender",
                        "nso007_category_stock.name as category_name",
                        "nso007_project_stock.name as project_name",
                        DB::raw("GROUP_CONCAT(DISTINCT nso007_item_stock.name) as item_name")
                    )
                    ->groupBy("nso007_loan.id")
                    ->take(20);
            return Datatables::of($completed)
                ->addIndexColumn()
                ->with([
                    "recordsTotal" => $count_total,
                     "recordsFiltered" => $count_filter,
                  ])
                ->editColumn("diburment_date",function($completed){
                    return date("d-m-Y",strtotime($completed->diburment_date));
                })
                ->editColumn("interest",function($completed){
                    return $completed->interest."%";
                })
                ->editColumn("duration",function($completed){
                    return $completed->duration." Months";
                })
                ->editColumn("sale_amount",function($completed){
                    return "$".number_format($completed->sale_amount,2);
                })
                ->editColumn("discount_amount",function($completed){
                    return "$".number_format($completed->discount_amount,2);
                })
                ->editColumn("sale_price",function($completed){
                    return "$".number_format($completed->sale_amount-$completed->discount_amount,2);
                })
                ->editColumn('item_name',function($collections)
                {
                    $sale_item = DB::table("nso007_sale_detail_stock")->where("sale_id",$collections->sale_id)->select("item_id")->get();
                    $item_names="";
                    foreach ($sale_item as $key => $value) {
                        $item_names.=DB::table("nso007_item_stock")->where("id",$value->item_id)->select("name")->first()->name;
                        if(isset($sale_item[$key+1])) $item_names.=",";
                    }
                    return $item_names;
                })
                ->make(true);
        }
    }
    public function payment(){
        $categories = DB::table("nso007_category_stock")->pluck("name","id");
        $projects = DB::table("nso007_project_stock")->pluck("name","id");
        $items = DB::table("nso007_item_stock")->pluck("name","id");
        return view('report.operation.payment',compact("categories","projects",'items'));
    }
    public function get_payment(Request $request)
    {
        if($request->isMethod("POST")){
            if(isset($request->request_type)){
                if($request->request_type=="project"){
                    $category_id = $request->category_id;
                    $project_id = $request->project_id;
                    $items = DB::table("nso007_item_stock")
                                ->when(request("category_id",""),function($query) use($category_id){
                                    $query->where("nso007_item_stock.category_id",$category_id);
                                })
                                ->when(request("project_id",""),function($query) use($project_id){
                                    $query->where("nso007_item_stock.project_id",$project_id);
                                })
                                ->where("nso007_item_stock.stock_status",2)
                                ->get();
                    return json_encode($items);
                }
            }
        }else{
            $input=$request->all();
            $search = $request->input('search.value');
            $count_total =LoanModel::join("nso007_client","nso007_client.id","nso007_loan.client_id")
                    ->where("nso007_loan.status",1)
                    ->where("nso007_client.status",1)
                    ->count();
            $count_filter =LoanModel::join("nso007_sale_detail_stock","nso007_loan.sale_id","nso007_sale_detail_stock.sale_id")
                    ->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
                    ->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                    ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                    ->join("nso007_client","nso007_client.id","nso007_loan.client_id")
                    ->where("nso007_item_stock.status",1)
                    ->where("nso007_loan.status",1)
                    ->where("nso007_sale_detail_stock.status",1)
                    ->where("nso007_category_stock.status",1)
                    ->where("nso007_project_stock.status",1)
                    ->where("nso007_client.status",1)
                    ->where(function($query) use ($search){
                        $query->orWhere('nso007_item_stock.name' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_item_stock.size' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_project_stock.name' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_category_stock.name' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_client.name' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_client.phone' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_client.gender' , 'LIKE' , '%'.$search.'%');
                    })
                    ->where(function($query) use ($input){
                        if(!empty($input['item_id']))
                            $query->whereIn('nso007_item_stock.id' ,$input["item_id"]);
                        if(!empty($input['project_id']))
                            $query->whereIn('nso007_project_stock.id' ,$input['project_id']);
                        if(!empty($input['category_id']))
                            $query->whereIn('nso007_category_stock.id' ,$input['category_id']);
                        if(!empty($input['client_gender']))
                            $query->where('nso007_client.gender' , 'LIKE' , '%'.$input["client_gender"].'%');
                        if(!empty($input['client_name']))
                            $query->where('nso007_client.name' , 'LIKE' , '%'.$input["client_name"].'%');
                        if(!empty($input['client_phone'])){
                            $query->where('nso007_client.phone' , 'LIKE' , '%'.$input["client_phone"].'%');
                        }
                        if(!empty($input['start_date'])&&!empty($input["end_date"])){
                            $query->whereBetween("diburment_date",[date("Y-m-d",strtotime($input['start_date'])),date("Y-m-d",strtotime($input['end_date']))]);
                        }
                        if(!empty($input['last_months'])){
                            $query->whereBetween("diburment_date",\Globals::the_last_month($input['last_months']));
                        }
                    })
                    ->groupBy("nso007_loan.sale_id")
                    ->get();

            $payment = LoanModel::join("nso007_sale_detail_stock","nso007_loan.sale_id","nso007_sale_detail_stock.sale_id")
                    ->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
                    ->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                    ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                    ->join("nso007_client","nso007_client.id","nso007_loan.client_id")
                    ->where("nso007_item_stock.status",1)
                    ->where("nso007_loan.status",1)
                    ->where("nso007_sale_detail_stock.status",1)
                    ->where("nso007_category_stock.status",1)
                    ->where("nso007_project_stock.status",1)
                    ->where("nso007_client.status",1)
                    ->where(function($query) use ($input){
                        if(!empty($input['item_id']))
                            $query->whereIn('nso007_item_stock.id' ,$input["item_id"]);
                        if(!empty($input['project_id']))
                            $query->whereIn('nso007_project_stock.id' ,$input['project_id']);
                        if(!empty($input['category_id']))
                            $query->whereIn('nso007_category_stock.id' ,$input['category_id']);
                        if(!empty($input['client_gender']))
                            $query->where('nso007_client.gender' , 'LIKE' , '%'.$input["client_gender"].'%');
                        if(!empty($input['client_name']))
                            $query->where('nso007_client.name' , 'LIKE' , '%'.$input["client_name"].'%');
                        if(!empty($input['client_phone'])){
                            $query->where('nso007_client.phone' , 'LIKE' , '%'.$input["client_phone"].'%');
                        }
                        if(!empty($input['start_date'])&&!empty($input["end_date"])){
                            $query->whereBetween("diburment_date",[date("Y-m-d",strtotime($input['start_date'])),date("Y-m-d",strtotime($input['end_date']))]);
                        }
                        if(!empty($input['last_months'])){
                            $query->whereBetween("diburment_date",\Globals::the_last_month($input['last_months']));
                        }
                    })
                    ->select(
                        "nso007_loan.*",
                        "nso007_client.name as client_name",
                        "nso007_client.phone as client_phone",
                        "nso007_client.gender as client_gender",
                        "nso007_category_stock.name as category_name",
                        "nso007_project_stock.name as project_name",
                        DB::raw("GROUP_CONCAT(DISTINCT nso007_item_stock.name) as item_name")
                    )
                    ->groupBy("nso007_loan.sale_id")
                    ->take(20);
            return Datatables::of($payment)
                ->addIndexColumn()
                ->with([
                    "recordsTotal" => $count_total,
                     "recordsFiltered" => !empty($count_filter)?count($count_filter):0,
                  ])
                ->editColumn("diburment_date",function($payment){
                    return date("d-m-Y",strtotime($payment->diburment_date));
                })
                ->editColumn('percentage_paid',function($payment){
                    return number_format($payment->percentage_paid,2)."%";
                })
                // ->editColumn("interest",function($payment){
                //     if(!empty($payment->interest)){
                //         $interest_value="";
                //         $str = explode("/",$payment->interest);
                //         if(count($str)>2){
                //             $interest_value=$str[0]."% ".",".$str[2]."%";
                //         }else{
                //             $interest_value=$str[0]."% ";
                //         }
                //         return $interest_value;
                //     }else{
                //         return "0%";
                //     }
                // })
                ->editColumn("duration",function($payment){
                    return $payment->duration." Months";
                })
                ->editColumn("sale_amount",function($payment){
                    return "$".number_format($payment->sale_amount,2);
                })
                ->editColumn("discount_amount",function($payment){
                    return "$".number_format($payment->discount_amount,2);
                })
                ->editColumn("sale_price",function($payment){
                    return "$".number_format($payment->sale_amount-$payment->discount_amount,2);
                })
                ->editColumn("payment_Recieve",function($payment){
                    return "$".number_format($payment->sale_amount-$payment->discount_amount-$payment->amount_os,2);
                })
                ->editColumn("payment_due",function($payment){
                    return "$".number_format($payment->amount_os,2);
                })
                ->editColumn("agency",function($payment){
                    $agency=AgencyModel::where('id',$payment->agency_id)->first();

                    return $agency->name;
                })
                ->editColumn('item_name',function($commissions)
                {
                    $sale_item = DB::table("nso007_sale_detail_stock")->where("sale_id",$commissions->sale_id)->select("item_id")->get();
                    $item_names="";
                    foreach ($sale_item as $key => $value) {
                        $item_names.=DB::table("nso007_item_stock")->where("id",$value->item_id)->select("name")->first()->name;
                        if(isset($sale_item[$key+1])) $item_names.=",";
                    }
                    return $item_names;
                })
                ->rawColumns(['interest'=>'interest'])
                ->make(true);
        }
    }
    public function commission(){
        $categories = DB::table("nso007_category_stock")->pluck("name","id");
        $projects = DB::table("nso007_project_stock")->pluck("name","id");
        $items = DB::table("nso007_item_stock")->pluck("name","id");
        return view('report.operation.commission',compact("categories","projects",'items'));
    }
    public function get_commission(Request $request)
    {
        if($request->isMethod("POST")){
            if(isset($request->request_type)){
                if($request->request_type=="project"){
                    $category_id = $request->category_id;
                    $project_id = $request->project_id;
                    $items = DB::table("nso007_item_stock")
                                ->when(request("category_id",""),function($query) use($category_id){
                                    $query->where("nso007_item_stock.category_id",$category_id);
                                })
                                ->when(request("project_id",""),function($query) use($project_id){
                                    $query->where("nso007_item_stock.project_id",$project_id);
                                })
                                ->where("nso007_item_stock.stock_status",2)
                                ->get();
                    return json_encode($items);
                }
            }

        }else{
            $input=$request->all();

            $search = $request->input('search.value');
            $count_total =CommissionModel::join("nso007_agency","nso007_agency.id","nso007_commission.agency_id")
                    ->where("nso007_agency.status",1)
                    ->count();
            $count_filter =CommissionModel::join("nso007_sale_detail_stock","nso007_commission.sale_id","nso007_sale_detail_stock.sale_id")
                    ->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
                    ->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                    ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                    ->join("nso007_agency","nso007_agency.id","nso007_commission.agency_id")
                    ->where("nso007_item_stock.status",1)
                    ->where("nso007_sale_detail_stock.status",1)
                    ->where("nso007_category_stock.status",1)
                    ->where("nso007_project_stock.status",1)
                    ->where("nso007_item_stock.status",1)
                    ->where("nso007_agency.status",1)
                    ->where(function($query) use ($search){
                        $query->orWhere('nso007_item_stock.name' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_item_stock.size' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_project_stock.name' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_category_stock.name' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_agency.name' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_agency.phone' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_agency.gender' , 'LIKE' , '%'.$search.'%');
                    })
                    ->where(function($query) use ($input){
                        if(!empty($input['item_id']))
                            $query->whereIn('nso007_item_stock.id' ,$input["item_id"]);
                        if(!empty($input['project_id']))
                            $query->whereIn('nso007_project_stock.id' ,$input['project_id']);
                        if(!empty($input['category_id']))
                            $query->whereIn('nso007_category_stock.id' ,$input['category_id']);
                        if(!empty($input['agency_gender']))
                            $query->where('nso007_agency.gender' , 'LIKE' , '%'.$input["agency_gender"].'%');
                        if(!empty($input['agency_name']))
                            $query->where('nso007_agency.name' , 'LIKE' , '%'.$input["agency_name"].'%');
                        if(!empty($input['agency_phone'])){
                            $query->where('nso007_agency.phone' , 'LIKE' , '%'.$input["agency_phone"].'%');
                        }
                        if(!empty($input['start_date'])&&!empty($input["end_date"])){
                            $query->whereBetween("nso007_commission.date",[date("Y-m-d",strtotime($input['start_date'])),date("Y-m-d",strtotime($input['end_date']))]);
                        }
                    })
                    ->groupBy("nso007_commission.sale_id")
                    ->get();

            $commission = CommissionModel::join("nso007_sale_detail_stock","nso007_commission.sale_id","nso007_sale_detail_stock.sale_id")
                    ->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
                    ->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                    ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                    ->join("nso007_agency","nso007_agency.id","nso007_commission.agency_id")
                    ->where("nso007_item_stock.status",1)
                    ->where("nso007_sale_detail_stock.status",1)
                    ->where("nso007_category_stock.status",1)
                    ->where("nso007_project_stock.status",1)
                    ->where("nso007_item_stock.status",1)
                    ->where("nso007_agency.status",1)
                    ->where(function($query) use ($input){
                        if(!empty($input['item_id']))
                            $query->whereIn('nso007_item_stock.id' ,$input["item_id"]);
                        if(!empty($input['project_id']))
                            $query->whereIn('nso007_project_stock.id' ,$input['project_id']);
                        if(!empty($input['category_id']))
                            $query->whereIn('nso007_category_stock.id' ,$input['category_id']);
                        if(!empty($input['agency_gender']))
                            $query->where('nso007_agency.gender' , 'LIKE' , '%'.$input["agency_gender"].'%');
                        if(!empty($input['agency_name']))
                            $query->where('nso007_agency.name' , 'LIKE' , '%'.$input["agency_name"].'%');
                        if(!empty($input['agency_phone'])){
                            $query->where('nso007_agency.phone' , 'LIKE' , '%'.$input["agency_phone"].'%');
                        }
                        if(!empty($input['start_date'])&&!empty($input["end_date"])){
                            $query->whereBetween("nso007_commission.date",[date("Y-m-d",strtotime($input['start_date'])),date("Y-m-d",strtotime($input['end_date']))]);
                        }
                    })
                    ->select(
                        "nso007_commission.*",
                        "nso007_agency.name as agency_name",
                        "nso007_agency.phone as agency_phone",
                        "nso007_agency.gender as agency_gender",
                        "nso007_category_stock.name as category_name",
                        "nso007_project_stock.name as project_name",
                        DB::raw("GROUP_CONCAT(DISTINCT nso007_item_stock.name) as item_name")
                    )
                    ->groupBy("nso007_commission.sale_id")
                    ->get();
            // if(isset($request->start_date))
            // dd($commission);
            return Datatables::of($commission)
                ->addIndexColumn()
                ->with([
                    "recordsTotal" => $count_total,
                     "recordsFiltered" => !empty($count_filter)?count($count_filter):0,
                  ])
                ->editColumn("date",function($commission){
                    return date("d-m-Y",strtotime($commission->date));
                })
                ->editColumn("commission_amount",function($commission){
                    return "$".number_format($commission->commission_amount,2);
                })
                ->editColumn("amount_available",function($commission){
                    return "$".number_format($commission->amount_available,2);
                })
                ->editColumn("amount_withdraw",function($commission){
                    return "$".number_format($commission->amount_withdraw,2);
                })
                ->editColumn('item_name',function($commissions)
                {
                    $sale_item = DB::table("nso007_sale_detail_stock")->where("sale_id",$commissions->sale_id)->select("item_id")->get();
                    $item_names="";
                    foreach ($sale_item as $key => $value) {
                        $item_names.=DB::table("nso007_item_stock")->where("id",$value->item_id)->select("name")->first()->name;
                        if(isset($sale_item[$key+1])) $item_names.=",";
                    }
                    return $item_names;
                })
                ->make(true);
        }
    }
    public function commission_history(){
        $categories = DB::table("nso007_category_stock")->pluck("name","id")->prepend("Please Select","");
        $projects = DB::table("nso007_project_stock")->pluck("name","id")->prepend("Please Select","");
        $items = DB::table("nso007_item_stock")->pluck("name","id")->prepend("Please Select","");
        return view('report.operation.commission_history',compact("categories","projects",'items'));
    }
    public function get_commission_history(Request $request)
    {
        if($request->isMethod("POST")){
            if(isset($request->request_type)){
                if($request->request_type=="project"){
                    $category_id = $request->category_id;
                    $project_id = $request->project_id;
                    $items = DB::table("nso007_item_stock")
                                ->when(request("category_id",""),function($query) use($category_id){
                                    $query->where("nso007_item_stock.category_id",$category_id);
                                })
                                ->when(request("project_id",""),function($query) use($project_id){
                                    $query->where("nso007_item_stock.project_id",$project_id);
                                })
                                ->where("nso007_item_stock.stock_status",2)
                                ->get();
                    return json_encode($items);
                }
            }else{

                $input=$request->all();

                $count_total =CommissionHistoryModel::join("nso007_commission","nso007_commission.id","nso007_commission_history.commission_id")
                    ->join("nso007_sale_detail_stock","nso007_commission.sale_id","nso007_sale_detail_stock.sale_id")
                    ->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
                    ->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                    ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                    ->join("nso007_agency","nso007_agency.id","nso007_commission.agency_id")
                    ->where("nso007_item_stock.status",1)
                    ->where("nso007_sale_detail_stock.status",1)
                    ->where("nso007_category_stock.status",1)
                    ->where("nso007_project_stock.status",1)
                    ->count();

                $count_filter =CommissionHistoryModel::join("nso007_commission","nso007_commission.id","nso007_commission_history.commission_id")
                    ->join("nso007_sale_detail_stock","nso007_commission.sale_id","nso007_sale_detail_stock.sale_id")
                    ->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
                    ->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                    ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                    ->join("nso007_agency","nso007_agency.id","nso007_commission.agency_id")
                    ->where("nso007_item_stock.status",1)
                    ->where("nso007_sale_detail_stock.status",1)
                    ->where("nso007_category_stock.status",1)
                    ->where("nso007_project_stock.status",1)
                    ->where("nso007_agency.status",1)
                    ->where(function($query) use ($input){
                        if(!empty($input['item_id']))
                            $query->where('nso007_item_stock.id' ,$input["item_id"]);
                        if(!empty($input['project_id']))
                            $query->where('nso007_project_stock.id' ,$input['project_id']);
                        if(!empty($input['category_id']))
                            $query->where('nso007_category_stock.id' ,$input['category_id']);
                        if(!empty($input['agency_gender']))
                            $query->where('nso007_agency.gender' , 'LIKE' , '%'.$input["agency_gender"].'%');
                        if(!empty($input['agency_name']))
                            $query->where('nso007_agency.name' , 'LIKE' , '%'.$input["agency_name"].'%');
                        if(!empty($input['agency_phone'])){
                            $query->where('nso007_agency.phone' , 'LIKE' , '%'.$input["agency_phone"].'%');
                        }
                        if(!empty($input['start_date'])&&!empty($input["end_date"])){
                            $query->whereBetween("nso007_commission_history.date",[date("Y-m-d",strtotime($input['start_date'])),date("Y-m-d",strtotime($input['end_date']))]);
                        }
                    })
                    ->count();

                $commission_history = CommissionHistoryModel::join("nso007_commission","nso007_commission.id","nso007_commission_history.commission_id")
                    ->join("nso007_sale_detail_stock","nso007_commission.sale_id","nso007_sale_detail_stock.sale_id")
                    ->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
                    ->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                    ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                    ->join("nso007_agency","nso007_agency.id","nso007_commission.agency_id")
                    ->where("nso007_item_stock.status",1)
                    ->where("nso007_sale_detail_stock.status",1)
                    ->where("nso007_category_stock.status",1)
                    ->where("nso007_project_stock.status",1)
                    ->where(function($query) use ($input){
                        if(!empty($input['item_id']))
                            $query->where('nso007_item_stock.id' ,$input["item_id"]);
                        if(!empty($input['project_id']))
                            $query->where('nso007_project_stock.id' ,$input['project_id']);
                        if(!empty($input['category_id']))
                            $query->where('nso007_category_stock.id' ,$input['category_id']);
                        if(!empty($input['agency_gender']))
                            $query->where('nso007_agency.gender' , 'LIKE' , '%'.$input["agency_gender"].'%');
                        if(!empty($input['agency_name']))
                            $query->where('nso007_agency.name' , 'LIKE' , '%'.$input["agency_name"].'%');
                        if(!empty($input['agency_phone'])){
                            $query->where('nso007_agency.phone' , 'LIKE' , '%'.$input["agency_phone"].'%');
                        }
                        if(!empty($input['start_date'])&&!empty($input["end_date"])){
                            $query->whereBetween("nso007_commission_history.date",[date("Y-m-d",strtotime($input['start_date'])),date("Y-m-d",strtotime($input['end_date']))]);
                        }
                    })
                    ->select(
                        "nso007_commission_history.*",
                        "nso007_commission.commission_amount",
                        "nso007_agency.name as agency_name",
                        "nso007_agency.phone as agency_phone",
                        "nso007_agency.gender as agency_gender",
                        "nso007_category_stock.name as category_name",
                        "nso007_project_stock.name as project_name"
                    )
                    ->get();
                $data = array(
                    "count_total"=>$count_total,
                    "count_filter"=>$count_filter,
                    "commission_history"=>$commission_history
                );
                return json_encode($data);
            }
        }else{
            $search = $request->input('search.value');
            $count_total =CommissionHistoryModel::join("nso007_commission","nso007_commission.id","nso007_commission_history.commission_id")
                    ->join("nso007_sale_detail_stock","nso007_commission.sale_id","nso007_sale_detail_stock.sale_id")
                    ->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
                    ->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                    ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                    ->join("nso007_agency","nso007_agency.id","nso007_commission.agency_id")
                    ->where("nso007_item_stock.status",1)
                    ->where("nso007_sale_detail_stock.status",1)
                    ->where("nso007_category_stock.status",1)
                    ->where("nso007_project_stock.status",1)
                    ->where("nso007_agency.status",1)
                    ->count();
            $count_filter =CommissionHistoryModel::join("nso007_commission","nso007_commission.id","nso007_commission_history.commission_id")
                    ->join("nso007_sale_detail_stock","nso007_commission.sale_id","nso007_sale_detail_stock.sale_id")
                    ->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
                    ->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                    ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                    ->join("nso007_agency","nso007_agency.id","nso007_commission.agency_id")
                    ->where("nso007_item_stock.status",1)
                    ->where("nso007_sale_detail_stock.status",1)
                    ->where("nso007_category_stock.status",1)
                    ->where("nso007_project_stock.status",1)
                    ->where("nso007_agency.status",1)
                    ->where(function($query) use ($search){
                        $query->orWhere('nso007_item_stock.name' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_item_stock.size' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_project_stock.name' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_category_stock.name' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_agency.name' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_agency.phone' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_agency.gender' , 'LIKE' , '%'.$search.'%');
                    })
                    ->count();

            $commission_history = CommissionHistoryModel::join("nso007_commission","nso007_commission.id","nso007_commission_history.commission_id")
                    ->join("nso007_sale_detail_stock","nso007_commission.sale_id","nso007_sale_detail_stock.sale_id")
                    ->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
                    ->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                    ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                    ->join("nso007_agency","nso007_agency.id","nso007_commission.agency_id")
                    ->where("nso007_item_stock.status",1)
                    ->where("nso007_sale_detail_stock.status",1)
                    ->where("nso007_category_stock.status",1)
                    ->where("nso007_project_stock.status",1)
                    ->where("nso007_agency.status",1)
                    ->select(
                        "nso007_commission_history.*",
                        "nso007_commission.commission_amount",
                        "nso007_agency.name as agency_name",
                        "nso007_agency.phone as agency_phone",
                        "nso007_agency.gender as agency_gender",
                        "nso007_category_stock.name as category_name",
                        "nso007_project_stock.name as project_name"
                    )
                    ->take(20);
            return Datatables::of($commission_history)
                ->addIndexColumn()
                ->with([
                    "recordsTotal" => $count_total,
                     "recordsFiltered" => $count_filter,
                  ])
                ->editColumn("date",function($commission_history){
                    return date("d-m-Y",strtotime($commission_history->date));
                })
                ->editColumn("commission_amount",function($commission_history){
                    return "$".number_format($commission_history->commission_amount,2);
                })
                ->editColumn("amount",function($commission_history){
                    return "$".number_format($commission_history->amount,2);
                })
                ->make(true);
        }
    }


    /************End Block Report Operation*********/
}
