<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\CategoryConStockModel;
use App\UnitModel;
use App\ProductConModel;
use DB;
use Crypt;
use Image;
use DataTables;

class ProductConController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
         $this->middleware('permission:Product-Construction-List', ['only' => ['index']]);
         $this->middleware('permission:Product-Construction-Create', ['only' => ['create','store']]);
         $this->middleware('permission:Product-Construction-Update', ['only' => ['edit','update']]);
    }
    public function index(Request $request)
    {
        if($request->ajax()){
            $category_id = $request->category_id;
            $unit_id = $request->unit_id;
            $total_count = DB::table('product')->count();
            $filter_count = DB::table('product')
                ->join('nso007_category_construction','pro_category_id','pcat_id')
                ->join('unit','pro_unit_id','unit.id')
                ->where(function($query) use ($category_id,$unit_id){
                    if(!empty($category_id)){
                        $query->whereIn("product.pro_category_id",$category_id);
                    }
                    if(!empty($unit_id)){
                        $query->whereIn("product.pro_unit_id",$unit_id);
                    }
                })
                ->count();
            $products=DB::table('product')
                ->join('nso007_category_construction','pro_category_id','pcat_id')
                ->join('unit','pro_unit_id','unit.id')
                ->select('product.id','product.pro_code','product.pro_name','product.pro_price','nso007_category_construction.pcat_name','unit.unit_name','product.pro_qty','product.delete_status')
                ->where(function($query) use ($category_id,$unit_id){
                    if(!empty($category_id)){
                        $query->whereIn("product.pro_category_id",$category_id);
                    }
                    if(!empty($unit_id)){
                        $query->whereIn("product.pro_unit_id",$unit_id);
                    }
                })
                ->get();
            return Datatables::of($products)
                ->addIndexColumn()
                ->with([
                    "recordsTotal" => $total_count,
                     "recordsFiltered" => $filter_count,
                ])
                ->setRowId("id")
                ->addColumn('image',function($product){

                    $images = DB::table("construction_product_image")->where("product_id",$product->id)->first();
                    return '<img src="'.(!empty(optional($images)->image)?asset('assets/img/upload'."/".optional($images)->image):asset('assets/img/defaultphoto.png')).'" border="0" width="100px" height="80px" class="img-rounded" align="center" />';
                })
                ->editColumn('pro_price',function($product){
                    return "$".number_format($product->pro_price,2);
                })
                ->addColumn('action',function($product){
                    $button = "";
                    $button .= '<a href="'.route("product-construction.edit",Crypt::encrypt($product->id)).'" class="btn-sm btn-info btn"><i class="fa fa-edit"></i></a>';
                    if($product->delete_status==0){
                        $button .= ' <button data-href="'.route("con_product.delete",Crypt::encrypt($product->id)).'" class="btn-sm btn-danger btn" onclick = "con_delete(this)"><i class="fa fa-trash"></i></button>';
                    }
                    return $button;
                })
                ->rawColumns(['action'=>'action','image'=>'image'])
                ->make(true);
        }
        $categories = DB::table('nso007_category_construction')->pluck('pcat_name','pcat_id');
        $units = DB::table('unit')->pluck("unit_name","id");
        return view('construction-stock.products.index',compact('categories','units'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $category=CategoryConStockModel::pluck("pcat_name","pcat_id")->prepend("Please Select","");
        $unit=UnitModel::pluck("unit_name","id")->prepend("Please Select","");
        return view('construction-stock.products.create',compact('category','unit'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'pro_code'=>'required|unique:product,pro_code',
            'pro_name'=>'required|unique:product,pro_name',
            'pro_category_id'=>'required',
            'pro_unit_id'=>'required',
            'pro_price'=>'required','number',
            'pro_qty'=>'required','number'
        ]);
        $unit=$request->input('pro_unit_id');
        $category=$request->input('pro_category_id');
        $pro_code=$request->input('pro_code');
        $pro_name=$request->input('pro_name');
        $pro_price=$request->input('pro_price');
        $product=new ProductConModel;
        $product->pro_code=$pro_code;
        $product->pro_name=$pro_name;
        $product->pro_category_id=$category;
        $product->pro_unit_id=$unit;
        $product->pro_price=$pro_price;
        $product->pro_qty=$request->input('pro_qty');
        $product->save();
        $image = $request->file('photo');
        if(isset($image)&&!empty($image)){
            foreach($image as $k=>$img){
                $imagename="";
                if($image[$k]){
                    $input['imagename'] = "supplier-product".$k.time().'.'.$image[$k]->getClientOriginalExtension();
    
                    $destinationPath = public_path('/assets/img/upload');
                    $img = Image::make($image[$k]->getRealPath());
                    $img->save($destinationPath.'/'.$input['imagename']);
                    $imagename=$input['imagename'];
                    DB::table("construction_product_image")->insert(['product_id'=>$product->id,'image'=>$imagename]);
                }
            }
        }
        return redirect()->route('product-construction.index')->with('success','product have inserted.');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $id=Crypt::decrypt($id);
        $product=DB::table('product')
            ->join('nso007_category_construction','pro_category_id','pcat_id')
            ->join('unit','pro_unit_id','unit.id')
            ->select('product.id','product.pro_code','product.pro_unit_id','product.pro_name','product.pro_price','product.pro_category_id','nso007_category_construction.pcat_name','unit.unit_name')
            ->where('product.id',$id)
            ->first();
        $category=CategoryConStockModel::pluck("pcat_name","pcat_id");
        $unit=UnitModel::pluck("unit_name","id");
        $images = DB::table("construction_product_image")->where('product_id',$id)->get();
        return view("construction-stock.products.edit",compact("product","unit","category",'images'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // dd($request->file('photo'));    
        $this->validate($request,[
            'pro_code'=>'required',
            'pro_name'=>'required',
            'pro_price'=>'required',
            'category'=>'required',
            'unit'=>'required'
        ]);
        $product=ProductConModel::find($id);
        $product->pro_code=$request->input("pro_code");
        $product->pro_name=$request->input("pro_name");
        $product->pro_price=$request->input("pro_price");
        $product->pro_category_id=$request->input("category");
        $product->pro_unit_id=$request->input("unit");
        $product->save();

        $image = $request->file('photo');
        DB::table("construction_product_image")->where('product_id',$id)->delete();
        if($image){
            foreach($image as $k=>$img){
                $imagename="";
                if($img){
                    $input['imagename'] = "supplier-product".$k.time().'.'.$img->getClientOriginalExtension();
                    $destinationPath = public_path('/assets/img/upload');
                    $img = Image::make($img->getRealPath());
                    $img->save($destinationPath.'/'.$input['imagename']);
                    $imagename=$input['imagename'];
                    DB::table("construction_product_image")->insert(['product_id'=>$id,'image'=>$imagename]);
                }
                else{
                }
            }
        }
        if($request->cpImage){
            foreach($request->cpImage as $k=>$val){
                if($val)
                    DB::table("construction_product_image")->insert(['product_id'=>$id,'image'=>$val]);
            }
        }
        return redirect()->route("product-construction.index");
    }
    public function show_product_image($id){
        $data = DB::table("construction_product_image")->select("image")->where("product_id",$id)->get();
        $return_value = array();
        if(isset($data)&&!empty($data)&&count($data)>0){
            foreach($data as $key=>$value){
                $return_value[$key] = asset('assets/img/upload'."/".$value->image);
            }
        }
        return json_encode($return_value);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        $id = Crypt::decrypt($id);
        DB::table('product')->where("id",$id)->delete();
        return response()->json(['product_id'=>$id]);
    }
}