<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\ClientRelationshipModel;
use DB;
use App\SaleModel;
use App\LoanClientRelationshipModel;
use App\LoanModel;
use App\LoanProcessModel;
use App\ItemModel;
use Auth;
use App\SaleDetailModel;
use App\ClientModel;
use App\AgencyModel;
use App\Helpers\Globals;

class InstallmentController extends Controller
{
    function __construct()
    {
         $this->middleware('permission:Deposit-Installment', ['only' => ['create','store']]);
         $this->middleware('permission:Client-Payment-Edit-Installment', ['only' => ['edit','update']]);
    }
    public function create($sale_id)
    {
    	$loan_data = SaleModel::where("nso007_sale_stock.id",$sale_id)
    				->join("nso007_client","nso007_client.id","nso007_sale_stock.client_id")
    				->leftJoin("nso007_agency","nso007_agency.id","nso007_sale_stock.agency_id")
    				->join("nso007_sale_detail_stock","nso007_sale_detail_stock.sale_id","nso007_sale_stock.id")
    				->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
    				->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
    				->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
    				->select("nso007_client.name as client_name","nso007_agency.name as agency_name","nso007_category_stock.name as category_name","nso007_project_stock.name as project_name",DB::raw("GROUP_CONCAT(nso007_item_stock.name) as item_name"),"nso007_sale_stock.sale_amount","nso007_sale_stock.sale_receive_amount","nso007_sale_stock.sale_remain_amount","nso007_sale_stock.id as sale_id","nso007_sale_stock.policy_payment_id","nso007_sale_stock.policy_payment_detail_id","nso007_sale_stock.discount_amount")
    				->groupBy("nso007_sale_stock.id")->first();
    	$client_relationships = ClientRelationshipModel::all();
        $policy_payments = DB::table("nso007_payment_policy")->pluck("name","id")->prepend("Please Select","");
        $policy_payments_details = DB::table("nso007_payment_policy_detail")->where("policy_id",$loan_data->policy_payment_id)->pluck("name","id")->prepend("Please Select","");
    	return view("installment.create",compact('client_relationships','loan_data','policy_payments','policy_payments_details'));
    }
    public function store(Request $request)
    {

        $this->validate($request,[
            'sale_id'=>'required|numeric',
            'sale_amount'=>'required|numeric',
            'deposit_amount'=>'required|numeric',
            'remain_amount'=>'required|numeric',
            'discount_amount'=>'required|numeric',
            'disburment_date'=>'required',
        ]);

        //Check First Loan
        if($request->installment_type_first_loan==2) {
            $this->validate($request,[
                'loan_amount_first'=>'required',
                'loan_term'=>'required',
                'next_payment_date'=>'required',
                'number_of_month'=>'required|numeric',
                'first_loan_interest_amount.*'=>'required|numeric',
                'first_loan_payment_date.*'=>'required',
                'first_loan_principal.*'=>'required',
                'first_loan_interest_amount.*'=>'required',
                'first_loan_payment.*'=>'required',
                'first_loan_balance.*'=>'required',
                'loan_amount_after_step'=>'required'
            ]);
            if(empty($request->first_loan_payment_date)){
                return redirect()->route("client-payment.index")->with("warning","Installment create unsuccessfully");
                if(!isset($request->first_loan_payment_date)||count($request->first_loan_payment_date)<=0){
                    return redirect()->route("client-payment.index")->with("warning","Installment create unsuccessfully");
                }
                return redirect()->route("client-payment.index")->with("warning","Installment create unsuccessfully");
            }
        }
        //Check Second Loan
        if($request->installment_type_second_loan==3){
            $this->validate($request,[
                'loan_amount_second'=>'required',
                'loan_term_second'=>'required',
                'next_payment_date_second'=>'required',
                'number_of_month_second'=>'required|numeric',
                'interest_second'=>'required|numeric',
                'second_loan_payment_date.*'=>'required',
                'second_loan_principal.*'=>'required',
                'second_loan_interest_amount.*'=>'required',
                'second_loan_payment.*'=>'required',
                'second_loan_balance.*'=>'required',
                'loan_amount_after_loan_first'=>'required'
            ]);
            if(empty($request->second_loan_payment_date)){
                return redirect()->route("client-payment.index")->with("warning","Installment create unsuccessfully");
                if(!isset($request->second_loan_payment_date)||count($request->second_loan_payment_date)<=0){
                    return redirect()->route("client-payment.index")->with("warning","Installment create unsuccessfully");
                }
                return redirect()->route("client-payment.index")->with("warning","Installment create unsuccessfully");
            }
        }
        //Check Loan with bank

        // Get Sale information
        $sale_data = SaleModel::where("id",$request->sale_id)->first();
        //End

        //Get sale detail stock
        $sale_detail = SaleDetailModel::where("sale_id",$request->sale_id)->where("status",1)->get();
        //End

        //Update item
        $project_id = "";
        foreach( $sale_detail as $key => $value ){
            ItemModel::where("id",$value->item_id)->update(['sale_stock'=>2,'delete_status'=>0]);
            $project_id = ItemModel::where("id",$value->item_id)->first()->project_id;
        }
        //end

        //Update Client
        ClientModel::where("id",$sale_data->client_id)->update(['pos_status'=>1,'delete_status'=>0]);
        //End

        AgencyModel::where("id",$sale_data->agency_id)->update(['delete_status'=>0]);

        //Update Sale
        SaleModel::where("id",$request->sale_id)->update(['type'=>2,'discount_amount'=>$request->discount_amount,'policy_payment_id'=>$request->policy_payment,'policy_payment_detail_id'=>$request->policy_payment_detail]);
        //End

        //Insert Loan
        $data_loan_insert = array(
            'client_id'=>$sale_data->client_id,
            'agency_id'=>   $sale_data->agency_id,
            'sale_id'=>$sale_data->id,
            'user_id'=>Auth::user()->id,
            'sale_amount'=>$request->sale_amount ,//amount before discount
            'discount_amount'=>$request->discount_amount,
            'amount_os'=>$request->sale_amount - $request->discount_amount - $request->deposit_amount,
            'term'=>1,
            'diburment_date'=>date("Y-m-d",strtotime($request->disburment_date)),
            'percentage_paid'=>$request->deposit_amount*100/$request->remain_amount
        );
        LoanModel::insert($data_loan_insert);
        $loan_id = LoanModel::max("id");
        //End

        //Type of Installment

        $principle_balance = $request->sale_amount - $request->discount_amount - $request->deposit_amount;
        $acc_principle = $request->deposit_amount;

        $no =1 ;

        //Insert Step
        if(!empty($request->payment_amount_step[0])&&$request->payment_amount_step[0]>0&&!empty($request->date_payment_step))
        {
            $insert_step_amount = 0;
            foreach($request->payment_amount_step as $step_index => $step_payment)
            {
                if(isset($step_payment)&&!empty($step_payment)){
                    $principle_balance -= $step_payment;
                    $acc_principle += $step_payment;

                    $data_loan_process = array(
                        'no' => $no++,
                        'date_payment' => date("Y-m-d",strtotime($request->date_payment_step[$step_index])),
                        'principle'=> $step_payment,
                        'principle_pay' => $step_payment,
                        'principle_os' => $principle_balance,
                        'acc_principle' => $acc_principle,
                        'amount_paid' => $acc_principle,
                        'amount_credit' => $principle_balance,
                        'owe_amount' => $step_payment,
                        'owe_amount_pay' => $step_payment,
                        'condition_loan' => "Step",
                        'installment_type' => 1,
                        'loan_id' => $loan_id
                    );
                    LoanProcessModel::insert($data_loan_process);
                    $insert_step_amount += $step_payment;
                }

            }
            // Update loan data
            $data_loan_update = array(
                'step_amount'=> $insert_step_amount,
                'duration' => count($request->payment_amount_step),
                'first_date_pay' => date("Y-m-d",strtotime($request->date_payment_step[0])),
                'duration_step' => ($no-1),
                'step_term'=>$request->step_term
            );
            LoanModel::where("id",$loan_id)->update($data_loan_update);
            //End
        }
        //End


        if($request->installment_type_first_loan==2) //Installment loan First
        {
            $this->validate($request,[
                'loan_amount_first'=>'required',
                'loan_term'=>'required',
                'next_payment_date'=>'required',
                'number_of_month'=>'required|numeric',
                'first_loan_interest_amount.*'=>'required|numeric',
                'first_loan_payment_date.*'=>'required',
                'first_loan_principal.*'=>'required',
                'first_loan_interest_amount.*'=>'required',
                'first_loan_payment.*'=>'required',
                'first_loan_balance.*'=>'required',
                'loan_amount_after_step'=>'required'
            ]);
            // dd($request->all());

            foreach($request->first_loan_payment_date as $key=>$value)//Insert to loan process
            {
                if(isset($value)&&!empty($value)){
                    $principle_balance -= $request->first_loan_principal[$key];
                    $acc_principle += $request->first_loan_principal[$key];

                    $data_loan_process = array(
                        'no' => $no++,
                        'date_payment' => date("Y-m-d",strtotime($value)),
                        'interest_amount' => $request->first_loan_interest_amount[$key],
                        'interest_amount_pay' => $request->first_loan_interest_amount[$key],
                        'principle'=> $request->first_loan_principal[$key],
                        'principle_pay' => $request->first_loan_principal[$key],
                        'principle_os' => $principle_balance,
                        'acc_principle' => $acc_principle,
                        'amount_paid' => $acc_principle,
                        'amount_credit' => $principle_balance,
                        'owe_amount' => $request->first_loan_payment[$key],
                        'owe_amount_pay' => $request->first_loan_payment[$key],
                        'condition_loan' => "Loan First",
                        'installment_type' => 2,
                        'loan_id' => $loan_id,
                        'type_loan' => $request->loan_type,
                        'balance_each_loan'=> $request->first_loan_balance[$key]
                    );
                    LoanProcessModel::insert($data_loan_process);
                }

            }
            // Update loan data
            $data_loan_update = array(
                'duration' => $request->number_of_month + DB::table('nso007_loan')->where("id",$loan_id)->first()->duration,
                'interest' => $request->interest."/(".date("d-m-Y",strtotime($request->first_loan_payment_date[0]))." to ".date("d-m-Y",strtotime($request->first_loan_payment_date[count($request->first_loan_payment_date)-1])).")",
                'term' => 1,
                'duration_by_year'=>$request->duration_year,
                'duration_by_month'=>$request->duration_month,
                'interest_by_year'=>$request->interest_year,
                'interest_by_month'=>$request->interest_month,
                'duration_first_loan'=>$request->number_of_month,
                'amount_first_loan'=>$request->loan_amount_first,
                'percentage_first_loan'=>$request->Loan_percentage_first,
                'interest_first_loan'=>$request->interest
            );
            LoanModel::where("id",$loan_id)->update($data_loan_update);
            //End

        }
        if($request->installment_type_second_loan==3) //Installment loan Second
        {
            $this->validate($request,[
                'loan_amount_second'=>'required',
                'loan_term_second'=>'required',
                'next_payment_date_second'=>'required',
                'number_of_month_second'=>'required|numeric',
                'interest_second'=>'required|numeric',
                'second_loan_payment_date.*'=>'required',
                'second_loan_principal.*'=>'required',
                'second_loan_interest_amount.*'=>'required',
                'second_loan_payment.*'=>'required',
                'second_loan_balance.*'=>'required',
                'loan_amount_after_loan_first'=>'required'
            ]);

            foreach($request->second_loan_payment_date as $key=>$value)//Insert to loan process
            {
                if(isset($value)&&!empty($value)){
                    $principle_balance -= (!empty($request->second_loan_principal[$key])?$request->second_loan_principal[$key]:0);
                    $acc_principle += (!empty($request->second_loan_principal[$key])?$request->second_loan_principal[$key]:0);

                    $data_loan_process_second = array(
                        'no' => $no++,
                        'date_payment' => date("Y-m-d",strtotime($value)),
                        'interest_amount' => (!empty($request->second_loan_interest_amount[$key])?$request->second_loan_interest_amount[$key]:0),
                        'interest_amount_pay' => (!empty($request->second_loan_interest_amount[$key])?$request->second_loan_interest_amount[$key]:0),
                        'principle'=> (!empty($request->second_loan_principal[$key])?$request->second_loan_principal[$key]:0),
                        'principle_pay' => (!empty($request->second_loan_principal[$key])?$request->second_loan_principal[$key]:0),
                        'principle_os' => $principle_balance,
                        'acc_principle' => $acc_principle,
                        'amount_paid' => $acc_principle,
                        'amount_credit' => $principle_balance,
                        'owe_amount' => (!empty($request->second_loan_payment[$key])?$request->second_loan_payment[$key]:0),
                        'owe_amount_pay' => (!empty($request->second_loan_payment[$key])?$request->second_loan_payment[$key]:0),
                        'condition_loan' => "Loan Second",
                        'installment_type' => 3,
                        'loan_id' => $loan_id,
                        'type_loan' => $request->loan_type_second,
                        'balance_each_loan'=> (!empty($request->second_loan_balance[$key])?$request->second_loan_balance[$key]:0)
                    );
                    LoanProcessModel::insert($data_loan_process_second);
                }
            }
            // Update loan data
            $data_loan_update_second = array(
                'duration' => $request->number_of_month_second + DB::table('nso007_loan')->where("id",$loan_id)->first()->duration,
                'interest' => DB::table('nso007_loan')->where("id",$loan_id)->first()->interest."/".$request->interest_second."/(".date("d-m-Y",strtotime($request->second_loan_payment_date[0]))." to ".date("d-m-Y",strtotime($request->second_loan_payment_date[count($request->second_loan_payment_date)-1])).")",
                'term' => 1,
                'duration_second_loan'=>$request->number_of_month_second,
                'amount_second_loan'=>$request->loan_amount_second,
                'percentage_second_loan'=>$request->loan_percentage_second,
                'interest_second_loan'=>$request->interest_second,
                'interest_second_option'=>$request->interest_second_option
            );
            if($request->interest_second_option==2){
                if(!empty($request->from_month)&&count($request->from_month)>0){
                    foreach($request->from_month as $k_f=>$val_f){
                        DB::table("nso007_loan_change_interest")->insert(['loan_id'=>$loan_id,'from_month'=>$request->from_month[$k_f],'to_month'=>$request->to_month[$k_f],'interest'=>$request->change_interest[$k_f]]);
                    }
                }
            }

            LoanModel::where("id",$loan_id)->update($data_loan_update_second);
            //End

        }
         // Other Installment

        //insert interest Only

        if($request->payment_amount_topay[0]>0) //insert interest Only
        {
            foreach($request->payment_amount_topay as $key=>$value)//Insert to loan process
            {
                if(isset($value)&&!empty($value)){
                    $data_loan_interest_only = array(
                        'no' => $no++,
                        'date_payment' => date("Y-m-d",strtotime($request->date_payment_interest[$key])),
                        'interest_amount' => $request->payment_interest[$key],
                        'interest_amount_pay' => $request->payment_interest[$key],
                        'principle'=> $request->payment_principle_interest[$key],
                        'principle_pay' => $request->payment_principle_interest[$key],
                        'principle_os' => $request->payment_amount_interest[$key]-$request->payment_principle_interest[$key],
                        'acc_principle' => $request->payment_amount_interest[$key]+$request->payment_principle_interest[$key],
                        'amount_paid' => $request->payment_amount_interest[$key]+$request->payment_principle_interest[$key],
                        'amount_credit' => $request->payment_amount_interest[$key]-$request->payment_principle_interest[$key],
                        'owe_amount' => $value,
                        'owe_amount_pay' => $value,
                        'condition_loan' => "Loan Interest Only",
                        'installment_type' => 5,
                        'loan_id' => $loan_id,
                        'type_loan' => 5,
                        'balance_each_loan'=> 0
                    );
                    LoanProcessModel::insert($data_loan_interest_only);
                }
            }
            $data_loan_update = array(
                'duration' => $key+1 + DB::table('nso007_loan')->where("id",$loan_id)->first()->duration,
            );
            LoanModel::where("id",$loan_id)->update($data_loan_update);


        }

        //End

        //Insert Step Bank
        if(!empty($request->payment_amount_bank)&&$request->payment_amount_bank>0)
        {
            $payment = $request->payment_amount_bank;
            $principle_balance -= $payment;
            $acc_principle += $payment;

            $data_loan_process = array(
                'no' => $no++,
                'date_payment' => (!empty($request->date_payment_bank)?date("Y-m-d",strtotime($request->date_payment_bank)):null),
                'principle'=> $payment,
                'principle_pay' => $payment,
                'principle_os' => $principle_balance,
                'acc_principle' => $acc_principle,
                'amount_paid' => $acc_principle,
                'amount_credit' => $principle_balance,
                'owe_amount' => $payment,
                'owe_amount_pay' => $payment,
                'condition_loan' => "Bank",
                'installment_type' => 4,
                'loan_id' => $loan_id
            );
            LoanProcessModel::insert($data_loan_process);
        }
        //End



        //Insert Client Relationship
        /*if(isset($request->client_relationship_id))
        {
            $this->validate($request,[
                'client_relationship_id'=>'required',
                'client_relationship_type'=>'required'
            ]);

            foreach($request->client_relationship_id as $key => $value)
            {
                $data_client_relationship = array(
                    "loan_id" => $loan_id,
                    "client_relationship_id" => $value,
                    "relationship_type" => $request->client_relationship_type[$key]
                );
                LoanClientRelationshipModel::insert($data_client_relationship);
            }
        }*/
        //End

         // Update loan data
            /*$data_loan_update = array(
                'condition_convert_to_income'=> 20,
            );
            LoanModel::where("id",$loan_id)->update($data_loan_update);*/
            //End

        //Acounting
            \Globals::convert_to_income($loan_id,date("Y-m-d",strtotime($request->disburment_date)),$project_id);
        //End

        return redirect()->route("client-payment.index")->with("success","Installment create successfully");
    }

    public function edit($loan_id)
    {
        $loan_data = LoanModel::where("nso007_loan.id",$loan_id)
        ->join("nso007_sale_stock","nso007_sale_stock.id","nso007_loan.sale_id")
        ->join("nso007_client","nso007_client.id","nso007_loan.client_id")
        ->leftJoin("nso007_agency","nso007_agency.id","nso007_loan.agency_id")
        ->join("nso007_sale_detail_stock","nso007_sale_detail_stock.sale_id","nso007_loan.sale_id")
        ->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
        ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
        ->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
        ->select(
            "nso007_client.name as client_name",
            "nso007_agency.name as agency_name",
            "nso007_category_stock.name as category_name",
            "nso007_project_stock.name as project_name",
            DB::raw("GROUP_CONCAT(nso007_item_stock.name) as item_name"),
            "nso007_sale_stock.sale_amount",
            "nso007_sale_stock.sale_receive_amount",
            "nso007_sale_stock.sale_remain_amount",
            "nso007_sale_stock.id as sale_id",
            "nso007_loan.discount_amount",
            "nso007_loan.diburment_date",
            "nso007_loan.amount_os",
            "nso007_loan.id as loan_id"
        )
        ->groupBy("nso007_sale_stock.id")->first();

        $client_relationships = ClientRelationshipModel::all();

        $loan_client_relationship = LoanClientRelationshipModel::where("loan_id",$loan_id)->get();

        return view('installment.edit-schedule',compact('loan_data','client_relationships','loan_client_relationship'));
    }

    public function update(Request $request)
    {
//         dd($request->all());
        $this->validate($request,[
            'loan_id'=>'required|numeric',
            'sale_amount'=>'required|numeric',
            'deposit_amount'=>'required|numeric',
            'remain_amount'=>'required|numeric',
            'discount_amount'=>'required|numeric',
            'disburment_date'=>'required'
//            'installment_type'=>'required|numeric'
        ]);

        //Insert loan
        $data_loan_insert = array(
            'diburment_date'=>date("Y-m-d",strtotime($request->disburment_date)),
        );
        LoanModel::where('id',$request->loan_id)->update($data_loan_insert);

        $loan_id = $request->loan_id;
        //end

        $data_paid = LoanProcessModel::where("loan_id",$loan_id)->where("paid_type",1)->where("status",1)->get();//get paid loan_process
        $no = 0;
        if(!empty($data_paid)&&count($data_paid)>0){
            $no = count($data_paid);
        }

        LoanProcessModel::where("loan_id",$loan_id)->where("owe_amount_pay",'>',0)->where("status",1)->delete();

        //Type of Installment$request->sale_amount - $request->discount_amount - $request->deposit_amount

        $principle_balance = $request->remain_amount;
        $acc_principle = $request->sale_amount - $request->discount_amount - $request->remain_amount;
        //Insert Step
        if(!empty($request->payment_amount_step[0])&&$request->payment_amount_step[0]>0&&!empty($request->date_payment_step))
        {
            $insert_step_amount = 0;
            foreach($request->payment_amount_step as $step_index => $step_payment)
            {
                if(isset($step_payment)&&!empty($step_payment)){
                    $principle_balance -= $step_payment;
                    $acc_principle += $step_payment;

                    $data_loan_process = array(
                        'no' => $no++,
                        'date_payment' => date("Y-m-d",strtotime($request->date_payment_step[$step_index])),
                        'principle'=> $step_payment,
                        'principle_pay' => $step_payment,
                        'principle_os' => $principle_balance,
                        'acc_principle' => $acc_principle,
                        'amount_paid' => $acc_principle,
                        'amount_credit' => $principle_balance,
                        'owe_amount' => $step_payment,
                        'owe_amount_pay' => $step_payment,
                        'condition_loan' => "Step",
                        'installment_type' => 1,
                        'loan_id' => $loan_id
                    );
                    LoanProcessModel::insert($data_loan_process);
                    $insert_step_amount += $step_payment;
                }

            }
            // Update loan data
            $data_loan_update = array(
                'step_amount'=> $insert_step_amount,
                'duration' => count($request->payment_amount_step),
                'first_date_pay' => date("Y-m-d",strtotime($request->date_payment_step[0])),
                'duration_step' => ($no-1),
                'step_term'=>$request->step_term
            );
            LoanModel::where("id",$loan_id)->update($data_loan_update);
            //End
        }
        //End
        if($request->installment_type==1) //Installment step
        {
            $this->validate($request,[
                'date_payment'=>'required',
                'payment_amount'=>'required'
            ]);

            foreach($request->payment_amount as $key=>$value)//Insert to loan process
            {
                $principle_balance -= $request->payment_amount[$key];
                $acc_principle += $request->payment_amount[$key];

                $data_loan_process = array(
                    'no' => ++$no,
                    'date_payment' => date("Y-m-d",strtotime($request->date_payment[$key])),
                    'principle'=> $request->payment_amount[$key],
                    'principle_pay' => $request->payment_amount[$key],
                    'principle_os' => $principle_balance,
                    'acc_principle' => $acc_principle,
                    'amount_paid' => $acc_principle,
                    'amount_credit' => $principle_balance,
                    'owe_amount' => $request->payment_amount[$key],
                    'owe_amount_pay' => $request->payment_amount[$key],
                    'condition_loan' => "Step",
                    'installment_type' => 1,
                    'loan_id' => $loan_id
                );
                LoanProcessModel::insert($data_loan_process);
            }
            // Update loan data
            $first_date_pay_step="";
            if(count($data_paid)>1){
                $first_date_pay_step=date("Y-m-d",strtotime($data_paid[0]->date_payment));
            }
            else{
                $first_date_pay_step=date("Y-m-d",strtotime($request->date_payment[0]));
            }
            $data_loan_update = array(
                'step_amount'=>$request->sale_amount - $request->discount_amount - $request->remain_amount,
                'duration' => count($request->payment_amount),
                'installment_type' => 1,
                'first_date_pay' => $first_date_pay_step
            );
            LoanModel::where("id",$loan_id)->update($data_loan_update);
            //End
        }
        else if($request->installment_type==2) //Installment loan
        {
            $this->validate($request,[
                'loan_type'=>'required',
                'loan_term'=>'required',
                'next_payment_date'=>'required',
                'number_of_month'=>'required|numeric',
                'interest'=>'required|numeric',
                'payment_date'=>'required',
                'principal'=>'required',
                'interest_amount'=>'required',
                'payment'=>'required',
                'balance'=>'required'
            ]);

            foreach($request->payment_date as $key=>$value)//Insert to loan process
            {
                $principle_balance -= $request->principal[$key];
                $acc_principle += $request->principal[$key];

                $data_loan_process = array(
                    'no' => ++$no,
                    'date_payment' => date("Y-m-d",strtotime($value)),
                    'interest_amount' => $request->interest_amount[$key],
                    'interest_amount_pay' => $request->interest_amount[$key],
                    'principle'=> $request->principal[$key],
                    'principle_pay' => $request->principal[$key],
                    'principle_os' => $principle_balance,
                    'acc_principle' => $acc_principle,
                    'amount_paid' => $acc_principle,
                    'amount_credit' => $principle_balance,
                    'owe_amount' => $request->payment[$key],
                    'owe_amount_pay' => $request->payment[$key],
                    'condition_loan' => "Loan First",
                    'installment_type' => 2,
                    'type_loan' => $request->loan_type,
                    'loan_id' => $loan_id
                );
                LoanProcessModel::insert($data_loan_process);
            }
            // Update loan data
            $first_date_pay_step="";
            if(count($data_paid)>1){
                $first_date_pay_loan=date("Y-m-d",strtotime($data_paid[0]->date_payment));
            }
            else{
                $first_date_pay_loan=date("Y-m-d",strtotime($request->next_payment_date));
            }
            $data_loan_update = array(
                'loan_amount'=>$request->sale_amount - $request->discount_amount - $request->remain_amount,
                'duration' => $request->number_of_month,
                'interest' => $request->interest,
                'installment_type' => 2,
                'first_date_pay' => $first_date_pay_loan,
                'term' => 1,
                'type_loan' => $request->loan_type,
            );
            LoanModel::where("id",$loan_id)->update($data_loan_update);
            //End

        }
        else // Other Installment
        {

        }
        //End
        //insert interest Only

        if($request->payment_amount_topay[0]>0) //insert interest Only
        {
            foreach($request->payment_amount_topay as $key=>$value)//Insert to loan process
            {
                if(isset($value)&&!empty($value)){
                    $data_loan_interest_only = array(
                        'no' => $no++,
                        'date_payment' => date("Y-m-d",strtotime($request->date_payment_interest[$key])),
                        'interest_amount' => $request->payment_interest[$key],
                        'interest_amount_pay' => $request->payment_interest[$key],
                        'principle'=> $request->payment_principle_interest[$key],
                        'principle_pay' => $request->payment_principle_interest[$key],
                        'principle_os' => $request->payment_amount_interest[$key]-$request->payment_principle_interest[$key],
                        'acc_principle' => $request->payment_amount_interest[$key]+$request->payment_principle_interest[$key],
                        'amount_paid' => $request->payment_amount_interest[$key]+$request->payment_principle_interest[$key],
                        'amount_credit' => $request->payment_amount_interest[$key]-$request->payment_principle_interest[$key],
                        'owe_amount' => $value,
                        'owe_amount_pay' => $value,
                        'condition_loan' => "Loan Interest Only",
                        'installment_type' => 5,
                        'loan_id' => $loan_id,
                        'type_loan' => 5,
                        'balance_each_loan'=> 0
                    );
                    LoanProcessModel::insert($data_loan_interest_only);
                }
            }
            $data_loan_update = array(
                'duration' => $key+1 + DB::table('nso007_loan')->where("id",$loan_id)->first()->duration,
            );
            LoanModel::where("id",$loan_id)->update($data_loan_update);


        }

        //End
        return redirect()->route("client-payment.index")->with("success","Update successfully");
    }
    public function get_payment_policy_detail($id){
        $payment_policy_detail = DB::table("nso007_payment_policy_detail")->where("id",$id)->first();

        if($payment_policy_detail->loan_generate_type==1){
            $data_get = DB::table("nso007_payment_policy_detail_loan_without_interest")->where("payment_policy_detail_id",$payment_policy_detail->id)->get();
            $get_main = array();
        }else if($payment_policy_detail->loan_generate_type==2){
            $data_get = DB::table("nso007_payment_policy_detail_loan_with_interest")->where("payment_policy_detail_id",$payment_policy_detail->id)->get();
            $get_main = array();
        }else if($payment_policy_detail->loan_generate_type==3){
            $get_main = DB::table("nso007_payment_policy_detail_loan_with_interest")->select("loan_type","duration")->where("payment_policy_detail_id",$payment_policy_detail->id)->first();
            $data_get = DB::table("nso007_payment_policy_detail_loan_change_interest")->select("from_month","to_month","interest")->where("payment_policy_detail_id",$payment_policy_detail->id)->orderBy("id","ASC")->get();

        }else{
            $data_get = array();
            $get_main = array();
        }
        $data = array(
            "loan_generate_type"=>$payment_policy_detail->loan_generate_type,
            'data'=>$data_get,
            'get_main'=>$get_main
            );
        return json_encode($data);
    }
}
