<?php

namespace App\Http\Controllers\HR;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Hr\TimePolicyModel;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\Gate;

class TimePolicyController extends Controller
{


    function __construct()
    {
        $this->middleware('permission:Time Policy List', ['only' => ['index']]);
        $this->middleware('permission:Time Policy Create', ['only' => ['create','store']]);
        $this->middleware('permission:Time Policy Edit', ['only' => ['edit','update']]);
        $this->middleware('permission:Time Policy Delete', ['only' => ['delete_time_policy']]);
    }
    public function index(Request $request)
    {
        if($request->ajax())
        {
            $data = TimePolicyModel::take(20);
            return DataTables::of($data)
            ->addIndexColumn()
            ->addColumn('action', function($data){
                $btn_edit="";
                $btn_delete="";
                if(Gate::check('Time Policy Edit')){
                    $btn_edit .= '<a href="'.route('hr-time-policy.edit',encrypt($data->id)).'" class="btn btn-sm btn-warning"><span class="fa fa-edit"></span> Edit</a>&nbsp;';
                }
                if(Gate::check('Time Policy Delete')) {
                    $btn_delete .= '<a class="btn btn-sm btn-danger btn_delete" data-id="' . $data->id . '"><span class="fa fa-times"></span> Delete</a>';
                }
                return $btn_edit.$btn_delete;
            })
            ->rawColumns(['action', 'action'])
            ->make(true);
        }
        return view('hr.time-policy.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('hr.time-policy.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required'
        ]);

        $time_policy                = new TimePolicyModel();
        $time_policy->name          = $request->name;
        $time_policy->time_in       = $request->time_in;
        $time_policy->time_out      = $request->time_out;
        $time_policy->ot_time_in    = $request->ot_time_in;
        $time_policy->ot_time_out   = $request->ot_time_out;
        $time_policy->note          = $request->note;
        $time_policy->save();

        return redirect()->route('hr-time-policy.index')->with('success', 'Time Policy was added Succesful!');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $id = decrypt($id);
        $time_policy = TimePolicyModel::findOrFail($id);

        return view('hr.time-policy.edit', compact('time_policy'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required'
        ]);

        $time_policy                = TimePolicyModel::findOrFail($id);
        $time_policy->name          = $request->name;
        $time_policy->time_in       = $request->time_in;
        $time_policy->time_out      = $request->time_out;
        $time_policy->ot_time_in    = $request->ot_time_in;
        $time_policy->ot_time_out   = $request->ot_time_out;
        $time_policy->note          = $request->note;
        $time_policy->update();

        return redirect()->route('hr-time-policy.index')->with('success', 'Time Policy was updated Succesful!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function delete_time_policy(Request $request)
    {
        $id = $request->delete_id;
        TimePolicyModel::where('id', $id)->delete();
        return redirect()->route('hr-time-policy.index')->with('success', 'Time Policy was deleted Succesful!');
    }
}
