<?php

namespace App\Http\Controllers\HR;

use App\Models\Hr\HrGenSalaryModel;
use App\Http\Controllers\Controller;
use App\Models\Hr\HrBranch;
use App\Models\Hr\HrDepartmentModel;
use App\Models\Hr\HrPositionModel;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ReportHrController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:Report Payslip', ['only' => ['viewPaySlipShow', 'viewPaySlip']]);
    }

    public function index()
    {
        return view('hr.report-hr.index');
    }
    public function viewPayroll(Request $request)
    {

        $emp_id     = $request->emp_id;
        $from_date  = $request->from_date;
        $to_date    = $request->to_date;

        $month      = $request->month;
        $y_m        = explode('-', $month);
        $year       = isset($y_m[1])?$y_m[1]:date('Y');
        $month      = isset($y_m[0])?$y_m[0]:date('m');

        $payroll = HrGenSalaryModel::where(function ($q) use ($emp_id)
        {
            if($emp_id != null){
                if(is_array($emp_id)){
                    if(count($emp_id) > 0){
                        $q->whereIn('emp_id', $emp_id);
                    }
                }else{
                    $q->whereIn('emp_id', $emp_id);
                }
            }
        })
        ->where('status', 1)
        ->get();

        return view('hr.report-hr.payroll',compact('payroll'));
    }

    public function viewPaySlip()
    {
        $branch     = HrBranch::pluck('english_name', 'id');
        $department = HrDepartmentModel::pluck('english_name', 'id');
        $position   = HrPositionModel::pluck('english_name', 'id');
        $user       = User::pluck('english_name', 'id')->prepend(__('administrator.please_select'),'');

        return view('hr.report-hr.report-payslip', compact('branch', 'department', 'position', 'user'));
    }
    public function viewPaySlipShow(Request $request)
    {

        $emp_id         = $request->emp_id;
        $branch_id      = $request->branch_id;
        $department_id  = $request->department_id;
        $position_id    = $request->position_id;
        $from_date      = date('Y-m-d', strtotime($request->from_date));
        $to_date        = date('Y-m-d', strtotime($request->to_date));

        $month          = $request->month;
        $y_m            = explode('-', $month);
        $year           = isset($y_m[1])?$y_m[1]:date('Y');
        $month          = isset($y_m[0])?$y_m[0]:date('m');

        $payroll = HrGenSalaryModel::where(function ($q) use ($emp_id)
            {
                if($emp_id != null){
                    if(is_array($emp_id)){
                        if(count($emp_id) > 0){
                            $q->whereIn('emp_id', $emp_id);
                        }
                    }else{
                        $q->whereIn('emp_id', $emp_id);
                    }
                }else{
                    $q->where('status', 1);
                }
            })
            ->where(function($q) use ($from_date, $to_date){
                if ($from_date != null || $to_date != null) {
                    $q->whereBetween('g_date', [$from_date, $to_date]);
                }
            })
            ->when($branch_id, function($q, $branch_id){
                if($branch_id != null){
                    if(is_array($branch_id)){
                        if(count($branch_id) > 0){
                            $q->whereIn('branch_id', $branch_id);
                        }
                    }
                }
            })
            ->when($department_id, function($q, $department_id){
                if($department_id != null){
                    if(is_array($department_id)){
                        if(count($department_id) > 0){
                            $q->whereIn('department_id', $department_id);
                        }
                    }
                }
            })
            ->when($position_id, function($q, $position_id){
                if($position_id != null){
                    if(is_array($position_id)){
                        if(count($position_id) > 0){
                            $q->whereIn('position_id', $position_id);
                        }
                    }
                }
            })
            ->get();

        return view('hr.report-hr.payroll.payslip-payroll', compact('payroll'));
    }

}
