<?php

namespace App\Http\Controllers\HR;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Hr\OvertimePolicyModel;
use App\Models\Hr\OvertimeTypeModel;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\Gate;

class OvertimePolicyController extends Controller
{

    function __construct()
    {
        $this->middleware('permission:OT Policy List', ['only' => ['index']]);
        $this->middleware('permission:OT Policy Create', ['only' => ['create','store']]);
        $this->middleware('permission:OT Policy Edit', ['only' => ['edit','update']]);
        $this->middleware('permission:OT Policy Delete', ['only' => ['get_overtime_type']]);
    }
    public function index(Request $request)
    {
        if($request->ajax())
        {
            $data = OvertimePolicyModel::take(20);

            return DataTables::of($data)
                        ->addIndexColumn()
                        ->addColumn('action', function($data){
                            $btn_edit ="";
                            $btn_delete ="";
                            if(Gate::check('OT Policy Edit')){
                                $btn_edit .= '<a href="'.route('overtime-policy.edit', encrypt($data->id)).'" class="btn btn-sm btn-warning"><span class="fa fa-edit"></span> Edit</a>&nbsp;';
                            }
                            if(Gate::check('OT Policy Delete')) {
                                $btn_delete .= '<a class="btn btn-sm btn-danger btn_delete" data-id="' . $data->id . '"><span class="fa fa-trash"></span> Delete</a>';
                            }
                            return $btn_edit.$btn_delete;
                        })

                        ->rawColumns(['action', 'action'])
                        ->make(true);
        }
        return view('hr.overtime-policy.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $overtime_type = OvertimeTypeModel::pluck('en_name', 'id')->prepend('Please Select', '');
        return view('hr.overtime-policy.create', compact('overtime_type'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name'              => 'required',
            'normal_ot_rate'    => 'required',
            'sunsat_ot_rate'    => 'required',
            'holiday_ot_rate'   => 'required',
            'effect_date'       => 'required'
        ]);


        $ot_policy                      = new OvertimePolicyModel();
        $ot_policy->name                = $request->name;
        $ot_policy->normal_ot_rate      = $request->normal_ot_rate;
        $ot_policy->sunsat_ot_rate      = $request->sunsat_ot_rate;
        $ot_policy->holiday_ot_rate     = $request->holiday_ot_rate;
        $ot_policy->effect_date         = $request->effect_date != null ? date('Y-m-d', strtotime($request->effect_date)) : null;
        $ot_policy->note                = $request->note;
        $ot_policy->save();

        return redirect()->route('overtime-policy.index')->with('success', 'Data was saved successful!');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $id = decrypt($id);
        $overtime_policy    = OvertimePolicyModel::findOrFail($id);
        $overtime_type      = OvertimeTypeModel::pluck('en_name', 'id')->prepend('Please Select', '');
        return view('hr.overtime-policy.edit', compact('overtime_policy', 'overtime_type'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $this->validate($request, [
            'name'              => 'required',
            'normal_ot_rate'    => 'required',
            'sunsat_ot_rate'    => 'required',
            'holiday_ot_rate'   => 'required',
            'effect_date'       => 'required'
        ]);


        $ot_policy                      = OvertimePolicyModel::findOrFail($id);
        $ot_policy->name                = $request->name;
        $ot_policy->normal_ot_rate      = $request->normal_ot_rate;
        $ot_policy->sunsat_ot_rate      = $request->sunsat_ot_rate;
        $ot_policy->holiday_ot_rate     = $request->holiday_ot_rate;
        $ot_policy->effect_date         = $request->effect_date != null ? date('Y-m-d', strtotime($request->effect_date)) : null;
        $ot_policy->note                = $request->note;
        $ot_policy->update();

        return redirect()->route('overtime-policy.index')->with('success', 'Data was updated successful!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    // get benefit type
    public function get_overtime_type(Request $request)
    {
        $data = OvertimeTypeModel::where('id', $request->id)->first();
        return response()->json($data);
    }
    public function delete_overtime_policy(Request $request)
    {
        $id = $request->delete_id;
        OvertimePolicyModel::where('id', $id)->delete();
        return redirect()->route('overtime-policy.index')->with('success', 'Data was deleted successful!');

    }
}
