<?php

namespace App\Http\Controllers\HR;

use App\Models\Hr\HrTrainingCourseModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DateTime;
use Illuminate\Support\Facades\Gate;
use Yajra\DataTables\DataTables;

class HrTrainingCourseController extends Controller
{

    function __construct()
    {
        $this->middleware('permission:Training Course Create', ['only' => ['create', 'store']]);
        $this->middleware('permission:Training Course List', ['only' => ['index']]);
        $this->middleware('permission:Training Course Edit', ['only' => ['update','edit']]);
    }
    public function index(Request $request)
    {
        $training_course = HrTrainingCourseModel::get();
        if($request->ajax())
        {
            return DataTables::of($training_course->take(20))
            ->addIndexColumn()
            ->with([
                "recordsTotal" => $training_course->count(),
                "recordsFiltered" => $training_course->count()
            ])
            ->editColumn('date', function($data){
                return $data->date ? date('d-m-Y', strtotime($data->date)) : '';
            })
            ->addColumn('action', function($data){
                $btn_edit = '';
                if(Gate::check('Training Course Edit')){
                    $btn_edit = '<a href="'.route('hr-training-course.edit', $data->id).'" class="btn btn-sm btn-warning"><span class="fa fa-edit"></span> Edit</a>';
                }
                return $btn_edit;
            })
            ->rawColumns(['action'])
            ->make(true);
        }
        return view('hr.training-course.index', compact('training_course'));
    }


    public function create()
    {
        return view('hr.training-course.create');
    }


    public function store(Request $request)
    {
        $this->validate($request, [
            'name'          => 'required',
            'description'   => 'required'
        ]);

        $training_course = new HrTrainingCourseModel();
        $training_course->name          = $request->name;
        $training_course->description   = $request->description;
        $training_course->date          = $request->date != null ? date('Y-m-d', strtotime($request->date)):date(now());
        $training_course->save();

        return redirect()->route('hr-training-course.index')->with('success', 'Added Successful!');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\HrTrainingCourseModel  $hrTrainingCourseModel
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\HrTrainingCourseModel  $hrTrainingCourseModel
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $training_course = HrTrainingCourseModel::find($id);
        return view('hr.training-course.edit', compact('training_course'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\HrTrainingCourseModel  $hrTrainingCourseModel
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $this->validate($request, [
            'name'          => 'required',
            'description'   => 'required'
        ]);

        $training_course = HrTrainingCourseModel::find($id);
        $training_course->name          = $request->name;
        $training_course->description   = $request->description;
        $training_course->date          = date('Y-m-d', strtotime($request->date));
        $training_course->update();

        return redirect()->route('hr-training-course.index')->with('success', 'Updated Successful!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\HrTrainingCourseModel  $hrTrainingCourseModel
     * @return \Illuminate\Http\Response
     */
    public function destroy(HrTrainingCourseModel $hrTrainingCourseModel)
    {
        //
    }
}
