<?php

namespace App\Http\Controllers\HR;

use App\Models\Hr\HrSoftSkill;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Gate;
use Yajra\DataTables\DataTables;

class HrSoftSkillController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:SoftSkill Create', ['only' => ['create', 'store']]);
        $this->middleware('permission:SoftSkill List', ['only' => ['index']]);
        $this->middleware('permission:SoftSkill Edit', ['only' => ['update','edit']]);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $soft_skill = HrSoftSkill::get();
        if($request->ajax())
        {
            return DataTables::of($soft_skill->take(20))
            ->addIndexColumn()
            ->with([
                "recordsTotal" => $soft_skill->count(),
                "recordsFiltered" => $soft_skill->count()
            ])
            ->addColumn('action', function($row){
                $btn_edit = '';
                if(Gate::check('SoftSkill Edit')){
                    $btn_edit = '<a href="'.route('hr-soft-skill.edit',$row->id).'" class="btn btn-sm btn-warning"><span class="fa fa-edit"></span> Edit</a>';
                }
                return $btn_edit;
            })
            ->rawColumns(['action'])
            ->make(true);
        }
        return view('hr.soft-skill.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('hr.soft-skill.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required'
        ]);

        $soft_skill = new HrSoftSkill();
        $soft_skill->name = $request->name;
        $soft_skill->note = $request->note;
        $soft_skill->save();

        return redirect()->route('hr-soft-skill.index')->with('Success', 'Added Successful!');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\HrSoftSkill  $hrSoftSkill
     * @return \Illuminate\Http\Response
     */
    public function show(HrSoftSkill $hrSoftSkill)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\HrSoftSkill  $hrSoftSkill
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $soft_skill = HrSoftSkill::find($id);
        return view('hr.soft-skill.edit', compact('soft_skill'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\HrSoftSkill  $hrSoftSkill
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required'
        ]);

        $soft_skill = HrSoftSkill::find($id);
        $soft_skill->name = $request->name;
        $soft_skill->note = $request->note;
        $soft_skill->update();

        return redirect()->route('hr-soft-skill.index')->with('Success', 'Updated Successful!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\HrSoftSkill  $hrSoftSkill
     * @return \Illuminate\Http\Response
     */
    public function destroy(HrSoftSkill $hrSoftSkill)
    {
        //
    }
}
