<?php

namespace App\Http\Controllers\HR;

use App\Fun\Fun;
use App\Models\Hr\HrPositionModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\Gate;

class HrPositionController extends Controller
{

    function __construct()
    {
        $this->middleware('permission:Position List', ['only' => ['index','get_position']]);
        $this->middleware('permission:Position Create', ['only' => ['create','store']]);
        $this->middleware('permission:Position Edit', ['only' => ['edit','update']]);
        $this->middleware('permission:Position Delete', ['only' => ['delete_position']]);
    }
    public function index()
    {
        return view('hr.position.index');
    }

    public function get_position()
    {
        $data = HrPositionModel::get();
        return DataTables::of($data->take(20))
            ->addIndexColumn()
            ->addColumn('action', function ($data) {
                $check_language = Fun::lang();
                if ($check_language == 'km') {
                    $edit = "កែសម្រួល";
                    $delete = "លុបចោល";
                } else {
                    $edit = "Edit";
                    $delete = "Delete";
                }
                $_edit="";
                $_delete='';

                if(Gate::check('Position Edit')){
                    $_edit .= '<a href="'.route('hr-position.edit',encrypt($data->id)).'" class="btn btn-sm btn-warning"><span class="fa fa-edit"></span> Edit</a>&nbsp;';
                }
                if(Gate::check('Position Delete')) {
                    $_delete .= '<a class="btn btn-sm btn-danger btn_delete_position" data-id="' . $data->id . '" data-target=""><span class="fa fa-times"></span> Delete</a>';
                }
                return $_edit.$_delete;
            })
            ->rawColumns(['action' => 'action'])
            ->make(true);
    }

    public function create()
    {
        return view('hr.position.create');
    }

    public function store(Request $request)
    {
        $this->validate($request,[
            'code'          =>'required',
            'english_name'  =>'required',
            'khmer_name'    =>'required',
        ]);

        $job                    = new HrPositionModel();
        $job->code              = $request->code;
        $job->english_name      = $request->english_name;
        $job->khmer_name        = $request->khmer_name;
        $job->description       = $request->description;

        if($job->save()){
            return redirect()->route('hr-position.index')->with('success','Job was inserted successful...');
        }else{
            return redirect()->route('hr-position.index')->with('danger','Job was not inserted...');
        }
    }

    public function show($id)
    {
        //
    }


    public function edit($id)
    {
        $job = HrPositionModel::find(decrypt($id));
        return view('hr.position.edit',compact('job'));
    }

    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'code'          =>'required',
            'english_name'  =>'required',
            'khmer_name'    =>'required',
        ]);

        $job                    = HrPositionModel::find($id);
        $job->code              = $request->code;
        $job->english_name      = $request->english_name;
        $job->khmer_name        = $request->khmer_name;
        $job->description       = $request->description;

        if($job->update()){
            return redirect()->route('hr-position.index')->with('success','Position was updated successful...');
        }else{
            return redirect()->route('hr-position.index')->with('danger','Position was not updated...');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    //delete position
    public function delete_position(Request $request)
    {
        $id = $request->delete_id;
        HrPositionModel::where('id', $id)->delete();

        return redirect()->route('hr-position.index')->with('success', 'Deleted Successful!.');
    }
}
