<?php

namespace App\Http\Controllers\HR;

use App\Fun\Fun;
use App\Models\Hr\HrLeaveTypeModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Yajra\DataTables\DataTables;

class HrLeaveTypeController extends Controller
{

    public function index()
    {
        return view('hr.leave-type.index');
    }

    public function get_leave_type()
    {
        $data = HrLeaveTypeModel::get();
        return DataTables::of($data)
            ->addIndexColumn()
            ->editColumn('leave_per_year', function ($data){
                $check_language = Fun::lang();

                if ($check_language == 'km') {
                    $day = "ថ្ងៃ";
                } else {
                    $day = "Day";
                }
                return $data->leave_per_year.$day;
            })
            ->addColumn('action', function ($data) {
                $check_language = Fun::lang();

                if ($check_language == 'km') {
                    $edit = "កែសម្រួល";
                } else {
                    $edit = "Edit";
                }
                $del = '';
                return '<a href="'.route('hr-leave-type.edit',encrypt($data->id)).'" class="button_warning">'.$edit.'</a>';
            })

            ->rawColumns(['action' => 'action', 'complete_status' => 'complete_status'])
            ->make(true);
    }

    public function create()
    {
        return view('hr.leave-type.create');
    }

    public function store(Request $request)
    {
        $this->validate($request,[
            'name'=>'required',
            'leave_per_year'=>'required',
        ]);
        $ltype = new HrLeaveTypeModel();
        $ltype->name = $request->name;
        $ltype->leave_per_year = $request->leave_per_year;
        $ltype->note = $request->note;
        $ltype->save();
        return redirect()->route('hr-leave-type.index')->with('success','Leave type was inserted successful...');

    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $type = HrLeaveTypeModel::find(decrypt($id));
        return view('hr.leave-type.edit',compact('type'));
    }

    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'name'=>'required',
            'leave_per_year'=>'required',
        ]);
        $ltype = HrLeaveTypeModel::find($id);
        $ltype->name = $request->name;
        $ltype->leave_per_year = $request->leave_per_year;
        $ltype->note = $request->note;
        $ltype->update();
        return redirect()->route('hr-leave-type.index')->with('success','Leave type was updated successful...');
    }

    public function destroy($id)
    {
        //
    }
}
