<?php

namespace App\Http\Controllers\HR;

use App\Fun\Fun;
use App\Models\Hr\HrJobFunctionModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\Gate;

class HrJobFunctionController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:Job Function Create', ['only' => ['create', 'store']]);
        $this->middleware('permission:Job Function List', ['only' => ['index','get_function']]);
        $this->middleware('permission:Job Function Edit', ['only' => ['update','edit']]);
    }

    public function index()
    {
        return view('hr.job-function.index');
    }
    public function get_function()
    {
        $data = HrJobFunctionModel::get();
        return DataTables::of($data->take(20))
            ->addIndexColumn()
            ->addColumn('action', function ($data) {
                $check_language = Fun::lang();
                if ($check_language == 'km') {
                    $edit = "កែសម្រួល";
                } else {
                    $edit = "Edit";
                }
                $btn_edit = "";
                if (Gate::check('Job Function Edit')){
                    $btn_edit .= '<a href="' . route('hr-job-function.edit', encrypt($data->id)) . '" class="btn btn-sm btn-warning"><i class="fa fa-edit"></i>' . $edit . '</a>';
                }
                return $btn_edit;
            })

            ->rawColumns(['action' => 'action'])
            ->make(true);
    }

    public function create()
    {
        return view('hr.job-function.create');
    }

    public function store(Request $request)
    {
        $this->validate($request,[
            'name'=>'required',
        ]);
        $ben = new HrJobFunctionModel();
        $ben->name = $request->name;
        $ben->note = $request->note;
        $ben->save();
        return redirect()->route('hr-job-function.index')->with('success','Education level was inserted successful...');
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $ben = HrJobFunctionModel::find(decrypt($id));
        return view('hr.job-function.edit',compact('ben'));
    }

    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'name'=>'required',
        ]);
        $ben = HrJobFunctionModel::find($id);
        $ben->name = $request->name;
        $ben->note = $request->note;
        $ben->update();
        return redirect()->route('hr-job-function.index')->with('success','Education level was updated successful...');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
