<?php

namespace App\Http\Controllers\HR;

use App\Fun\Fun;
use App\Models\Hr\HrJobEmploymentTypeModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\Gate;

class HrJobEmploymentTypeController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:Employment type Create', ['only' => ['create', 'store']]);
        $this->middleware('permission:Employment type List', ['only' => ['index','get_employment_type']]);
        $this->middleware('permission:Employment type Edit', ['only' => ['update','edit']]);
    }
    public function index()
    {
        return view('hr.job-employment-type.index');
    }
    public function get_employment_type()
    {
        $data = HrJobEmploymentTypeModel::get();
        return DataTables::of($data->take(20))
            ->addIndexColumn()
            ->addColumn('action', function ($data) {
                $check_language = Fun::lang();
                if ($check_language == 'km') {
                    $edit = "កែសម្រួល";
                } else {
                    $edit = "Edit";
                }
                $btn_edit="";
                if(Gate::check('Employment type Edit')){
                    $btn_edit .='<a href="'.route('hr-job-employment-type.edit',encrypt($data->id)).'" class="btn btn-sm btn-warning"><i class="fa fa-edit"></i> '.$edit.'</a>';
                }
                return $btn_edit;
            })

            ->rawColumns(['action' => 'action'])
            ->make(true);
    }

    public function create()
    {
        return view('hr.job-employment-type.create');
    }

    public function store(Request $request)
    {
        $this->validate($request,[
            'name'=>'required',
        ]);
        $ben = new HrJobEmploymentTypeModel();
        $ben->name = $request->name;
        $ben->note = $request->note;
        $ben->save();
        return redirect()->route('hr-job-employment-type.index')->with('success','Experience level was inserted successful...');
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $ben = HrJobEmploymentTypeModel::find(decrypt($id));
        return view('hr.job-employment-type.edit',compact('ben'));
    }

    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'name'=>'required',
        ]);
        $ben = HrJobEmploymentTypeModel::find($id);
        $ben->name = $request->name;
        $ben->note = $request->note;
        $ben->update();
        return redirect()->route('hr-job-employment-type.index')->with('success','Experience level was updated successful...');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
