<?php

namespace App\Http\Controllers\HR;

use App\Fun\Fun;
use App\Models\Hr\HrJobEducationLevelModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Gate;
use Yajra\DataTables\DataTables;

class HrJobEducationLevelController extends Controller
{

    function __construct()
    {
        $this->middleware('permission:Education level Create', ['only' => ['create', 'store']]);
        $this->middleware('permission:Education level List', ['only' => ['index','get_education_level']]);
        $this->middleware('permission:Education level Edit', ['only' => ['update','edit']]);
    }
    public function index()
    {
        return view('hr.job-education-level.index');
    }
    public function get_education_level()
    {
        $data = HrJobEducationLevelModel::get();
        return DataTables::of($data->take(20))
            ->addIndexColumn()
            ->addColumn('action', function ($data) {
                $check_language = Fun::lang();
                if ($check_language == 'km') {
                    $edit = "កែសម្រួល";
                } else {
                    $edit = "Edit";
                }
                $btn_edit="";
                if(Gate::check('Education level Edit')) {
                    $btn_edit .= '<a href="' . route('hr-job-education-level.edit', encrypt($data->id)) . '" class="btn btn-sm btn-warning"><i class="fa fa-edit"></i>' . $edit . '</a>';
                }
                return $btn_edit;
            })

            ->rawColumns(['action' => 'action'])
            ->make(true);
    }

    public function create()
    {
        return view('hr.job-education-level.create');
    }

    public function store(Request $request)
    {
        $this->validate($request,[
            'name'=>'required',
        ]);
        $ben = new HrJobEducationLevelModel();
        $ben->name = $request->name;
        $ben->note = $request->note;
        $ben->save();
        return redirect()->route('hr-job-education-level.index')->with('success','Education level was inserted successful...');
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $ben = HrJobEducationLevelModel::find(decrypt($id));
        return view('hr.job-education-level.edit',compact('ben'));
    }

    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'name'=>'required',
        ]);
        $ben = HrJobEducationLevelModel::find($id);
        $ben->name = $request->name;
        $ben->note = $request->note;
        $ben->update();
        return redirect()->route('hr-job-education-level.index')->with('success','Education level was updated successful...');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
