<?php

namespace App\Http\Controllers\HR;

use App\Fun\Fun;
use App\Models\Hr\HrHolidayModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use Yajra\DataTables\DataTables;
use Importer;
use Illuminate\Support\Facades\Gate;

class HrHolidayController extends Controller
{


    function __construct()
    {
        $this->middleware('permission:Holiday List', ['only' => ['index','get_holiday']]);
        $this->middleware('permission:Holiday Create', ['only' => ['create','store']]);
        $this->middleware('permission:Holiday Edit', ['only' => ['edit','update']]);
        $this->middleware('permission:Holiday Delete', ['only' => ['delete_holiday']]);
    }

    public function index()
    {
        return view('hr.holiday.index');
    }

    public function get_holiday()
    {
        $hol = HrHolidayModel::where('status',1)->orderBy('year', 'DESC')->take(20);

        return DataTables::of($hol)
                        ->addIndexColumn()
                        ->editColumn('from_date', function($data){
                            return $data->from_date ? date('d-m-Y', strtotime($data->from_date)) : "";
                        })
                        ->editColumn('to_date', function($data){
                            return $data->to_date ? date('d-m-Y', strtotime($data->to_date)) : "";
                        })
                        ->addColumn('action', function($data){
                            $check_language = Fun::lang();

                            if ($check_language == 'km') {
                                $edit = "កែសម្រួល";
                                $delete= "លុបចោល";
                            } else {
                                $edit = "Edit";
                                $delete = "Delete";
                            }
                            $btn_edit="";
                            $btn_delete ="";
                            if(Gate::check('Holiday Edit')){
                                $btn_edit .= '<a href="'.route('hr-holiday.edit', encrypt($data->id)).'" class="btn btn-sm btn-warning" title="'.$edit.'"><span class="fa fa-edit"></span> Edit</a>&nbsp;';
                            }
                            if(Gate::check('Holiday Delete')) {
                                $btn_delete .= '<a class="btn btn-sm btn-danger btn_del_holiday" data-id="' . $data->id . '" title="' . $delete . '"><span class="fa fa-trash"></span> Delete</a>';
                            }
                            return $btn_edit.$btn_delete;
                        })
                        ->rawColumns(['action' => 'action'])
                        ->make(true);
    }

    public function create()
    {
        return view('hr.holiday.create');
    }

    public function store(Request $request)
    {

        $this->validate($request,[

            'name_en'       => 'required',
            'name_kh'       => 'required',
            'from_date'     => 'required',
            'to_date'       => 'required'

        ]);

        $hol                = new HrHolidayModel();
        $hol->name_en       = $request->name_en;
        $hol->name_kh       = $request->name_kh;
        $hol->from_date     = date('Y-m-d',strtotime($request->from_date));
        $hol->to_date       = date('Y-m-d',strtotime($request->to_date));
        $hol->year          = $request->year;
        $hol->note          = $request->note;
        $hol->save();
        return redirect()->route('hr-holiday.index')->with('success','Holiday was saved successful ...');
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $id = decrypt($id);
        $hol = HrHolidayModel::find($id);
        return view('hr.holiday.edit',compact('hol'));
    }

    public function update(Request $request, $id)
    {
        $this->validate($request,[


            'name_en'       => 'required',
            'name_kh'       => 'required',
            'from_date'     => 'required',
            'to_date'       => 'required'


        ]);

        $hol                = HrHolidayModel::find($id);
        $hol->name_en       = $request->name_en;
        $hol->name_kh       = $request->name_kh;
        $hol->from_date     = date('Y-m-d',strtotime($request->from_date));
        $hol->to_date       = date('Y-m-d',strtotime($request->to_date));
        $hol->year          = $request->year;
        $hol->note          = $request->note;

        $hol->update();
        return redirect()->route('hr-holiday.index')->with('success','Holiday was updated successful ...');
    }

    public function destroy($id)
    {
        //
    }
    public function delete_holiday(Request $request)
    {
        $id = $request->delete_id;
        HrHolidayModel::where('id', $id)->delete();

        return redirect()->route('hr-holiday.index')->with('success','Holiday was deleted successful ...');
    }
    public function importHoliday(Request $request)
    {
        $validator = Validator::make($request->all(),[
           'excel' => 'required|mimes:xlsx,xls,csv'
        ]);

        if($validator->passes())
        {
            $dateTime       = date('Ymd_His');
            $file           = $request->file('excel');
            $file_name      = $dateTime.'-'.$file->getClientOriginalName();
            $path           = public_path('/uploads/');
            $file->move($path,$file_name);
            $excel          = Importer::make('excel');
            $excel->load($path.$file_name);
            $collection     = $excel->getCollection();
            if(sizeof($collection[0]) == 7)
            {
                foreach ($collection as $key => $ex_file)
                {
                    if($key > 0)
                    {
                        try
                        {
                            $holiday            = new HrHolidayModel();
                            $holiday->name_en   = !empty($ex_file[1]) ? $ex_file[1] : null;
                            $holiday->name_kh   = !empty($ex_file[0]) ? $ex_file[0] : null;
                            $holiday->from_date = !empty($ex_file[2]) ? date('Y-m-d',strtotime($ex_file[2])) : null;
                            $holiday->to_date   = !empty($ex_file[3]) ? date('Y-m-d',strtotime($ex_file[3])) : null;
                            $holiday->year      = !empty($ex_file[4]) ? $ex_file[4] : null;
                            $holiday->status    = !empty($ex_file[5]) ? $ex_file[5] : null;
                            $holiday->note      = !empty($ex_file[6]) ? $ex_file[6] : null;
                            $holiday->save();

                        }
                        catch (\Exception $e)
                        {
                            return $e->getMessage();
                        }
                    }
                }

                return redirect()->route('hr-holiday.index')->with('success','Holiday was create successful ...');

            }
            else
            {
                return redirect()->back()->with('danger','Please check your file!');
            }
        }
        else
        {
            return redirect()->back()->with(['danger' => $validator->errors()->all()]);
        }
    }
}
