<?php

namespace App\Http\Controllers\HR;

use App\User;
use App\Models\Hr\HrEvaluationModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Gate;
use Yajra\DataTables\DataTables;

class HrEvaluationController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:Evaluation Create', ['only' => ['create', 'store']]);
        $this->middleware('permission:Evaluation List', ['only' => ['index']]);
        $this->middleware('permission:Evaluation Show', ['only' => ['show']]);
        $this->middleware('permission:Evaluation Edit', ['only' => ['update','edit']]);
    }
    public function index(Request $request)
    {
        $eval = HrEvaluationModel::get();
        if($request->ajax())
        {
            return DataTables::of($eval->take(20))
            ->addIndexColumn()
            ->editColumn('date', function($data){
                return $data->date ? date('d-m-Y', strtotime($data->date)) : '';
            })
            ->addColumn('employee', function($data){
                return optional($data->employee)->english_name;
            })
            ->addColumn('action', function($row){
                $btn_edit = '';
                $btn_show = '';
                if(Gate::check('Evaluation Edit')){
                    $btn_edit = '<a href="'.route('hr-evaluation.edit', $row->id).'" class="btn btn-sm btn-warning"><span class="fa fa-edit"></span> Edit</a> &nbsp;';
                }
                if(Gate::check('Evaluation Show')){
                    $btn_show = '<a href="'.route('hr-evaluation.show', encrypt($row->id)).'" class="btn btn-sm btn-info" target="_blank"><span class="fa fa-eye"></span> Show</a>';
                }
                return $btn_edit.' '.$btn_show;
            })
            ->rawColumns(['action', 'employee'])
            ->make(true);
        }
        return view('hr.evaluation.index', compact('eval'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $emp = User::where('status', 1)->pluck('english_name', 'id');
        return view('hr.evaluation.create', compact('emp'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $request->validate([
            'emp_id' => 'required',
        ]);

        $evaluate                   = new HrEvaluationModel();
        $evaluate->emp_id           = $request->emp_id;
        $evaluate->attitude         = $request->attitude;
        $evaluate->interest         = $request->interest;
        $evaluate->communicate      = $request->communicate;
        $evaluate->work_quality     = $request->work_quality;
        $evaluate->productivity     = $request->productivity;
        $evaluate->knowledge        = $request->knowledge;
        $evaluate->technical_skill  = $request->technical_skill;
        $evaluate->teamwork         = $request->teamwork;
        $evaluate->attendance       = $request->attendance;
        $evaluate->creativity       = $request->creativity;
        $evaluate->enthusiasm       = $request->enthusiasm;
        $evaluate->date             = date('Y-m-d',strtotime($request->date));
        $evaluate->note             = $request->note;

        $evaluate->save();

        return redirect()->route('hr-evaluation.index')->with('Success', 'Added Success!');

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\HrEvaluationModel  $hrEvaluationModel
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $id = decrypt($id);
        $ev = HrEvaluationModel::find($id);
        return view('hr.evaluation.show', compact('ev'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\HrEvaluationModel  $hrEvaluationModel
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $emp = User::where('status', 1)->pluck('english_name', 'id');
        $evaluate = HrEvaluationModel::find($id);
        return view('hr.evaluation.edit', compact('evaluate','emp'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\HrEvaluationModel  $hrEvaluationModel
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'emp_id' => 'required',
        ]);

        $evaluate                   = HrEvaluationModel::find($id);
        $evaluate->emp_id           = $request->emp_id;
        $evaluate->attitude         = $request->attitude;
        $evaluate->interest         = $request->interest;
        $evaluate->communicate      = $request->communicate;
        $evaluate->work_quality     = $request->work_quality;
        $evaluate->productivity     = $request->productivity;
        $evaluate->knowledge        = $request->knowledge;
        $evaluate->technical_skill  = $request->technical_skill;
        $evaluate->teamwork         = $request->teamwork;
        $evaluate->attendance       = $request->attendance;
        $evaluate->creativity       = $request->creativity;
        $evaluate->enthusiasm       = $request->enthusiasm;
        $evaluate->date             = date('Y-m-d',strtotime($request->date));
        $evaluate->note             = $request->note;

        $evaluate->update();

        return redirect()->route('hr-evaluation.index')->with('Success', 'Updated Success!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\HrEvaluationModel  $hrEvaluationModel
     * @return \Illuminate\Http\Response
     */
    public function destroy(HrEvaluationModel $hrEvaluationModel)
    {
        //
    }
}
