<?php

namespace App\Http\Controllers\HR;

use App\Fun\Fun;
use App\Models\Hr\HrEmploymentStatusModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\Gate;

class HrEmploymentStatusController extends Controller
{

    function __construct()
    {
        $this->middleware('permission:Employment Status List', ['only' => ['index','get_employment_type']]);
        $this->middleware('permission:Employment Status Create', ['only' => ['create','store']]);
        $this->middleware('permission:Employment Status Edit', ['only' => ['edit','update']]);
        $this->middleware('permission:Employment Status Delete', ['only' => ['delete_employment_status']]);
    }
    public function index()
    {
        return view('hr.employment-status.index');
    }
    public function get_employment_type()
    {
        $data = HrEmploymentStatusModel::take(20);
        return DataTables::of($data)
            ->addIndexColumn()
            ->addColumn('action', function ($data) {
                $check_language = Fun::lang();

                if ($check_language == 'km') {
                    $edit = "កែសម្រួល";
                    $delete= "លុបចោល";
                } else {
                    $edit = "Edit";
                    $delete = "Delete";
                }
                $del = '';
                $btn_edit = "";
                $btn_delete="";
                if(Gate::check('Employment Status Edit')){
                    $btn_edit .= '<a href="'.route('hr-employment-status.edit',encrypt($data->id)).'" class="btn btn-sm btn-warning" title="'.$edit.'"><span class="fa fa-edit"></span> Edit</a>&nbsp;';
                }
                if(Gate::check('Employment Status Delete')) {
                    $btn_delete .= '<a class="btn btn-sm btn-danger btn_del_emp_status" data-id="' . $data->id . '" title="' . $delete . '"><span class="fa fa-trash"></span> Delete</a>';
                }
                return $btn_edit.$btn_delete;
            })

            ->rawColumns(['action' => 'action', 'complete_status' => 'complete_status'])
            ->make(true);
    }
    public function create()
    {
        return view('hr.employment-status.create');
    }
    public function store(Request $request)
    {
        $this->validate($request,[
            'name'=>'required',
        ]);
        $emp_status = new HrEmploymentStatusModel();
        $emp_status -> name = $request->name;
        $emp_status -> note = $request->note;
        $emp_status -> save();
        return redirect()->route('hr-employment-status.index')->with('success','Employment status inserted successful');
    }
    public function show($id)
    {
        //
    }
    public function edit($id)
    {
        $emp = HrEmploymentStatusModel::find(decrypt($id));
        return view('hr.employment-status.edit',compact('emp'));
    }
    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'name'=>'required',
        ]);
        $emp_status = HrEmploymentStatusModel::find($id);
        $emp_status -> name = $request->name;
        $emp_status -> note = $request->note;
        $emp_status -> update();
        return redirect()->route('hr-employment-status.index')->with('success','Employment status update successful');
    }
    public function destroy($id)
    {
        //
    }

    public function delete_employment_status(Request $request)
    {
        $id = $request->delete_id;
        HrEmploymentStatusModel::where('id', $id)->delete();
        return redirect()->route('hr-employment-status.index')->with('success','Delete Successful!...');
    }
}
