<?php

namespace App\Http\Controllers\HR;

use App\Fun\Fun;
use App\Models\Hr\HrEmployeeBenefitModel;
use App\Models\Hr\HrJobBenefitModel;
use App\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\Gate;

class HrEmployeeBenefitController extends Controller
{

    function __construct()
    {
        $this->middleware('permission:Benefit List', ['only' => ['index', 'get_employee_benefit']]);
        $this->middleware('permission:Benefit Create', ['only' => ['create','store']]);
        $this->middleware('permission:Benefit Edit', ['only' => ['edit','update']]);
    }
    public function index()
    {
        return view('hr.employee-benefit.index');
    }

    public function get_employee_benefit()
    {
        $data = HrEmployeeBenefitModel::groupby('emp_id')->take(20);
        return DataTables::of($data)
            ->addIndexColumn()
            ->addColumn('action', function ($data) {
                $check_language = Fun::lang();
                if ($check_language == 'km') {
                    $edit   = "កែសម្រួល";
                    $delete = "លុបចោល";
                } else {
                    $edit   = "Edit";
                    $delete = "Delete";
                }
                $btn_edit   = "";
                $btn_delete = "";
                if(Gate::check('Benefit Edit')) {
                    $btn_edit .= '<a href="' . route('hr-employee-benefit.edit', encrypt($data->emp_id)) . '" class="btn btn-sm btn-warning"><span class="fa fa-edit"></span> Edit</a>&nbsp;';
                }
                if(Gate::check('Benefit Delete')) {
                    $btn_delete .= '<a class="btn btn-sm btn-danger btn-delete-benefit" data-id="' . $data->id . '"><span class="fa fa-trash"></span> Delete</a>';
                }
                return $btn_edit.$btn_delete;
            })
            ->editColumn('emp_id', function ($data) {
                return optional($data->get_employee)->english_name;
            })
            ->editColumn('benefit_id', function ($data) {
                $benefit = HrEmployeeBenefitModel::where('emp_id', $data->emp_id)->get();

                $show_benefit = '';
                foreach ($benefit as $row) {
                    $show_benefit .= '<span class="button_info">' . optional($row->get_benefit)->name . '</span>';
                }
                return $show_benefit;
            })
            ->rawColumns(['action' => 'action', 'benefit_id' => 'benefit_id'])
            ->make(true);
    }

    public function create()
    {
        $benefit    = HrJobBenefitModel::where('status', 1)->pluck('name', 'id');
        $emp        = User::pluck('english_name', 'id')->prepend(__('administrator.please_select'),'');

        return view('hr.employee-benefit.create', compact('benefit', 'emp'));
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'benefit_id.*' => 'required',
            'employee.*'   => 'required',
        ]);

        $benefit    = $request->benefit_id;
        $employee   = $request->employee;
        $amount     = $request->amount;

        foreach ($employee as $key => $row) {
            if(isset($benefit))
            {
                if(count($benefit) > 0)
                {
                    foreach ($benefit as $k => $data)
                    {
                        $check = HrEmployeeBenefitModel::where('emp_id',$row)->where('benefit_id',$data)->count();
                        if($check==0){
                            $emp_benefit                = new HrEmployeeBenefitModel();
                            $emp_benefit->emp_id        = $row;
                            $emp_benefit->benefit_id    = $data;
                            $emp_benefit->amount        = $amount[$k];
                            $emp_benefit->save();
                        }else{
                            return redirect()->route('hr-employee-benefit.create')->with('Success', 'Duplicate Benefit Type!');
                        }
                    }
                }
            }

        }
        return redirect()->route('hr-employee-benefit.index')->with('success', 'Employee benefit was saved successful...');
    }

    public function show($id)
    {
        //
    }

    public function edit($emp_id)
    {
        $emp_benefit    = HrEmployeeBenefitModel::where('emp_id', decrypt($emp_id))->first();
        $benefit        = HrEmployeeBenefitModel::where('emp_id', decrypt($emp_id))->get();
        $benefit_type   = HrJobBenefitModel::where('status', 1)->pluck('name', 'id');
        $emp            = User::find($emp_benefit->emp_id);
        return view('hr.employee-benefit.edit', compact('benefit_type', 'emp_benefit', 'benefit', 'emp'));
    }

    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'benefit_id.*' => 'required',
        ]);

        HrEmployeeBenefitModel::where('emp_id',$id)->delete();
        $benefit = $request->benefit_id;
        $amount  = $request->amount;
        if(isset($benefit))
        {
            if(count($benefit) > 0)
            {
                foreach ($benefit as $k => $data)
                {
                    $emp_benefit                = new HrEmployeeBenefitModel();
                    $emp_benefit->emp_id        = $id;
                    $emp_benefit->benefit_id    = $data;
                    $emp_benefit->amount        = $amount[$k];
                    $emp_benefit->save();
                }
            }
        }

        return redirect()->route('hr-employee-benefit.index')->with('success', 'Employee benefit was updated successful...');
    }

    public function destroy($id)
    {
        //
    }
    // get benefit type
    public function get_benefit_type(Request $request)
    {
        $data = HrJobBenefitModel::where('id', $request->id)->first();
        return response()->json($data);
    }

    public function delete_benefit(Request $request)
    {
        $id = $request->delete_id;
        HrEmployeeBenefitModel::where('emp_id', $id)->delete();

        return redirect()->route('hr-employee-benefit.index')->with('success', 'Deleted Successful...');
    }
}
