<?php

namespace App\Http\Controllers\HR;

use App\Models\Hr\DevelopmentPlanModel;
use App\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Hr\HrHardSkill;
use App\Models\Hr\HrSoftSkill;
use App\Models\Hr\HrTraining;
use Yajra\DataTables\DataTables;

class HrDevelopmentPlanController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:Development plan Create', ['only' => ['create', 'store']]);
        $this->middleware('permission:Development plan List', ['only' => ['index']]);
        $this->middleware('permission:Development plan Edit', ['only' => ['update','edit']]);
    }
    public function index(Request $request)
    {
        $dev = DevelopmentPlanModel::with(['get_employee', 'get_request_to'])->get();
        if($request->ajax())
        {
            return DataTables::of($dev->take(20))
            ->addIndexColumn()
            ->addColumn('employee', function($row){
                return optional($row->get_employee)->english_name;
            })
            ->addColumn('request_to', function($row){
                return optional($row->get_request_to)->english_name;
            })
            ->addColumn('action', function($row){
                $btn_edit = '';
                $btn_edit = '<a href="'.route('hr-development-plan.edit',$row->id).'" class="btn btn-sm btn-warning"><span class="fa fa-edit"></span> Edit</a>';

                return $btn_edit;
            })
            ->rawColumns(['action'])
            ->make(true);
        }
        return view('hr.development-plan.index', compact('dev'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $emp        = User::where('status', 1)->pluck('english_name', 'id');
        $training   = HrTraining::get();
        $hard_skill = HrHardSkill::get();
        $soft_skill = HrSoftSkill::get();
        return view('hr.development-plan.create', compact('emp', 'training', 'hard_skill','soft_skill'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'emp_id'        => 'required',
            'request_to'    => 'required'
        ]);

        $dev                            = new DevelopmentPlanModel();
        $dev->emp_id                    = $request->emp_id;
        $dev->request_to                = $request->request_to;
        $dev->description_department    = $request->de_description;
        $dev->suggestion_training       = $request->training;
        $dev->suggestion_hard_skill     = $request->hard_skill;
        $dev->suggestion_soft_skill     = $request->soft_skill;
        $dev->description               = $request->description;

        $dev->save();

        return redirect()->route('hr-development-plan.index')->with('success', 'Added Successful!');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\DevelopmentPlanModel  $developmentPlanModel
     * @return \Illuminate\Http\Response
     */
    public function show(DevelopmentPlanModel $developmentPlanModel)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\DevelopmentPlanModel  $developmentPlanModel
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $dev        = DevelopmentPlanModel::find($id);
        $emp        = User::where('status', 1)->pluck('english_name', 'id');
        $training   = HrTraining::get();
        $hard_skill = HrHardSkill::get();
        $soft_skill = HrSoftSkill::get();
        return view('hr.development-plan.edit', compact('dev','emp', 'training', 'hard_skill','soft_skill'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\DevelopmentPlanModel  $developmentPlanModel
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'emp_id' => 'required',
            'request_to' => 'required'
        ]);

        $dev = DevelopmentPlanModel::find($id);
        $dev->emp_id = $request->emp_id;
        $dev->request_to = $request->request_to;
        $dev->description_department = $request->de_description;
        $dev->suggestion_training = $request->training;
        $dev->suggestion_hard_skill = $request->hard_skill;
        $dev->suggestion_soft_skill = $request->soft_skill;
        $dev->description = $request->description;

        $dev->update();

        return redirect()->route('hr-development-plan.index')->with('success', 'Updated Successful!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\DevelopmentPlanModel  $developmentPlanModel
     * @return \Illuminate\Http\Response
     */
    public function destroy(DevelopmentPlanModel $developmentPlanModel)
    {
        //
    }
}
