<?php

namespace App\Http\Controllers\HR;

use App\Fun\Fun;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Hr\HrDepartmentModel;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\Gate;

class HrDepartmentController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:Department List', ['only' => ['index','get_data_department']]);
        $this->middleware('permission:Department Create', ['only' => ['create','store']]);
        $this->middleware('permission:Department Edit', ['only' => ['edit','update']]);
        $this->middleware('permission:Department Delete', ['only' => ['delete_department']]);
    }
    public function index()
    {
        return view('hr.department.index');
    }

    // get department
    public function get_data_department()
    {
        $data = HrDepartmentModel::take(20);

        return DataTables::of($data)
            ->addIndexColumn()
            ->addColumn('action', function ($data) {
                $check_language = Fun::lang();
                if ($check_language == 'km') {
                    $edit   = "កែសម្រួល";
                    $delete = "លុបចោល";
                } else {
                    $edit   = "Edit";
                    $delete = "Delete";
                }
                $_edit      = "";
                $_delete    = "";

                if(Gate::check('Department Edit')){
                    $_edit .= '<a href="'.route('hr-department.edit',encrypt($data->id)).'" class="btn btn-sm btn-warning"><span class="fa fa-edit"></span> Edit</a>&nbsp;';
                }
                if(Gate::check('Department Delete')) {
                    $_delete .= '<a class="btn btn-sm btn-danger btn_delete_department" data-id="' . $data->id . '" data-target=""><span class="fa fa-times"></span> Delete</a>';
                }
                return $_edit.$_delete;
            })
            ->rawColumns(['action' => 'action'])
            ->make(true);
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('hr.department.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'code'          =>'required',
            'english_name'  =>'required',
            'khmer_name'    =>'required',
        ]);

        $department                 = new HrDepartmentModel();
        $department->code           = $request->code;
        $department->khmer_name     = $request->khmer_name;
        $department->english_name   = $request->english_name;
        $department->note           = $request->note;
        $department->save();

        return redirect()->route('hr-department.index')->with('success', 'Added Successful!');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $department = HrDepartmentModel::find(decrypt($id));
        return view('hr.department.edit', compact('department'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'code'          =>'required',
            'english_name'  =>'required',
            'khmer_name'    =>'required',
        ]);

        $department                 = HrDepartmentModel::find($id);
        $department->code           = $request->code;
        $department->khmer_name     = $request->khmer_name;
        $department->english_name   = $request->english_name;
        $department->note           = $request->note;
        $department->update();

        return redirect()->route('hr-department.index')->with('success', 'Added Successful!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    //delete department
    public function delete_department(Request $request)
    {
        HrDepartmentModel::where('id', $request->delete_id)->delete();
        return redirect()->route('hr-department.index')->with('success', 'Deleted Successful!..');
    }
}
