<?php

namespace App\Http\Controllers\HR;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Hr\EmpLeave;
use App\Models\Hr\HrBranch;
use App\Models\Hr\HrExchangeRateModel;
use App\User;

class HrDashboardController extends Controller
{
    public function index()
    {
        $total_employee     = User::where('is_role', 'Administrator')->where('status', 1)->count();
        $total_take_leave   = EmpLeave::where('review', 1)->count();
        $total_branch       = HrBranch::where('delete_status', 0)->count();
        $exchange_rate      = HrExchangeRateModel::where('status', 1)->orderBy('id', 'DESC')->limit(1)->first();
        return view('hr.dashboard', compact('total_employee', 'total_take_leave', 'total_branch', 'exchange_rate'));
    }
    public function create()
    {
        //
    }
    public function store(Request $request)
    {
        //
    }
    public function show($id)
    {
        //
    }
    public function edit($id)
    {
        //
    }
    public function update(Request $request, $id)
    {
        //
    }
    public function destroy($id)
    {
        //
    }
}
