<?php

namespace App\Http\Controllers\HR;

use App\Fun\Fun;
use App\Models\Hr\HrCandidateModel;
use App\Models\Hr\HrJobPostModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\Gate;
class HrCandidateController extends Controller
{

    function __construct()
    {
        $this->middleware('permission:Candidate Create', ['only' => ['create', 'store']]);
        $this->middleware('permission:Candidate List', ['only' => ['index','get_candidate']]);
        $this->middleware('permission:Candidate Edit', ['only' => ['update','edit']]);
        $this->middleware('permission:Candidate Delete', ['only' => ['delete_candidate']]);
        $this->middleware('permission:Candidate Show', ['only' => ['view_candidate']]);
    }
    public function index()
    {
        return view('hr.candidate.index');
    }
    public function get_candidate(){
        $user = HrCandidateModel::where('status',1)->get();
        return DataTables::of($user->take(20))
            ->addIndexColumn()
            ->editColumn('date_of_birth', function ($data) {
                return $data->date_of_birth ? date('d-m-Y', strtotime($data->date_of_birth)) : '';
            })
            ->editColumn('firstname', function ($data) {
                return $data->firstname.' '.$data->lastname;
            })
            ->editColumn('job_post_id', function ($data) {
                return optional($data->get_position)->job_title;
            })
            ->editColumn('gender', function ($data) {
                $check_language = Fun::lang();
                if ($check_language == 'km') {
                    $male   = "ប្រុស";
                    $female = "ស្រី";
                } else {
                    $male   = "Male";
                    $female = "Female";
                }
                return $data->gender == 'male' ? $male : $female;
            })
            ->addColumn('action', function ($data) {
                $check_language = Fun::lang();

                if ($check_language == 'km') {
                    $edit   = "កែសម្រួល";
                    $action = "សកម្មភាព";
                    $delete = "លុប";
                    $task   = "ភារកិច្ច";
                    $view   = "បង្ហាញ";

                } else {
                    $task   = "Task";
                    $delete = "Delete";
                    $edit   = "Edit";
                    $action = 'Action';
                    $view   = 'View';
                }
                $btn= '';
                if(Gate::check('Candidate Show')){
                    $btn .='<a class="btn btn-sm btn-info view-candidate" role="button" data-id="' . $data->id . '" data-toggle="modal tooltip" data-target="#viewModal" data-placement="top" title="' . $view . '"><i class="fa fa-eye"></i> ' . $view . '</a>&nbsp;';
                }
                if(Gate::check('Candidate Edit')) {
                    $btn .= '<a class="btn btn-sm btn-warning" href="' . route('hr-candidate.edit', encrypt($data->id)) . '" ><i class="fa fa-edit"></i> ' . $edit . '</a>&nbsp;';
                }
                if(Gate::check('Candidate Delete')) {
                    $btn .= '<a class="btn btn-sm btn-danger delete-candidate" role="button" data-id="' . $data->id . '" data-name="' . $data->firstname . ' ' . $data->lastname . '" data-toggle="modal tooltip" data-target="#myModal" data-placement="top" title="' . $delete . '"><i class="fa fa-trash"></i> ' . $delete . '</a>&nbsp;';
                }
                return $btn;
            })

            ->rawColumns(['action' => 'action', 'status' => 'status'])
            ->make(true);
    }
    public function create()
    {
        $job = HrJobPostModel::pluck('job_title','id');

        return view('hr.candidate.create',compact('job'));
    }

    public function store(Request $request)
    {

        $this->validate($request, [
            'job_post_id'       => 'required',
            'firstname'         => 'required',
            'lastname'          => 'required',
            'gender'            => 'required',
            'date_of_birth'     => 'required',
            'contact'           => 'required',
            'expected_salary'   => 'required',
            'address'           => 'required',
            'prefered_industry' => 'required',
            'contact'           => 'required',
            'photo'             => 'image|mimes:jpeg,png,jpg',
            'email'             => 'required|unique:nso007_hr_candidate,email',
        ]);

        //candidate photo
        $oldImage = $request->hidden_image_name;
        if ($request->file('photo') == null) {
            $file_name = $oldImage;
        } else {
            $newfile = $request->file('photo');
            $file_name = $newfile->getClientOriginalName();
            if (file_exists(public_path() . '/images/upload/' . $oldImage)) {
                if ($oldImage != '') {
            //unlink(public_path() . '/images/upload/' . $oldImage);
                }
            }
            if(strlen($file_name)>90){
                $ext = $newfile->getClientOriginalExtension();
                $file_name = $request->lastname.date('his') . '.'.$ext;
            }else{
                $file_name = $request->lastname.date('his') . $file_name;
            }
            $destinationPath = 'images/upload';
            //$get_img = Image::make($newfile->getRealPath())->resize(256, 256);
            $newfile->move($destinationPath, $file_name);
        }
        // cadidate cv
        if ($request->file('cv')) {
            $newfile = $request->file('cv');
            $file_name1 = $newfile->getClientOriginalName();
            if(strlen($file_name1)>90){
                $ext = $newfile->getClientOriginalExtension();
                $file_name1 = $request->lastname.date('his') . '.'.$ext;
            }else{
                $file_name1 = $request->lastname.date('his') . $file_name1;
            }
            $destinationPath = 'images/attachment_file';
            $newfile->move($destinationPath, $file_name1);
        }

        $emp = new HrCandidateModel();
        $emp->job_post_id = $request->job_post_id;
        $emp->firstname = $request->firstname;
        $emp->lastname = $request->lastname;
        $emp->photo = $file_name;
        $emp->gender = $request->gender;
        $emp->date_of_birth = date('d-m-Y', strtotime($request->date_of_birth));
        $emp->phone = $request->contact;
        $emp->email = $request->email;
        $emp->address = $request->address;
        $emp->expected_salary = $request->expected_salary;
        $emp->currency = $request->currency;
        $emp->note = $request->note;
        $emp->prefered_industry = $request->prefered_industry;
        $emp->total_year_exp = $request->total_year_exp;
        $emp->cv = $file_name1;

        $emp->save();
        return redirect()->route('hr-candidate.index')->with('success', 'New candidate was inserted successful...');
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $can = HrCandidateModel::find(decrypt($id));
        $job = HrJobPostModel::pluck('job_title','id');
        return view('hr.candidate.edit',compact('can','job'));
    }


    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'job_post_id'       => 'required',
            'firstname'         => 'required',
            'lastname'          => 'required',
            'gender'            => 'required',
            'date_of_birth'     => 'required',
            'phone'             => 'required',
            'expected_salary'   => 'required',
            'address'           => 'required',
            'prefered_industry' => 'required',
            'photo'             => 'image|mimes:jpeg,png,jpg',
            'email'             => 'required|unique:nso007_hr_candidate,email,'.$id,
        ]);

        //candidate photo
        $oldImage = $request->hidden_image_name;
        if ($request->file('photo') == null) {
            $file_name = $oldImage;
        } else {
            $newfile = $request->file('photo');
            $file_name = $newfile->getClientOriginalName();
            if (file_exists(public_path() . '/images/upload/' . $oldImage)) {
                if ($oldImage != '') {
                    unlink(public_path() . '/images/upload/' . $oldImage);
                }
            }
            if(strlen($file_name)>90){
                $ext = $newfile->getClientOriginalExtension();
                $file_name = $request->lastname.date('his') . '.'.$ext;
            }else{
                $file_name = $request->lastname.date('his') . $file_name;
            }
            $destinationPath = 'images/upload';
            $newfile->move($destinationPath, $file_name);
        }
        // cadidate cv
        $oldfile = $request->old_file;
        if ($request->file('cv')==null) {
            $file_name1 = $oldfile;
        }else{
            $newfile1 = $request->file('cv');
            $file_name1 = $newfile1->getClientOriginalName();
            if (file_exists(public_path() . '/images/attachment_file/' . $oldfile)) {
                if ($oldImage != '') {
                    unlink(public_path() . '/images/attachment_file/' . $oldfile);
                }
            }
            if(strlen($file_name1)>90){
                $ext = $newfile1->getClientOriginalExtension();
                $file_name1 = $request->lastname.date('his') . '.'.$ext;
            }else{
                $file_name1 = $request->lastname.date('his') . $file_name1;
            }
            $destinationPath = 'images/attachment_file';
            $newfile1->move($destinationPath, $file_name1);
        }

        $emp = HrCandidateModel::find($id);
        $emp->job_post_id = $request->job_post_id;
        $emp->firstname = $request->firstname;
        $emp->lastname = $request->lastname;
        $emp->photo = $file_name;
        $emp->gender = $request->gender;
        $emp->date_of_birth = date('Y-m-d', strtotime($request->date_of_birth));
        $emp->phone = $request->phone;
        $emp->email = $request->email;
        $emp->address = $request->address;
        $emp->expected_salary = $request->expected_salary;
        $emp->currency = $request->currency;
        $emp->note = $request->note;
        $emp->prefered_industry = $request->prefered_industry;
        $emp->total_year_exp = $request->total_year_exp;
        $emp->cv = $file_name1;

        $emp->update();
        return redirect()->route('hr-candidate.index')->with('success', 'New candidate was update successful...');
    }

    public function destroy($id)
    {
        //
    }

    public function view_candidate(){
        $candidate = HrCandidateModel::find($_GET['id']);
        $label_benefit = '';

        $check_language = Fun::lang();
        if ($check_language == 'km') {
            $male = "ប្រុស";
            $female = "ស្រី";
            $year = 'ឆ្នាំ';
            $riel = "រៀល";
            $usd = "ដុល្លា";
            $per = "នាក់";
        } else {
            $male = "Male";
            $female = "Female";
            $year = "Year(s)";
            $riel = "Riel";
            $usd = "USD";
            $per = "";
        }
        $gender = '';
        if(strtolower($candidate->gender) == 'male'){
            $gender = $male;
        }
        if(strtolower($candidate->gender) == 'female'){
            $gender = $female;
        }
        if($candidate->currency == 'usd'){
            $currency = $usd;
        }else{
            $currency = $riel;
        }
        $data = [
            'job_post_id'=>optional($candidate->get_position)->job_title,
            'name'=>$candidate->firstname.' '.$candidate->lastname,
            'photo'=>$candidate->photo,
            'photo'=>$candidate->photo,
            'gender'=>$gender,
            'phone'=>$candidate->phone,
            'email'=>$candidate->email,
            'cv'=>$candidate->cv,
            'address'=>$candidate->address,
            'date_of_birth'=>date('d-m-Y',strtotime($candidate->date_of_birth)),
            'expected_salary'=>$candidate->expected_salary.$currency,
            'prefered_industry'=>$candidate->prefered_industry,
            'total_year_exp'=>$candidate->total_year_exp,
            'note'=>$candidate->note,
        ];
        return response()->json(['datas' => $data]);
    }
    public function delete_candidate(Request $request){
        $can = HrCandidateModel::find($request->id);
        $can->status = 0;
        $can->update();
        return redirect()->route('hr-candidate.index')->with('danger', 'candidate was deleted successful...');
    }
}
