<?php

namespace App\Http\Controllers\HR;

use App\Models\Hr\ExternalLecturerModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\User;
use Illuminate\Support\Facades\Gate;
use Yajra\DataTables\DataTables;

class ExternalLecturerController extends Controller
{

    function __construct()
    {
        $this->middleware('permission:External Lecture Create', ['only' => ['create', 'store']]);
        $this->middleware('permission:External Lecture List', ['only' => ['index']]);
        $this->middleware('permission:External Lecture Edit', ['only' => ['update','edit']]);
    }

    public function index(Request $request)
    {
        $external_lecturer = ExternalLecturerModel::get();
        if($request->ajax()){
            return DataTables::of($external_lecturer->take(20))
            ->addIndexColumn()
            ->addColumn('action', function($data){

                $btn_edit = '';
                if(Gate::check('External Lecture Edit')){
                    $btn_edit = '<a href="'.route('hr-external-lecturer.edit', encrypt($data->id)).'" class="btn btn-sm btn-warning"><i class="fa fa-edit"></i> Edit</a>';
                }

                return $btn_edit;
            })
            ->rawColumns(['action'])
            ->make(true);
        }

        return view('hr.external-lecturer.index', compact('external_lecturer'));
    }


    public function create()
    {
        return view('hr.external-lecturer.create');
    }


    public function store(Request $request)
    {
       $this->validate($request, [
           'full_name_kh' => 'required',
           'full_name_en' => 'required',
           'trainer_type' => 'required',
           'phone'        => 'required',
           'email'        => 'required',
           'address'      => 'required',
           'expertise'    => 'required'
       ]);

       $external_lecturer = new ExternalLecturerModel();

       $external_lecturer->full_name_kh = $request->full_name_kh;
       $external_lecturer->full_name_en = $request->full_name_en;
       $external_lecturer->trainer_type = $request->trainer_type;
       $external_lecturer->phone        = $request->phone;
       $external_lecturer->email        = $request->email;
       $external_lecturer->address      = $request->address;
       $external_lecturer->expertise    = $request->expertise;

       $external_lecturer->save();

       return redirect()->route('hr-external-lecturer.index')->with('success', 'Added Successful!');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\ExternalLecturerModel  $externalLecturerModel
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\ExternalLecturerModel  $externalLecturerModel
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $id = decrypt($id);
        $ex_lecturer = ExternalLecturerModel::find($id);
        return view('hr.external-lecturer.edit', compact('ex_lecturer'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\ExternalLecturerModel  $externalLecturerModel
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'full_name_kh' => 'required',
            'full_name_en' => 'required',
            'trainer_type' => 'required',
            'phone'        => 'required',
            'email'        => 'required',
            'address'      => 'required',
            'expertise'    => 'required'
        ]);

        $external_lecturer = ExternalLecturerModel::find($id);

        $external_lecturer->full_name_kh = $request->full_name_kh;
        $external_lecturer->full_name_en = $request->full_name_en;
        $external_lecturer->trainer_type = $request->trainer_type;
        $external_lecturer->phone        = $request->phone;
        $external_lecturer->email        = $request->email;
        $external_lecturer->address      = $request->address;
        $external_lecturer->expertise    = $request->expertise;

        $external_lecturer->update();

        return redirect()->route('hr-external-lecturer.index')->with('success', 'Updated Successful!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\ExternalLecturerModel  $externalLecturerModel
     * @return \Illuminate\Http\Response
     */
    public function destroy(ExternalLecturerModel $externalLecturerModel)
    {
        //
    }
}
