<?php

namespace App\Http\Controllers\HR;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Hr\AdvanceSalaryModel;
use Illuminate\Support\Facades\Gate;
use Yajra\DataTables\DataTables;
use App\User;

class AdvanceSalaryController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:Salary Advance Create', ['only' => ['create', 'store']]);
        $this->middleware('permission:Salary Advance List', ['only' => ['index']]);
        $this->middleware('permission:Salary Advance Edit', ['only' => ['update']]);
        $this->middleware('permission:Salary Advance Delete', ['only' => ['delete_advance_salary']]);
    }
    public function index(Request $request)
    {
        if($request->ajax())
        {
            $data = AdvanceSalaryModel::take(20);
            return DataTables::of($data)
            ->addIndexColumn()
            ->addColumn('employee', function($data){
                return optional($data->get_employee)->english_name;
            })
            ->editColumn('effect_date', function($data){
                return $data->effect_date ? date('d-m-Y', strtotime($data->effect_date)) : '';
            })
            ->editColumn('review', function($data){
                $review  = $data->review ? $data->review: "";
                if($review == 0)
                {
                    $status = '<small class="label label-primary">pending</small>';

                }elseif($review == 1){
                    $status = '<small class="label label-success">approved</small>';

                }elseif($review == 2){
                    $status = '<small class="label label-danger">rejected</small>';
                }

                return $status;

            })
            ->editColumn('approve', function($data){
                $approve  = $data->approve ? $data->approve: "";
                if($approve == 0)
                {
                    $status = '<small class="label label-primary">pending</small>';

                }elseif($approve == 1){
                    $status = '<small class="label label-success">approved</small>';

                }elseif($approve == 2){
                    $status = '<small class="label label-danger">rejected</small>';
                }

                return $status;

            })
            ->addColumn('action', function($data){
                $btn_edit= '';
                $btn_Delete= '';
                if(Gate::check('Salary Advance Edit')) {
                    $btn_edit = '<a href="' . route('hr-advance-salary.edit', encrypt($data->id)) . '" class="btn btn-sm btn-warning"><span class="fa fa-edit"></span> Edit</a>&nbsp;';
                }
                if(Gate::check('Salary Advance Delete')) {
                    $btn_Delete = '<a class="btn btn-sm btn-danger btn_delete" data-id="' . $data->id . '"><span class="fa fa-trash"></span> Delete</a>';
                }
                return $btn_edit.$btn_Delete;
            })
            ->rawColumns(['employee','approve', 'review', 'action'])
            ->make(true);
        }
        return view('hr.advance-salary.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $employee = User::where('status', 1)->pluck('english_name', 'id');
        return view('hr.advance-salary.create', compact('employee'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'emp_id'            => 'required',
            'advance_salary'    => 'required',
            'effect_date'       => 'required',
        ]);

        $advance_sal                    = new AdvanceSalaryModel();
        $advance_sal->emp_id            = $request->emp_id;
        $advance_sal->advance_salary    = $request->advance_salary;
        $advance_sal->effect_date       = date('Y-m-d', strtotime($request->effect_date));
        $advance_sal->note              = $request->note;
        $advance_sal->save();

        return redirect()->route('hr-advance-salary.index')->with('success', 'Advance Salary has been added!');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $id         = decrypt($id);
        $advace_sal = AdvanceSalaryModel::findOrFail($id);
        $employee   = User::where('status', 1)->pluck('english_name', 'id');
        return view('hr.advance-salary.edit', compact('advace_sal', 'employee'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'emp_id'            => 'required',
            'advance_salary'    => 'required',
            'effect_date'       => 'required',
        ]);

        $advance_sal                    = AdvanceSalaryModel::findOrFail($id);
        $advance_sal->emp_id            = $request->emp_id;
        $advance_sal->advance_salary    = $request->advance_salary;
        $advance_sal->effect_date       = date('Y-m-d', strtotime($request->effect_date));
        $advance_sal->note              = $request->note;
        $advance_sal->update();

        return redirect()->route('hr-advance-salary.index')->with('success', 'Advance Salary has been updated!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    public function delete_advance_salary(Request $request)
    {
        $id = $request->delete_id;
        AdvanceSalaryModel::where('id', $id)->delete();
        return redirect()->route('hr-advance-salary.index')->with('success', 'Time Policy was deleted Succesful!');
    }
}
