<?php

namespace App\Http\Controllers;

use App\CategoryModel;
use Illuminate\Http\Request;
use App\SaleModel;
use DB;
use Crypt;
use DataTables;
use App\DepositModel;
use Auth;
use App\SaleDetailModel;
use App\ItemModel;
// use App\Helpers\Globals;
use App\AccountChartModel;
use App\JournalModel;
use App\ClientModel;
use App\AgencyModel;
use App\ClientRelationshipModel;
use App\ProvinceModel;
use App\User;
use Gate;
use App\ProjectModel;
use App\LoanClientRelationshipModel;

class DepositController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
         $this->middleware('permission:Deposit-List', ['only' => ['index','get_deposit']]);
         $this->middleware('permission:Deposit-Add-More', ['only' => ['add_more_deposit']]);
         $this->middleware('permission:Deposit-Edit-POS', ['only' => ['edit','update_pos']]);
         $this->middleware('permission:Deposit-Cancel', ['only' => ['cancel_deposit']]);
         $this->middleware('permission:Deposit-Delete', ['only' => ['delete_deposit']]);
         $this->middleware('permission:Deposit-Edit', ['only' => ['edit_deposit','save_edit_deposit']]);
         $this->middleware('permission:Deposit-Print-Invoice', ['only' => ['print_invoice']]);
    }
    public function index()
    {
        $banklist = AccountChartModel::select(DB::raw("CONCAT(code, ' | ',acc_name) as account_name"), "code")
        ->where('code', 11001)
        ->Orwhere('code', 11002)
        ->orderBy('code')
        ->pluck("account_name", "code");
        $commission_condition = DB::table('nso007_commission_condition_setting')->where("status",1)->pluck("title","id")->prepend("Please select","");
        $client_relationships = DB::table("nso007_client_relationship")->select("name","id")->get();
        $client_relationships_append = DB::table("nso007_client_relationship")->select("name","id")->pluck("name","id");
        $projects = ProjectModel::pluck("name","id")->prepend("Please Select","");
        $categories = CategoryModel::pluck("name","id")->prepend("Please Select","");
        $client = ClientModel::pluck("name","id")->prepend("Please Select","");
        $items = ItemModel::where("sale_stock",2)->pluck("name","id")->prepend("Please Select","");
        return view("deposit.index",compact('banklist','projects','client','categories','items','commission_condition','client_relationships_append','client_relationships'));
    }
    public function get_deposit(Request $request)
    {
        if($request->isMethod("POST")){
            $sale_id=$request->sale_id;
            $data_sale=SaleModel::where("id",$sale_id)->first();
            return json_encode(date("d-m-Y",strtotime($data_sale->date_on_contract)));
        }else{
            $search = $request->input('search.value');
            $input=$request->all();
            $count_total =SaleModel::join("nso007_sale_detail_stock","nso007_sale_stock.id","nso007_sale_detail_stock.sale_id")
                        ->join("nso007_item_stock","nso007_sale_detail_stock.item_id","nso007_item_stock.id")
                        ->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                        ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                        ->join("nso007_client","nso007_sale_stock.client_id","nso007_client.id")
                        ->leftJoin("nso007_agency","nso007_sale_stock.agency_id","nso007_agency.id")
                        ->where("nso007_item_stock.stock_status",2)
                        ->where("nso007_item_stock.sale_stock","!=",0)
                        ->where("nso007_sale_stock.status",1)
                        ->where("nso007_item_stock.status",1)
                        ->where("nso007_category_stock.status",1)
                        ->where("nso007_project_stock.status",1)
                        ->where("nso007_client.status",1)
                        ->where(function($query) use ($input){
                            if(!empty($input['item_id']))
                                $query->whereIn('nso007_item_stock.id' ,$input["item_id"]);
                            if(!empty($input['project_id']))
                                $query->whereIn('nso007_project_stock.id' ,$input['project_id']);
                            if(!empty($input['category_id']))
                                $query->whereIn('nso007_category_stock.id' ,$input['category_id']);
                            if(!empty($input['client_id']))
                                $query->where('nso007_client.id' ,$input["client_id"]);

                        })
                        // ->groupBy("nso007_sale_stock.id")
                        ->count();
            $count_filter =SaleModel::join("nso007_sale_detail_stock","nso007_sale_stock.id","nso007_sale_detail_stock.sale_id")
                        ->join("nso007_item_stock","nso007_sale_detail_stock.item_id","nso007_item_stock.id")
                        ->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                        ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                        ->join("nso007_client","nso007_sale_stock.client_id","nso007_client.id")
                        ->leftJoin("nso007_agency","nso007_sale_stock.agency_id","nso007_agency.id")
                        ->where(function($query) use ($search){
                            $query->orWhere('nso007_sale_stock.date' , 'LIKE' , '%'.$search.'%');
                            $query->orWhere('nso007_sale_stock.date_on_contract' , 'LIKE' , '%'.$search.'%');
                            $query->orWhere('nso007_item_stock.name' , 'LIKE' , '%'.$search.'%');
                            $query->orWhere('nso007_client.name' , 'LIKE' , '%'.$search.'%');
                            $query->orWhere('nso007_client.phone' , 'LIKE' , '%'.$search.'%');
                            $query->orWhere('nso007_agency.name' , 'LIKE' , '%'.$search.'%');
                            $query->orWhere('nso007_project_stock.name' , 'LIKE' , '%'.$search.'%');
                            $query->orWhere('nso007_category_stock.name' , 'LIKE' , '%'.$search.'%');
                        })
                        ->where("nso007_item_stock.stock_status",2)
                        ->where("nso007_item_stock.sale_stock","!=",0)
                        ->where("nso007_sale_stock.status",1)
                        ->where("nso007_item_stock.status",1)
                        ->where("nso007_category_stock.status",1)
                        ->where("nso007_project_stock.status",1)
                        ->where("nso007_client.status",1)
                        ->where(function($query) use ($input){
                            if(!empty($input['item_id']))
                                $query->whereIn('nso007_item_stock.id' ,$input["item_id"]);
                            if(!empty($input['project_id']))
                                $query->whereIn('nso007_project_stock.id' ,$input['project_id']);
                            if(!empty($input['category_id']))
                                $query->whereIn('nso007_category_stock.id' ,$input['category_id']);
                            if(!empty($input['client_id']))
                                $query->where('nso007_client.id' ,$input["client_id"]);

                        })
                        // ->groupBy("nso007_sale_stock.id")
                        ->count();

            $sale_data = SaleModel::join("nso007_sale_detail_stock","nso007_sale_stock.id","nso007_sale_detail_stock.sale_id")
                        ->join("nso007_item_stock","nso007_sale_detail_stock.item_id","nso007_item_stock.id")
                        ->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                        ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                        ->join("nso007_client","nso007_sale_stock.client_id","nso007_client.id")
                        ->leftJoin("nso007_agency","nso007_sale_stock.agency_id","nso007_agency.id")
                        ->select(DB::raw("GROUP_CONCAT(nso007_item_stock.name) as item_name"),"nso007_project_stock.name as project_name","nso007_category_stock.name as category_name","nso007_client.name as client_name","nso007_client.phone as client_phone","nso007_agency.name as agency_name","nso007_sale_stock.*",DB::raw('TIMESTAMPDIFF(DAY,nso007_sale_stock.date_on_contract,"' .date("Y-m-d"). '") as reach_contract'))
                        ->where("nso007_item_stock.stock_status",2)
                        ->where("nso007_item_stock.sale_stock","!=",0)
                        ->where("nso007_sale_stock.status",1)
                        ->where("nso007_item_stock.status",1)
                        ->where("nso007_category_stock.status",1)
                        ->where("nso007_project_stock.status",1)
                        ->where("nso007_client.status",1)
                        ->where(function($query) use ($input){
                            if(!empty($input['item_id']))
                                $query->whereIn('nso007_item_stock.id' ,$input["item_id"]);
                            if(!empty($input['project_id']))
                                $query->whereIn('nso007_project_stock.id' ,$input['project_id']);
                            if(!empty($input['category_id']))
                                $query->whereIn('nso007_category_stock.id' ,$input['category_id']);
                            if(!empty($input['client_id']))
                                $query->where('nso007_client.id' ,$input["client_id"]);

                        })
                        ->groupBy("nso007_sale_stock.id")
                        ->take(20);
            return Datatables::of($sale_data)
                ->addIndexColumn()
                ->setRowId("id")
                ->with([
                    "recordsTotal" => $count_total,
                     "recordsFiltered" => $count_filter,
                  ])
                ->editColumn("date",function($sale_data){
                    if(empty($sale_data->date)) return "";
                    return date("d-m-Y",strtotime($sale_data->date));
                })
                ->editColumn("date_on_contract",function($sale_data){
                    if($sale_data->reach_contract>=-1&&$sale_data->type==1){
                        return "<span id='contract-date".$sale_data->id."' style='color:red;'>".date("d-m-Y",strtotime($sale_data->date_on_contract))."</span>";
                    }
                    else{
                        return "<span id='contract-date".$sale_data->id."'>".date("d-m-Y",strtotime($sale_data->date_on_contract))."</span>";
                    }
                })
                ->editColumn("sale_amount",function($sale_data){
                    return number_format($sale_data->sale_amount,2)."$";
                })
                ->editColumn("sale_receive_amount",function($sale_data){
                    return "<span id='receive-amount".$sale_data->id."'>".number_format($sale_data->sale_receive_amount,2)."$</span>";
                })
                ->editColumn("discount_amount",function($sale_data){
                    return number_format($sale_data->discount_amount,2)."$";
                })
                ->editColumn("sale_price",function($sale_data){
                    return number_format($sale_data->sale_amount - $sale_data->discount_amount,2)."$";
                })
                ->editColumn('item_name',function($sale_data)
                {
                    $sale_item = DB::table("nso007_sale_detail_stock")->where("sale_id",$sale_data->id)->where("status",1)->select("item_id")->get();
                    $item_names="";
                    foreach ($sale_item as $key => $value) {
                        $item_names.=DB::table("nso007_item_stock")->where("id",$value->item_id)->select("name")->first()->name;
                        if(isset($sale_item[$key+1])) $item_names.=",";
                    }
                    return $item_names;
                })
                ->editColumn('payment_policy',function($sale_data){
                    $data_payment_policy = optional(DB::table("nso007_payment_policy")->where("id",$sale_data->policy_payment_id)->first())->name;
                    $data_payment_policy_detail = optional(DB::table("nso007_payment_policy_detail")->where("id",$sale_data->policy_payment_detail_id)->first())->name;
                    if(empty($data_payment_policy)) return "";
                    else if(!empty($data_payment_policy_detail)){
                        return $data_payment_policy."(".$data_payment_policy_detail.")";
                    }
                    else if(empty($data_payment_policy_detail)){
                        return $data_payment_policy;
                    }
                    else return "";

                })
                ->addColumn('action',function($sale_data){
                    $button="";
                    $deposit=DB::table('nso007_deposit_schedule')->where("sale_id",$sale_data->id)->get();
                    if(!empty($deposit)&&count($deposit)>0){
                        if(Gate::check('Deposit-Show-Detail'))
                            $button.=" <span><a href='javascript:void(0)' onclick='view_deposit_detail(".$sale_data->id.",this)' class='btn btn-sm btn-info' title='view deposit detail'><i class='fas fa-eye'></i></a><span>";

                    }
                    if($sale_data->type==1){
                        if(Gate::check('Deposit-Edit-POS'))
                                $button.=' <a title="Edit POS" href="'.route("deposit.edit",$sale_data->id).'" class="btn btn-primary btn-sm"><i class="fas fa-edit"></i></a>';
                        if(Gate::check('Deposit-Installment'))
                            if(DB::table('nso007_deposit_schedule')->where("sale_id",$sale_data->id)->where("pay_type",0)->count()<=0)
                            $button.=' <a title="Installment" href="'.route("installment.create",$sale_data->id).'" class="btn btn-info btn-sm"><i class="fas fa-calendar-week"></i></a>';
                        if(Gate::check('Deposit-Cancel'))
                            $button.= ' <a href="javascript:void(0)" data-toggle="modal" onclick="cancel_deposit('.$sale_data->id.')" class="btn btn-danger btn-sm" title="Cancel deposit"><i class="fas fa-times"></i></a> ';
                        if(Gate::check('Deposit-Delete'))
                            $button.= ' <a href="javascript:void(0)" class="btn btn-danger btn-sm" onclick="delete_deposit('.$sale_data->id.')" title="Delete"><i class="fas fa-trash"></i></a> ';
                    }
                    if(Gate::check('Deposit-Print-Contract-Deposit'))
                    {
                        $button.= ' <a href="'.route('deposit.print_contract',$sale_data->id).'" class="btn btn-primary btn-sm" title="Print Contract Deposit"><i class="fas fa-print"></i></a> ';
                        $button.= ' <a href="javascript:void(0)" sale_id = "'.$sale_data->id.'" promotion-remark = "'.$sale_data->remark_promotion.'" onclick="promotion_remark(this)" class="btn btn-primary btn-sm" title="Add Remark Promotion"><i class="fas fa-pencil-alt"></i></a> ';
                    }
                    if(Gate::check('Deposit-Add-Client-Relationship'))
                        $button.= '<a href="javascript:void(0)" onclick = "show_client_relationship('.$sale_data->id.')" class="btn btn-success btn-sm" title="Add Client Relationship"><i class="fas fa-users"></i></a> ';

                    return $button;
                })
                 ->rawColumns([
                    'action' => 'action',
                    'date_on_contract'=>'date_on_contract',
                    'sale_receive_amount'=>'sale_receive_amount'
                ])
                ->make(true);
        }
    }
    public function print_contract($sale_id){

        $sale_info = SaleModel::where("nso007_sale_stock.id",$sale_id)
                        ->join("nso007_client","nso007_client.id","nso007_sale_stock.client_id")
                        ->select(
                            "nso007_client.id as client_id",
                            "nso007_sale_stock.date",
                            "nso007_sale_stock.sale_amount",
                            "nso007_sale_stock.discount_amount",
                            "nso007_sale_stock.sale_receive_amount",
                            "nso007_sale_stock.policy_payment_id",
                            "nso007_sale_stock.policy_payment_detail_id",
                            "nso007_sale_stock.date_on_contract",
                            "nso007_sale_stock.agency_id",
                            "nso007_sale_stock.remark_promotion"
                        )
                        ->first();
        $item_detials = SaleDetailModel::join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
                       ->join("nso007_sub_category","nso007_sub_category.id","nso007_item_stock.subcategory_id")
                       ->select(
                           "nso007_item_stock.*",
                           "nso007_sub_category.name as item_type",
                        )
                       ->where("nso007_sale_detail_stock.sale_id",$sale_id)
                       ->where("nso007_sale_detail_stock.status",1)
                       ->get();
        $projects = ProjectModel::with(['get_province','get_district','get_commune','get_village'])
                       ->select("nso007_project_stock.*")
                       ->where("nso007_project_stock.status",1)
                       ->where("nso007_project_stock.id",$item_detials[0]->project_id)
                       ->first();
        $location="";$location_house_number = "";$location_street_number = "";
        if(!empty($projects->house_number)) $location_house_number = $projects->house_number;
        if(!empty($projects->street_number)) $location_street_number = $projects->street_number;
        if(!empty($projects->get_village['village_km'])) $location.="  ភូមិ".$projects->get_village['village_km'];
        if(!empty($projects->get_commune['commune_km'])) $location.=" ,ឃុំ/សង្កាត់".$projects->get_commune['commune_km'];
        if(!empty($projects->get_district['district_km'])) $location.=" ,ស្រុក/ខ័ណ្ឌ​".$projects->get_district['district_km'];
        if(!empty($projects->get_province['province_km'])) $location.=" ,ខេត្ត/រាជធានី​".$projects->get_province['province_km'];

        $client_data = ClientModel::find($sale_info->client_id);
        // $client_relatatonship_data = LoanClientRelationshipModel::with('relative')->where("sale_id",$sale_id)->get();
        $client_relatatonship_data = LoanClientRelationshipModel::where("sale_id",$sale_id)->get();

        $deposit_schedule = DB::table("nso007_deposit_schedule")->where("sale_id",$sale_id)->get();

        return view("deposit.print_contract",compact('sale_info','item_detials','projects','location','location_house_number','location_street_number','location_street_number','client_data','client_relatatonship_data','deposit_schedule'));
    }
    public function get_all_deposit(Request $request)
    {
        $sale_id = $request->sale_id;
        $data_deposit = DB::table("nso007_deposit_schedule")->where("sale_id",$sale_id)->get();
        $data_sale = SaleModel::where("id",$sale_id)->first();
        $data = array(
            'data_deposit'=>$data_deposit,
            'data_sale'=>$data_sale
        );
        return json_encode($data);
    }

    public function add_more_deposit(Request $request){

        $this->validate($request,[
            'sale_id'=>'required',
            'deposit_date'=>'required',
            'deposit_date_contract'=>'required',
            'deposit_amount'=>'required',
            "bank_list"=>'required'
        ]);

        $sale = SaleModel::find($request->sale_id);
        $sale_amount = $sale->sale_amount;
        $deposit_amount_old = DepositModel::where("sale_id",$request->sale_id)->where("nso007_deposit.status",1)->select(DB::raw("SUM(deposit_amount) as amount_deposit"))->first();
        $deposit_amount_check=$request->deposit_amount;
        if(!empty($deposit_amount_old)) $deposit_amount_check += $deposit_amount_old->amount_deposit;
        if($deposit_amount_check>=$sale_amount*$sale->condition_convert_to_income/100) return json_encode("Error-Deposit-Amount");

        DB::beginTransaction();
        try{

            $data = array(
                "sale_id"=>$request->sale_id,
                "date"=>date("Y-m-d",strtotime($request->deposit_date)),
                "deposit_amount"=>$request->deposit_amount,
                "date_on_contract"=>date("Y-m-d",strtotime($request->deposit_date_contract)),
                "accountant_name"=>$request->deposit_accountant,
                "description"=>$request->deposit_description,
                "user_id"=>Auth::user()->id,
                "account_code"=>$request->bank_list
            );

            DepositModel::insert($data);

            $deposit_max_id = DepositModel::max("id");

            $deposit_amount=$request->deposit_amount;
            SaleModel::where("id",$request->sale_id)->update(['date_on_contract'=>date("Y-m-d",strtotime($request->deposit_date_contract))]);
            SaleModel::where("id",$request->sale_id)->increment("sale_receive_amount",$deposit_amount);
            SaleModel::where("id",$request->sale_id)->decrement("sale_remain_amount",$deposit_amount);

            $deposit_info=[];
            $data_sale=SaleModel::where("id",$request->sale_id)->first();
            $deposit_data = DepositModel::where("sale_id",$request->sale_id)->where("status",1)->get();
            foreach($deposit_data as $key => $value){
                $deposit_info[$key]=[
                    "id"=>$value->id,
                    "date"=>date("d-m-Y",strtotime($value->date))
                ];
            }
            $sale = array(
                "date_contract"=>date("d-m-Y",strtotime($data_sale->date_on_contract)),
                "sale_receive_amount"=>number_format($data_sale->sale_receive_amount,2),
                "deposit_data"=>$deposit_info
            );
            $max_deposit_id = DB::select("SELECT count(id) as num_id FROM nso007_deposit
                                            WHERE nso007_deposit.sale_id = $request->sale_id
                                          ");

            $report_booking     = DB::table('nso007_sale_stock')
                ->join('nso007_sale_detail_stock', 'nso007_sale_detail_stock.sale_id', 'nso007_sale_stock.id')
                ->join('nso007_item_stock', 'nso007_item_stock.id', 'nso007_sale_detail_stock.item_id')
                ->select(
                    'nso007_item_stock.project_id'
                )
                ->where('nso007_sale_stock.id', $request->sale_id)->get();

            $item_stock          = $report_booking[0]->project_id;
            if(!empty($request->deposit_amount))
            {
                $j=JournalModel::select(DB::raw("Max(journal_tran_id) as last_num"))->first();

                $journal=new JournalModel;
                $journal->branch_id=0;
                $journal->journal_parentid=0;
                $journal->journal_type=1;
                $journal->journal_acccode=$request->bank_list;
                $journal->voucher_type=1;
                $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
                $journal->journal_des=\Globals::DescriptionBySaleID("", $request->sale_id).' Deposit '.$max_deposit_id[0]->num_id;
                $journal->journal_debit=$request->deposit_amount;
                $journal->journal_credit=0;
                $journal->journal_tran_id=$j->last_num+1;
                $journal->journal_transactiondate=date("Y-m-d H:i:s");
                $journal->journal_paydate=date("Y-m-d",strtotime($request->deposit_date));
                $journal->journal_currency=1;
                $journal->transaction_type='Deposit';
                $journal->journal_referenceid=$deposit_max_id;
                $journal->journal_by_project=$item_stock;
                $journal->journal_by=auth()->user()->id;
                $journal->save();

                $jj=JournalModel::select(DB::raw("Max(id) as last_id"))->first();

                $journal=new JournalModel;
                $journal->branch_id=0;
                $journal->journal_parentid=$jj->last_id;
                $journal->journal_type=2;
                $journal->journal_acccode=21003;
                $journal->voucher_type=1;
                $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
                $journal->journal_des=\Globals::DescriptionBySaleID("", $request->sale_id).' Deposit '.$max_deposit_id[0]->num_id;
                $journal->journal_debit=0;
                $journal->journal_credit=$request->deposit_amount;
                $journal->journal_tran_id=$j->last_num+1;
                $journal->journal_transactiondate=date("Y-m-d H:i:s");
                $journal->journal_paydate=date("Y-m-d",strtotime($request->deposit_date));
                $journal->journal_currency=1;
                $journal->transaction_type='Deposit';
                $journal->journal_referenceid=$deposit_max_id;
                $journal->journal_by_project=$item_stock;
                $journal->journal_by=auth()->user()->id;
                $journal->save();
            }

            \Globals::calculate_commission($request->sale_id);

            DB::commit();
            return json_encode($sale);
        }catch(\Exception $e){
            DB::rollback();
            return json_encode("Error");
        }
    }

    public function cancel_deposit(Request $request){

        $this->validate($request,[
            "sale_id"=>"required|numeric"
        ]);

        $sale_id = $request->sale_id;
        $amount_cancel = $request->amount_cancel;

        $sale_amount=SaleModel::where("id",$sale_id)->first();


        //update item
        $items = SaleDetailModel::where("sale_id",$sale_id)->where("status",1)->get();
        foreach($items as $value){
            ItemModel::where("id",$value->item_id)->update(['stock_status'=>1,'sale_stock'=>0]);

        }

        $item_proid=ItemModel::where("id",$value->item_id)->first();

        if(!empty($amount_cancel))
        {
            $j=JournalModel::select(DB::raw("Max(journal_tran_id) as last_num"))->first();

            $journal=new JournalModel;
            $journal->branch_id=0;
            $journal->journal_parentid=0;
            $journal->journal_type=1;
            $journal->journal_acccode=11001;
            $journal->voucher_type=2;
            $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
            $journal->journal_des=\Globals::DescriptionBySaleID("", $sale_id).' Cancel Deposit';
            $journal->journal_debit=0;
            $journal->journal_credit=$amount_cancel;
            $journal->journal_tran_id=$j->last_num+1;
            $journal->journal_transactiondate=date("Y-m-d H:i:s");
            $journal->journal_paydate=date("Y-m-d");
            $journal->journal_currency=1;
            $journal->transaction_type='Cancel Deposit';
            $journal->journal_referenceid=$sale_id;
            $journal->journal_by_project=$item_proid->project_id;
            $journal->journal_by=auth()->user()->id;
            $journal->save();

            $jj=JournalModel::select(DB::raw("Max(id) as last_id"))->first();

            $journal=new JournalModel;
            $journal->branch_id=0;
            $journal->journal_parentid=$jj->last_id;
            $journal->journal_type=2;
            $journal->journal_acccode=21003;
            $journal->voucher_type=2;
            $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
            $journal->journal_des=\Globals::DescriptionBySaleID("", $sale_id).' Cancel Deposit';
            $journal->journal_debit=$sale_amount->sale_receive_amount;
            $journal->journal_credit=0;
            $journal->journal_tran_id=$j->last_num+1;
            $journal->journal_transactiondate=date("Y-m-d");
            $journal->journal_paydate=date("Y-m-d");
            $journal->journal_currency=1;
            $journal->transaction_type='Cancel Deposit';
            $journal->journal_referenceid=$sale_id;
            $journal->journal_by_project=$item_proid->project_id;
            $journal->journal_by=auth()->user()->id;
            $journal->save();

            $sale_incom=$sale_amount->sale_receive_amount-$amount_cancel;
            if($sale_incom>0){
                $jjj=JournalModel::select(DB::raw("Max(id) as last_id"))->first();

                $journal=new JournalModel;
                $journal->branch_id=0;
                $journal->journal_parentid=$jjj->last_id;
                $journal->journal_type=4;
                $journal->journal_acccode=41000;
                $journal->voucher_type=1;
                $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
                $journal->journal_des=\Globals::DescriptionBySaleID("", $sale_id).' Cancel Deposit';
                $journal->journal_debit=0;
                $journal->journal_credit=$sale_incom;
                $journal->journal_tran_id=$j->last_num+1;
                $journal->journal_transactiondate=date("Y-m-d");
                $journal->journal_paydate=date("Y-m-d");
                $journal->journal_currency=1;
                $journal->transaction_type='Cancel Deposit';
                $journal->journal_referenceid=$sale_id;
                $journal->journal_by_project=$item_proid->project_id;
                $journal->journal_by=auth()->user()->id;
                $journal->save();
            }

        }else{
            $j=JournalModel::select(DB::raw("Max(journal_tran_id) as last_num"))->first();

            $journal=new JournalModel;
            $journal->branch_id=0;
            $journal->journal_parentid=0;
            $journal->journal_type=4;
            $journal->journal_acccode=41000;
            $journal->voucher_type=1;
            $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
            $journal->journal_des=\Globals::DescriptionBySaleID("", $sale_id).' Cancel Deposit';
            $journal->journal_debit=0;
            $journal->journal_credit=$sale_amount->sale_receive_amount;
            $journal->journal_tran_id=$j->last_num+1;
            $journal->journal_transactiondate=date("Y-m-d");
            $journal->journal_paydate=date("Y-m-d");
            $journal->journal_currency=1;
            $journal->transaction_type='Cancel Deposit';
            $journal->journal_referenceid=$sale_id;
            $journal->journal_by_project=$item_proid->project_id;
            $journal->journal_by=auth()->user()->id;
            $journal->save();

            $jj=JournalModel::select(DB::raw("Max(id) as last_id"))->first();

            $journal=new JournalModel;
            $journal->branch_id=0;
            $journal->journal_parentid=$jj->last_id;
            $journal->journal_type=2;
            $journal->journal_acccode=21003;
            $journal->voucher_type=1;
            $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
            $journal->journal_des=\Globals::DescriptionBySaleID("", $sale_id).' Cancel Deposit';
            $journal->journal_debit=$sale_amount->sale_receive_amount;
            $journal->journal_credit=0;
            $journal->journal_tran_id=$j->last_num+1;
            $journal->journal_transactiondate=date("Y-m-d");
            $journal->journal_paydate=date("Y-m-d");
            $journal->journal_currency=1;
            $journal->transaction_type='Cancel Deposit';
            $journal->journal_referenceid=$sale_id;
            $journal->journal_by_project=$item_proid->project_id;
            $journal->journal_by=auth()->user()->id;
            $journal->save();
        }
        SaleModel::where("id",$sale_id)->update(["status"=>0]);
        SaleDetailModel::where("sale_id",$sale_id)->update(["status"=>0]);
        DepositModel::where("sale_id",$sale_id)->update(['status'=>0]);
        return json_encode($sale_id);
    }
    public function delete_deposit(Request $request){

        $this->validate($request,[
            "sale_id"=>"required|numeric"
        ]);

        $sale_id = $request->sale_id;
        $deposit_data = DepositModel::where("sale_id",$sale_id)->where("status",1)->get();

        //Delete Journal
        if(!empty($deposit_data)&&count($deposit_data)>0){
            foreach($deposit_data as $value){
                JournalModel::where("journal_referenceid",$value->id)->where("transaction_type","Deposit")->where("journal_status","!=",3)->update(['journal_status'=>3]);
            }
        }

        //update item
        $items = SaleDetailModel::where("sale_id",$sale_id)->where("status",1)->get();
        foreach($items as $value){
            ItemModel::where("id",$value->item_id)->update(['stock_status'=>1,'sale_stock'=>0,'delete_status'=>1]);
        }
        //end

        SaleModel::where("id",$sale_id)->update(["status"=>2]);
        SaleDetailModel::where("sale_id",$sale_id)->where("status",1)->update(["status"=>2]);
        DepositModel::where("sale_id",$sale_id)->where("status",1)->update(['status'=>2]);

        return json_encode($sale_id);
    }
    public function print_invoice($id){
        $data_deposit = DepositModel::join("nso007_sale_detail_stock","nso007_sale_detail_stock.sale_id","nso007_deposit.sale_id")
                        ->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
                        ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                        ->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                        ->join("nso007_sub_category","nso007_sub_category.id","nso007_item_stock.subcategory_id")
                        ->select(
                            "nso007_deposit.*",
                            "nso007_project_stock.name as project_name",
                            DB::raw("GROUP_CONCAT(nso007_item_stock.name) as item_name"),
                            "nso007_category_stock.name as category_name",
                            DB::raw("SUM(nso007_sale_detail_stock.item_price) as sale_price"),
                            "nso007_sub_category.name as sub_category_name",
                        )
                        ->where("nso007_deposit.id",$id)
                        ->first();
        $client_info = SaleModel::where("nso007_sale_stock.id",$data_deposit->sale_id)
                        ->join("nso007_client","nso007_client.id","nso007_sale_stock.client_id")
                        ->select(
                            "nso007_client.*",
                            "nso007_sale_stock.date",
                            "nso007_sale_stock.sale_amount",
                            "nso007_sale_stock.discount_amount",
                            "nso007_sale_stock.sale_receive_amount"
                        )
                        ->first();
        $schedule_deposits = DB::table('nso007_deposit_schedule')->where("id",$data_deposit->deposit_schedule_id)->first();
        // dd($schedule_deposits);
        $deposit_all = DepositModel::where("sale_id",$data_deposit->sale_id)->get();
        return view("invoice.deposit_invoice",compact("data_deposit","client_info","schedule_deposits",'deposit_all'));
    }

    public function edit($id)
    {
        // dd("OK");
        $sale_id = $id;
        $provinces = ProvinceModel::select(
            DB::raw('CONCAT(province_id," ",province_en," ",province_km) AS province_mixed'),'province_id')
            ->pluck('province_mixed','province_id')
            ->prepend('Please Select', '');

        $data_sale_detail = SaleDetailModel::join("nso007_sale_stock","nso007_sale_stock.id","nso007_sale_detail_stock.sale_id")->where("nso007_sale_detail_stock.sale_id",$sale_id)->where("nso007_sale_stock.status",1)->get();

        $clients=ClientModel::where("type",1)->where("id",$data_sale_detail[0]->client_id)->first();

        $agencies=AgencyModel::where("status",1)->where("id",optional($data_sale_detail[0])->agency_id)->first();

        foreach ($data_sale_detail as $key => $value) {
            $data=ItemModel::join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                ->select("nso007_item_stock.id","nso007_item_stock.name","nso007_item_stock.price","nso007_item_stock.cost","nso007_item_stock.size","nso007_item_stock.project_id","nso007_project_stock.name as project_name")
                ->where("nso007_item_stock.id",$value->item_id)
                ->first();
            $cart[$value->item_id]=$data;

        }
        session()->put("Cart_Deposit",$cart);

        return view("deposit.edit",compact('clients','agencies','provinces','data_sale_detail'));
    }
    public function get_item_edit(Request $request)
    {
        if($request->isMethod("POST")){

        }else{
            $search = $request->input('search.value');
            $count_total =ItemModel::join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                            ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                            ->where("nso007_item_stock.status",1)
                            ->where("nso007_item_stock.stock_status",1)
                            ->where("nso007_item_stock.sale_stock",0)
                            ->when(session()->has("Cart_Deposit"),function($query){
                                $cart=session()->get("Cart_Deposit");
                                foreach($cart as $key => $value) {
                                    $query->orWhere("nso007_item_stock.id",$value->id);
                                }
                            })
                            ->count();
            $count_filter =ItemModel::join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                            ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                            ->where(function($query) use ($search){
                                $query->orWhere('nso007_item_stock.name' , 'LIKE' , '%'.$search.'%');
                                $query->orWhere('nso007_project_stock.name' , 'LIKE' , '%'.$search.'%');
                                $query->orWhere('nso007_category_stock.name' , 'LIKE' , '%'.$search.'%');
                            })
                            ->where("nso007_item_stock.stock_status",1)
                            ->where("nso007_item_stock.sale_stock",0)
                            ->where("nso007_item_stock.status",1)
                            ->when(session()->has("Cart_Deposit"),function($query){
                                $cart=session()->get("Cart_Deposit");
                                foreach($cart as $key => $value) {
                                    $query->orWhere("nso007_item_stock.id",$value->id);
                                }
                            })
                            ->count();

            $items = ItemModel::join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                            ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                                ->select("nso007_item_stock.*","nso007_project_stock.name as project_name","nso007_category_stock.name as category_name")
                                ->orderBy('nso007_item_stock.id','asc')
                                ->where("nso007_item_stock.status",1)
                                ->where("nso007_item_stock.stock_status",1)
                                ->where("nso007_item_stock.sale_stock",0)
                                ->when(session()->has("Cart_Deposit"),function($query){
                                    $cart=session()->get("Cart_Deposit");
                                    foreach($cart as $key => $value) {
                                        $query->orWhere("nso007_item_stock.id",$value->id);
                                    }
                                })
                                ->take(10);
            return Datatables::of($items)
                ->addIndexColumn()
                ->setRowId("id")
                ->with([
                    "recordsTotal" => $count_total,
                     "recordsFiltered" => $count_filter,
                  ])
                ->addColumn('action',function($items){
                    $status= ' <button type="button" class="btn btn-success btn-sm" data-index="'.$items->id.'" title="Add To Cart" onclick="Add_To_Cart(this)"><i class="fas fa-cart-arrow-down"></i></button> ';
                    if(session()->has("Cart_Deposit")){
                        $cart=session()->get("Cart_Deposit");
                        if(isset($cart[$items->id])){
                            $status= ' <button type="button" class="btn btn-info btn-sm" title="Undo ( Remove Item From Cart )" onclick="Remove_From_Cart(this)"><i class="fas fa-undo-alt"></i></button> ';
                        }
                    }
                    return $status;
                })
                 ->rawColumns([
                    'action' => 'action',
                ])
                ->make(true);
        }
    }
    public function Add_To_Cart(Request $request)
    {
        $id=$request->id;
        $data=ItemModel::join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                ->select("nso007_item_stock.id","nso007_item_stock.name","nso007_item_stock.price","nso007_item_stock.cost","nso007_item_stock.size","nso007_item_stock.project_id","nso007_project_stock.name as project_name")
                ->where("nso007_item_stock.id",$id)
                ->first();
        if(empty($data)){
            $message=[
                'status'=>'error',
                'type'=>'error',
                "text"=>"Error with your request. Please try again !",
            ];
            return json_encode($message);
        }
        if(session()->has("Cart_Deposit")){
            $cart=session()->get("Cart_Deposit");
            if(isset($cart[$id])){
                $message=[
                    'status'=>'warning',
                    'type'=>'exist',
                    "text"=>"Item is exsit !",
                ];
                return json_encode($message);
            }else{
                $cart[$id]=$data;
                session()->put("Cart_Deposit",$cart);
                $message=[
                    'status'=>'success',
                    'type'=>'added',
                    "text"=>"Add successfully !",
                    "data"=>$cart
                ];
                return json_encode($message);
            }
        }else{
            $cart_data=array(
                $id=>$data
            );
            session()->put("Cart_Deposit",$cart_data);
            $message=[
                'status'=>'success',
                'type'=>'added',
                "text"=>"Add successfully !",
                "data"=>$cart_data
            ];
            return json_encode($message);
        }
    }
    public function Remove_From_Cart(Request $request){
        $id=$request->id;
        if(session()->has("Cart_Deposit")){
            $cart=session()->get("Cart_Deposit");
            unset($cart[$id]);
            session()->put("Cart_Deposit",$cart);
            return json_encode("OK");

        }else{
            return json_encode("Error");
        }
    }
    public function update_pos(Request $request){

        // dd($request->all());
        $this->validate($request,[
            "client_id"=>"required|numeric",
            // "agency_id"=>"required|numeric",
            // "date"=>"required",
            "contract_date"=>"required",
            "sale_id"=>"required|numeric"
        ]);
        DB::beginTransaction();
        try{
            $sale_amount=0;$check_item="";
            //Get Item From Session store

            if(session()->has("Cart_Deposit")){
                if(session()->get("Cart_Deposit")==[]) return json_encode("Error");
                $data_sale_detail = SaleDetailModel::join("nso007_sale_stock","nso007_sale_stock.id","nso007_sale_detail_stock.sale_id")->where("nso007_sale_detail_stock.sale_id",$request->sale_id)->where("nso007_sale_stock.status",1)->get();
                foreach ($data_sale_detail as $key => $value) {
                    ItemModel::where("id",$value->item_id)->update([
                        'stock_status'=>1,
                        "sale_stock"=>0,
                        "delete_status"=>1
                    ]);
                }

                SaleDetailModel::where("sale_id",$request->sale_id)->where("status",1)->delete();

                $data_cart = session()->get("Cart_Deposit");
                foreach($data_cart as $key => $value){
                    $sale_amount+=$value['price'];
                    $check_item = ItemModel::where("id",$value["id"])
                                  ->where("stock_status",2)->first();
                    if(!empty($check_item)){
                        return json_encode("BOOKED");
                    }

                }
                session()->forget("Cart_Deposit");//Delete session Cart
            }else{
                return json_encode("Error");
            }
            //End

            //Update into Sale Stock
            $sale_data = array(
                "date" => (!empty($request->date)?date("Y-m-d",strtotime($request->date)):null),
                "sale_amount" => $sale_amount,
                "sale_remain_amount" => $sale_amount - $data_sale_detail[0]->sale_receive_amount,
                "client_id" => $request->client_id,
                "date_on_contract" => date("Y-m-d",strtotime($request->contract_date)),
                "agency_id" => $request->agency_id
            );
            SaleModel::where("id",$request->sale_id)->update($sale_data);
            $sale_id=$request->sale_id;
            //End

            //Update into Deposit
            $deposit_data = array(
                // "date" => date("Y-m-d",strtotime($request->date)),
                "date_on_contract" => date("Y-m-d",strtotime($request->contract_date))
            );
            DepositModel::where("sale_id",$request->sale_id)->where("status",1)->update($deposit_data);
            //End

            $I_name="";$sum_total_price=0;

            foreach($data_cart as $key=>$value){
                //Update item status
                ItemModel::where("id",$value['id'])
                    ->update(['stock_status'=>2,"sale_stock"=>1,"delete_status"=>0]);

                //Insert Sale Detail
                $I_name .= $value['name'].",";


                $sum_total_price+=$value['price'];

                $data_sale_detail = array(
                    "sale_id" => $sale_id,
                    "item_cost" => $value['cost'],
                    "item_price" => $value['price'],
                    "item_id" => $value["id"],
                );
                SaleDetailModel::insert($data_sale_detail);
            }

            ClientModel::where("id",$request->client_id)->update(['delete_status'=>0]);//set status_delete
            AgencyModel::where("id",$request->agency_id)->update(['delete_status'=>0]);//set status_delete
            User::where("id",Auth::user()->id)->update(['status_delete'=>0]);//set status_delete
            DB::commit();
            return json_encode("OK");
        }catch(\Exception $e){
            DB::rollback();
            return json_encode("Error");
        }
    }

    public function edit_deposit($id)
    {
        $data = DB::table("nso007_deposit_schedule")->where("id",$id)->first();
        return json_encode($data);
    }
    public function save_edit_deposit(Request $request)
    {
        $this->validate($request,[
            "deposit_id"=>"required",
            "deposit_date"=>"required",
            "deposit_amount"=>"required",
        ]);

        DB::beginTransaction();
        try
        {

            DB::table('nso007_deposit_schedule')->where("id",$request->deposit_id)->update(
                [
                    "date"=>date("Y-m-d",strtotime($request->deposit_date)),
                    'amount'=>$request->deposit_amount,
                ]
            );
            DB::commit();
            return json_encode("OK");
        }
        catch (\Exception $ex)
        {
            DB::rollback();
            return json_encode("Error");
        }
    }
    public function pay_deposit(Request $request){
        // dd($request->all());
        $this->validate($request,[
            'schedule_deposit_id'=>'required',
            'date'=>'required',
            'deposit_amount'=>'required',
            'payment_method'=>'required',
            'schedule_deposit_sale_id'=>'required'
        ]);
        if($request->payment_method==1){

        }
        else if($request->payment_method==2){

        }
        else if($request->payment_method==3){

        }
        else {

        }
        DB::beginTransaction();
        try{
            DB::table("nso007_deposit_schedule")->where("id",$request->schedule_deposit_id)->update(['pay_type'=>1,'paid_amount'=>$request->deposit_amount]);

            DB::table("nso007_sale_stock")->where("id",$request->schedule_deposit_sale_id)->where('status',1)->update(["sale_remain_amount"=>DB::raw("sale_remain_amount - ".$request->deposit_amount),"sale_receive_amount"=>DB::raw('sale_receive_amount + '.$request->deposit_amount)]);

            $acc_code = "";

            if($request->payment_method==1){
                DB::table("nso007_deposit")->insert(
                    [
                        'sale_id'=>$request->schedule_deposit_sale_id,
                        'date'=>date("Y-m-d",strtotime($request->date)),
                        'deposit_amount'=>$request->deposit_amount,
                        'description'=>$request->description,
                        'user_id'=>Auth::user()->id,
                        'deposit_schedule_id'=>$request->schedule_deposit_id,
                        'payment_type'=>$request->payment_method
                    ]);
                $acc_code = "11001";
            }
            else if($request->payment_method==2){
                DB::table("nso007_deposit")->insert(
                    [
                        'sale_id'=>$request->schedule_deposit_sale_id,
                        'date'=>date("Y-m-d",strtotime($request->date)),
                        'deposit_amount'=>$request->deposit_amount,
                        'description'=>$request->description,
                        'user_id'=>Auth::user()->id,
                        'deposit_schedule_id'=>$request->schedule_deposit_id,
                        'payment_type'=>$request->payment_method,
                        'from_bank'=>$request->from_bank_name,
                        'from_account_bank'=>$request->from_bank_account,
                        "to_bank"=>$request->to_bank_name,
                        "to_account_bank"=>$request->to_bank_account
                    ]);
                $acc_code = "11002";
                \Globals::set_status_cannot_delete_bank($request->from_bank_name);
                \Globals::set_status_cannot_delete_bank($request->to_bank_name);
            }
            else if($request->payment_method==3){
                DB::table("nso007_deposit")->insert(
                    [
                        'sale_id'=>$request->schedule_deposit_sale_id,
                        'date'=>date("Y-m-d",strtotime($request->date)),
                        'deposit_amount'=>$request->deposit_amount,
                        'description'=>$request->description,
                        'user_id'=>Auth::user()->id,
                        'deposit_schedule_id'=>$request->schedule_deposit_id,
                        'payment_type'=>$request->payment_method,
                        'bank_cheque'=>$request->bank_of_cheque,
                        'cheque_number'=>$request->cheque_number
                    ]);
                $acc_code = "11002";
                \Globals::set_status_cannot_delete_bank($request->bank_of_cheque);
            }
            else {

            }

            $deposit_max_id = DepositModel::max("id");

            $max_deposit_id = DB::select("SELECT count(id) as num_id FROM nso007_deposit
                                            WHERE nso007_deposit.sale_id = $request->schedule_deposit_sale_id
                                          ");

            $report_booking     = DB::table('nso007_sale_stock')
                ->join('nso007_sale_detail_stock', 'nso007_sale_detail_stock.sale_id', 'nso007_sale_stock.id')
                ->join('nso007_item_stock', 'nso007_item_stock.id', 'nso007_sale_detail_stock.item_id')
                ->select(
                    'nso007_item_stock.project_id'
                )
                ->where('nso007_sale_stock.id', $request->schedule_deposit_sale_id)->get();

            $item_stock          = $report_booking[0]->project_id;

            if(!empty($request->deposit_amount))
            {
                $j=JournalModel::select(DB::raw("Max(journal_tran_id) as last_num"))->first();

                $journal=new JournalModel;
                $journal->branch_id=0;
                $journal->journal_parentid=0;
                $journal->journal_type=10000;
                $journal->journal_acccode=$acc_code;
                $journal->voucher_type=1;
                $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
                $journal->journal_des=\Globals::DescriptionBySaleID("", $request->schedule_deposit_sale_id).' Deposit '.$max_deposit_id[0]->num_id;
                $journal->journal_debit=$request->deposit_amount;
                $journal->journal_credit=0;
                $journal->journal_tran_id=$j->last_num+1;
                $journal->journal_transactiondate=date("Y-m-d H:i:s");
                $journal->journal_paydate=date("Y-m-d",strtotime($request->date));
                $journal->journal_currency=1;
                $journal->transaction_type='Deposit';
                $journal->journal_referenceid=$deposit_max_id;
                $journal->journal_by_project=$item_stock;
                $journal->journal_by=auth()->user()->id;
                $journal->save();

                $jj=JournalModel::select(DB::raw("Max(id) as last_id"))->first();

                $journal=new JournalModel;
                $journal->branch_id=0;
                $journal->journal_parentid=$jj->last_id;
                $journal->journal_type=20000;
                $journal->journal_acccode=21003;
                $journal->voucher_type=1;
                $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
                $journal->journal_des=\Globals::DescriptionBySaleID("", $request->schedule_deposit_sale_id).' Deposit '.$max_deposit_id[0]->num_id;
                $journal->journal_debit=0;
                $journal->journal_credit=$request->deposit_amount;
                $journal->journal_tran_id=$j->last_num+1;
                $journal->journal_transactiondate=date("Y-m-d H:i:s");
                $journal->journal_paydate=date("Y-m-d",strtotime($request->date));
                $journal->journal_currency=1;
                $journal->transaction_type='Deposit';
                $journal->journal_referenceid=$deposit_max_id;
                $journal->journal_by_project=$item_stock;
                $journal->journal_by=auth()->user()->id;
                $journal->save();
            }

            \Globals::calculate_commission($request->schedule_deposit_sale_id);

            DB::commit();
            return redirect()->route('deposit.print_invoice',$deposit_max_id);
        }catch(\Exception $e){
            DB::rollback();
            return json_encode("Error");
        }
    }
    public function get_deposit_data_print($sale_id){
        return DepositModel::where("sale_id",$sale_id)->where("status",1)->select("id","deposit_schedule_id",DB::raw('DATE_FORMAT(date, "%d-%m-%Y") as date'))->get();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    public function remark_promotion(Request $request){
        if($request->isMethod("GET")){

        }else{
            $data = $request->all();
            $sale = SaleModel::find($data['sale_id']);
            $sale->remark_promotion = $data['remark_promotion'];
            $sale->save();
            return json_encode(['message'=>'success','status'=>true]);
        }
    }
}
