<?php

namespace App\Http\Controllers;
use DB;
use Illuminate\Http\Request;
use App\ProvinceModel;
use Auth;
use DataTables;
use App\ClientRelationshipModel;
use Image;
use Crypt;
use App\User;
use Gate;

class ClientRelationshipController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
         $this->middleware('permission:Client-Relationship-List', ['only' => ['index','datatable_get_relationship']]);
         $this->middleware('permission:Client-Relationship-Create', ['only' => ['create','store']]);
         $this->middleware('permission:Client-Relationship-Edit', ['only' => ['edit','update']]);
         $this->middleware('permission:Client-Relationship-Delete', ['only' => ['destroy']]);
    }

    public function index()
    {
        return view("client_relationship.index");
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $provinces = ProvinceModel::select(
            DB::raw('CONCAT(province_id," ",province_en," ",province_km) AS province_mixed'),'province_id')
            ->pluck('province_mixed','province_id')
            ->prepend('Please Select', '');
        return view("client_relationship.create",compact("provinces"));
    }

    public function datatable_get_relationship(Request $request)
    {
        $search = $request->input('search.value');
        $count_total =ClientRelationshipModel::join("users","users.id","nso007_client_relationship.user_id")
                        ->where("nso007_client_relationship.status",1)
                        ->count();
        $count_filter =ClientRelationshipModel::join("users","users.id","nso007_client_relationship.user_id")
                        ->where(function($query) use ($search){
                            $query->orWhere('nso007_client_relationship.name' , 'LIKE' , '%'.$search.'%');
                            $query->orWhere('nso007_client_relationship.nick_name' , 'LIKE' , '%'.$search.'%');
                            $query->orWhere('nso007_client_relationship.phone' , 'LIKE' , '%'.$search.'%');
                        })
                        ->where("nso007_client_relationship.status",1)
                        ->count();

        $client_relationship = ClientRelationshipModel::with(['get_province','get_district','get_commune','get_village'])->join("users","users.id","nso007_client_relationship.user_id")
                            ->select("nso007_client_relationship.*")
                            ->orderBy('nso007_client_relationship.id','asc')
                            ->where("nso007_client_relationship.status",1)
                            ->take(20);
        return Datatables::of($client_relationship)
            ->addIndexColumn()
            ->with([
                "recordsTotal" => $count_total,
                 "recordsFiltered" => $count_filter,
              ])
            ->addColumn('action',function($client_relationship){
                $button = "";

                if(Gate::check('Client-Relationship-Show'))
                    $button.= ' <button class="btn btn-info btn-sm" data-toggle="modal" data-target="#show-client-relationship" title="Show" onclick="show_info('.$client_relationship->id.')"><i class="fas fa-eye"></i></button> ';

                if(Gate::check('Client-Relationship-Edit'))
                    $button.= ' <a href="'.Route("clientrelationship.edit", Crypt::encrypt($client_relationship->id)).'"  class="btn btn-success btn-sm" data-toggle="tooltip" data-placement="top" title="Edit"><i class="fas fa-edit"></i></a> ';

                if(Gate::check('Client-Relationship-Delete')){
                    if($client_relationship->delete_status==0){
                        $button .= ' <button type="button" disabled title="Delete" class="btn btn-sm btn-danger"><i class="fa fa-trash"></i></button>';
                    }elseif($client_relationship->delete_status==1){
                        $button .= ' <button type="button" title="Delete" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#modal-danger'.$client_relationship->id.'"><i class="fa fa-trash"></i></button>
                        <div class="modal fade" id="modal-danger'.$client_relationship->id.'">
                            <form action="'.route("client_relationship.delete",$client_relationship->id).'" method="GET" style="display:inline">
                              <div class="modal-dialog">
                                <div class="modal-content bg-danger">
                                  <div class="modal-header">
                                    <h4 class="modal-title">'.__("application.Delete")." ".__("application.Position").'</h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                      <span aria-hidden="true">&times;</span>
                                    </button>
                                  </div>
                                  <div class="modal-body">
                                    <p style="font-size: 120%;">'.__("application.Are you sure want to delete this").' ?</p>
                                  </div>
                                  <div class="modal-footer justify-content-between">
                                    <a>&nbsp;</a>
                                    <button type="submit" class="btn btn-default btn-sm fa fa-save"> '.__("application.OK").'</button>
                                  </div>
                                </div>
                                <!-- /.modal-content -->
                              </div>
                              <!-- /.modal-dialog -->
                              </form>
                            </div>
                            <!-- /.modal -->
                        ';
                    }else{

                    }
                }
                
                return $button;
            })
            // ->editColumn('image', function ($client_relationship) {
            //     if(!empty($client_relationship->image))
            //             $url = asset('assets/img/upload/' . $client_relationship->image);
            //     else $url = asset('assets/img/defaultimage.png');
            //     return $url;
            // })
            ->editColumn("address",function($client_relationship){
                $location="";
                if(!empty($client_relationship->house_number)) $location.=$client_relationship->house_number;
                if(!empty($client_relationship->street_number)) $location.=" ,".$client_relationship->street_number;
                if(!empty($client_relationship->get_village['village_km'])) $location.="  ភូមិ ".$client_relationship->get_village['village_km'];
                if(!empty($client_relationship->get_commune['commune_km'])) $location.=" ,ឃុំ/សង្កាត់ ".$client_relationship->get_commune['commune_km'];
                if(!empty($client_relationship->get_district['district_km'])) $location.=" ,ស្រុក/ខ័ណ្ឌ​ ".$client_relationship->get_district['district_km'];
                if(!empty($client_relationship->get_province['province_km'])) $location.=" ,ខេត្ត/រាជធានី​ ".$client_relationship->get_province['province_km'];
                return $location;
            })
            ->rawColumns([
                'action' => 'action',
            ])
            ->make(true); 
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'name'=>'required',
            'gender'=>'required',
            'date_of_birth'=>'required',
            'phone'=>'required|unique:nso007_client_relationship,phone',
            'nationality'=>'required',
            'id_card_number'=>'required|unique:nso007_client_relationship,id_card_number',
            'village'=>'required',
            'commune'=>'required',
            'district'=>'required',
            'province'=>'required'
        ]);

        $image = $request->file('photo');
        $imagename="";
        if($image){
            $input['imagename'] = time().'.'.$image->getClientOriginalExtension();
     
            $destinationPath = public_path('/assets/img/upload');
            $img = Image::make($image->getRealPath());
            $img->resize(150, 150, function ($constraint) {
                $constraint->aspectRatio();
            })->save($destinationPath.'/'.$input['imagename']);
            $imagename=$input['imagename'];
        }

        $client_relationship=new ClientRelationshipModel;
        $client_relationship->name=$request->name;
        $client_relationship->gender=$request->gender;
        $client_relationship->date_of_birth=date("Y-m-d",strtotime($request->date_of_birth));
        $client_relationship->phone=$request->phone;
        $client_relationship->email=$request->email;
        $client_relationship->nationality=$request->nationality;
        $client_relationship->image=$imagename;
        $client_relationship->id_card_number=$request->id_card_number;
        if(!empty($request->id_card_date))
            $client_relationship->id_card_date=date("Y-m-d",strtotime($request->id_card_date));
        if(!empty($request->id_card_date_valid))
            $client_relationship->id_card_date_valid=date("Y-m-d",strtotime($request->id_card_date_valid));
        $client_relationship->user_id=Auth::user()->id;
        $client_relationship->description=$request->description;
        $client_relationship->house_number=$request->house_number;
        $client_relationship->street_number=$request->street_number;
        $client_relationship->village=$request->village;
        $client_relationship->commune=$request->commune;
        $client_relationship->district=$request->district;
        $client_relationship->province=$request->province;
        $client_relationship->delete_status=1;
        $client_relationship->status=1;
        $client_relationship->date=date("Y-m-d");
        $client_relationship->job=$request->job;
        $client_relationship->work_place=$request->work_place;
        $client_relationship->nick_name=$request->nick_name;
        $client_relationship->save();

        User::where("id",Auth::user()->id)->update(['status_delete'=>0]);//couldn't delete user

        return redirect()->route("clientrelationship.index")->with("success","Create successfully !");
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $clientrelationship=ClientRelationshipModel::where("id",$id)->with(['get_province','get_district','get_commune','get_village'])->first();
        return json_encode($clientrelationship);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $id=Crypt::decrypt($id);
        $provinces = ProvinceModel::select(
            DB::raw('CONCAT(province_id," ",province_en," ",province_km) AS province_mixed'),'province_id')
            ->pluck('province_mixed','province_id')
            ->prepend('Please Select', '');
        $client_relationship=ClientRelationshipModel::where("id",$id)->with(['get_province','get_district','get_commune','get_village'])->first();
        return view('client_relationship.edit',compact("client_relationship","provinces"));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'name'=>'required',
            'gender'=>'required',
            'date_of_birth'=>'required',
            'phone'=>'required|unique:nso007_client_relationship,phone,'.$id,
            'nationality'=>'required',
            'id_card_number'=>'required|unique:nso007_client_relationship,id_card_number,'.$id,
            'village'=>'required',
            'commune'=>'required',
            'district'=>'required',
            'province'=>'required'
        ]);

        $client_relationship=ClientRelationshipModel::find($id);

        $photo = $request->file('image');
        $imagename="";
        if($photo){
            $imagename = time().'.'.$photo->getClientOriginalExtension();
            $destinationPath = public_path('/assets/img/upload');
            $img = Image::make($photo->getRealPath());
            $img->resize(150, 150, function ($constraint) {
                $constraint->aspectRatio();
            })->save($destinationPath.'/'.$imagename);
             $client_relationship->image=$imagename;
        }else{
            if(empty($request->cpImage))
                $client_relationship->image=$imagename;//empty or remove image
        }

        $client_relationship->name=$request->name;
        $client_relationship->gender=$request->gender;
        $client_relationship->date_of_birth=date("Y-m-d",strtotime($request->date_of_birth));
        $client_relationship->phone=$request->phone;
        $client_relationship->email=$request->email;
        $client_relationship->nationality=$request->nationality;
        $client_relationship->id_card_number=$request->id_card_number;
        if(!empty($request->id_card_date))
            $client_relationship->id_card_date=date("Y-m-d",strtotime($request->id_card_date));
        if(!empty($request->id_card_date_valid))
            $client_relationship->id_card_date_valid=date("Y-m-d",strtotime($request->id_card_date_valid));
        $client_relationship->description=$request->description;
        $client_relationship->house_number=$request->house_number;
        $client_relationship->street_number=$request->street_number;
        $client_relationship->village=$request->village;
        $client_relationship->commune=$request->commune;
        $client_relationship->district=$request->district;
        $client_relationship->province=$request->province;
        $client_relationship->job=$request->job;
        $client_relationship->work_place=$request->work_place;
        $client_relationship->nick_name=$request->nick_name;
        $client_relationship->save();

        return redirect()->route("clientrelationship.index")->with("success","Update successfully !");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        ClientRelationshipModel::where("id",$id)->delete();
        return \back()->with("success","Delete successfully !");
    }
    public function get_post_client_relationship(Request $request,$sale_id=""){
        if($request->isMethod("GET")){
            $client_relationship_loan = DB::table("nso007_loan_client_relationship")->where("sale_id",$sale_id)->get();
            if(isset($client_relationship_loan[0])&&!empty($client_relationship_loan[0]))
            {
                foreach($client_relationship_loan as $k=>$value){
                    $client_relationship = DB::table("nso007_client_relationship")->select("name","id")->where("id",$client_relationship_loan[$k]->client_relationship_id)->first();
                    $data[$k] = array(
                        "id"=>$client_relationship->id,
                        'clientship_fullname'=>$client_relationship->name,
                        'client_relation_type'=>$client_relationship_loan[$k]->relationship_type
                    );
                }
                
                return json_encode($data);
            }
            else return "OK";
        }
        else{
            DB::table("nso007_loan_client_relationship")->where("sale_id",$request->sale_id)->delete();
            
            if(isset($request->client_relationship_id[0])&&!empty($request->client_relationship_id[0])){
                foreach($request->client_relationship_id as $key=>$value){
                    DB::table("nso007_loan_client_relationship")->insert(['sale_id'=>$request->sale_id,'client_relationship_id'=>$request->client_relationship_id[$key],'relationship_type'=>(!empty($request->client_relationship_type[$key])?$request->client_relationship_type[$key]:'')]);
                    DB::table('nso007_client_relationship')->where("delete_status",1)->where("id",$request->client_relationship_id[$key])->update(['delete_status'=>2]);
                }
            }
        }
        return \Back()->with("success","change successfully!");
    }
}
