<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\ProjectModel;
use App\CategoryModel;
use DB;
use App\BlockModel;
use DataTables;

class BalanceReport extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
         $this->middleware('permission:Balance-Report-Construction-List', ['only' => ['index','balance_report_get']]);
    }
    public function index()
    {
        $projects = ProjectModel::select(
            DB::raw('name project_mixed'),'id')
            ->pluck('project_mixed','id');
        $categories = DB::table('nso007_category_construction')->select('pcat_name','pcat_id')
            ->pluck('pcat_name','pcat_id');
        $blogs=BlockModel::select("nso007_block.name","nso007_block.id",DB::raw("CONCAT(nso007_project_stock.name,' | ',nso007_block.name) as blog_pro"))->join("nso007_project_stock","nso007_project_stock.id","nso007_block.project_id")->pluck("blog_pro",'id');
        $products = DB::table("product")->select("pro_name","id")->pluck('pro_name','id');
        return view('construction-report.balance-report.index',compact('projects','categories','blogs','products'));
    }
    public function get_product_by_category(Request $request){
      $products = DB::table("product")->whereIn("product.pro_category_id",$request->category_id)->select("pro_name","id")->get();
      return json_encode($products);
    }
    public function get_zone_by_project(Request $request){
      $zones = DB::table("nso007_block")->whereIn("nso007_block.project_id",$request->project_id)->select("name","id")->get();
      return json_encode($zones);
    }
    public function balance_report_get(Request $request)
    {
        # code...
        if ($request->isMethod('GET')){

            $form_date =  (empty($request->form_date))? '': date('Y-m-d',strtotime($request->form_date));
            $to_date   =  (empty($request->to_date))? '': date('Y-m-d',strtotime($request->to_date));
            $category=isset($request->category)? $request->category:NULL;
            $product=isset($request->product)? $request->product:NULL;
            $project=isset($request->project_id)? $request->project_id:NULL;
            $blog_id=isset($request->blog_id)? $request->blog_id:NULL;

            $usingproducts_total=DB::table("nso007_product_stock")
                ->join("product","product.id","nso007_product_stock.product_id")
                ->join("nso007_block","nso007_block.id","nso007_product_stock.blog_id")
                ->join("nso007_purchase","nso007_purchase.blog_id","nso007_block.id")
                ->join("construction_supplier","construction_supplier.id","nso007_purchase.supplier_id")
                ->join("nso007_project_stock","nso007_project_stock.id","nso007_block.project_id")
                ->join("unit","unit.id","product.pro_unit_id")
            ->select("nso007_block.name","nso007_project_stock.name as project_name","construction_supplier.supp_name","construction_supplier.supp_phone","product.pro_qty","pro_name","nso007_product_stock.using_qty","unit_name",'nso007_product_stock.purchase_qty as pur_qty','nso007_product_stock.balance_qty')
              ->groupBy("nso007_product_stock.id")
              ->get();

            $usingproducts_filter=DB::table("nso007_product_stock")
                ->join("product","product.id","nso007_product_stock.product_id")
                ->join("nso007_category_construction","nso007_category_construction.pcat_id","product.pro_category_id")
                ->join("nso007_block","nso007_block.id","nso007_product_stock.blog_id")
                ->join("nso007_purchase","nso007_purchase.blog_id","nso007_block.id")
                ->join("construction_supplier","construction_supplier.id","nso007_purchase.supplier_id")
                ->join("nso007_project_stock","nso007_project_stock.id","nso007_block.project_id")
                ->join("unit","unit.id","product.pro_unit_id")
            ->select("nso007_block.name","nso007_project_stock.name as project_name","construction_supplier.supp_name","construction_supplier.supp_phone","product.pro_qty","pro_name","nso007_product_stock.using_qty","unit_name",'nso007_product_stock.purchase_qty as pur_qty','nso007_product_stock.balance_qty')
              ->when(request('product'),function($query) use ($product){
                $query->whereIn('product.id',$product);
              })
              ->when(request('category'),function($query) use ($category){
                $query->whereIn('nso007_category_construction.pcat_id',$category);
              })
              ->when(request('project_id'),function($query) use ($project){
                $query->whereIn('nso007_project_stock.id',$project);
              })
              ->when(request('blog_id'),function($query) use ($blog_id){
                $query->whereIn('nso007_block.id',$blog_id);
              })
              ->groupBy("nso007_product_stock.id")
              ->get();

            $usingproducts=DB::table("nso007_product_stock")
                ->join("product","product.id","nso007_product_stock.product_id")
                ->join("nso007_category_construction","nso007_category_construction.pcat_id","product.pro_category_id")
                ->join("nso007_block","nso007_block.id","nso007_product_stock.blog_id")
                ->join("nso007_purchase","nso007_purchase.blog_id","nso007_block.id")
                ->join("construction_supplier","construction_supplier.id","nso007_purchase.supplier_id")
                ->join("nso007_project_stock","nso007_project_stock.id","nso007_block.project_id")
                ->join("unit","unit.id","product.pro_unit_id")
            ->select("nso007_block.name","nso007_project_stock.name as project_name","construction_supplier.supp_name","construction_supplier.supp_phone","product.pro_qty","pro_name","nso007_product_stock.using_qty","unit_name",'nso007_product_stock.purchase_qty as pur_qty','nso007_product_stock.balance_qty','nso007_category_construction.pcat_name as product_category_name',"product.id as product_id")
              ->when(request('product'),function($query) use ($product){
                $query->whereIn('product.id',$product);
              })
              ->when(request('category'),function($query) use ($category){
                $query->whereIn('nso007_category_construction.pcat_id',$category);
              })
              ->when(request('project_id'),function($query) use ($project){
                $query->whereIn('nso007_project_stock.id',$project);
              })
              ->when(request('blog_id'),function($query) use ($blog_id){
                $query->whereIn('nso007_block.id',$blog_id);
              })
            ->groupBy("nso007_product_stock.id")
            ->take(20);
            return Datatables::of($usingproducts)
                    ->addIndexColumn()
                    ->with([
                        "recordsTotal" => count($usingproducts_total),
                         "recordsFiltered" => count($usingproducts_filter)
                      ])
                    ->addColumn("image",function($usingproduct){
                      $images = DB::table("construction_product_image")->where("product_id",$usingproduct->product_id)->first();
                      return '<img src="'.(!empty(optional($images)->image)?asset('assets/img/upload/'.optional($images)->image):asset('assets/img/defaultphoto.png')).'" border="0" width="100px" height="80px" class="img-rounded" align="center" />';
                    })
                    ->rawColumns(['image'=>'image'])
                    ->make(true);
        }
    }
    public function balance_report_get_print(Request $request)
    {

        $form_date =  (empty($request->form_date))? '': date('Y-m-d',strtotime($request->form_date));
        $to_date   =  (empty($request->to_date))? '': date('Y-m-d',strtotime($request->to_date));
        $supps_id=isset($request->supps_id)? $request->supps_id:NULL;
        $project=isset($request->project_id)? $request->project_id:NULL;
        $blog_id=isset($request->blog_id)? $request->blog_id:NULL;
        $date_from='';
        $date_to='';
        $opt_search=$request->opt_search;
        if(empty($request->start_date)&&empty($request->end_date)&&!empty($opt_search)){
            if($opt_search==1){
                $date_from=date('Y-m-d');
                $date_to=date('Y-m-d');
            }elseif($opt_search==2){
                $date_from = Carbon::now()->endOfMonth()->subMonth()->toDateString();
                $date_to = Carbon::now()->endOfMonth()->toDateString();
            }
            else{
                $date_from='';
                $date_to='';
            }
        }
        $usingproducts=DB::table("nso007_product_stock")
                ->join("product","product.id","nso007_product_stock.product_id")
                ->join("nso007_blog","nso007_blog.id","nso007_product_stock.blog_id")
                ->join("nso007_purchase","nso007_purchase.blog_id","nso007_blog.id")
                ->join("construction_supplier","construction_supplier.id","nso007_purchase.supplier_id")
                ->join("nso007_project_stock","nso007_project_stock.id","nso007_blog.project_id")
                ->join("unit","unit.id","product.pro_unit_id")
            ->select("nso007_blog.name","nso007_project_stock.project_name","construction_supplier.supp_name","construction_supplier.supp_phone","product.pro_qty","pro_name","nso007_product_stock.using_qty","unit_name",'nso007_product_stock.purchase_qty as pur_qty','nso007_product_stock.balance_qty')
          ->when(request('category_id'),function($query) use ($supps_id){
            $query->where('construction_supplier.id','=',$supps_id);
          })
          ->when(request('project_id'),function($query) use ($project){
            $query->where('nso007_project_stock.id','=',$project);
          })
          ->when(request('blog_id'),function($query) use ($blog_id){
            $query->where('nso007_blog.id',$blog_id);
          })
          ->groupBy("nso007_product_stock.id")
          ->get();

        return view('administrator.construction-report.balance-report.print',compact('usingproducts'));
        
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}

