<?php

namespace App\Http\Controllers;

use App\AccountChartModel;
use Illuminate\Http\Request;
use App\AccountTypeModel;

class AccountTypeController extends Controller
{
	function __construct()
    {
         $this->middleware('permission:Account-Type', ['only' => ['account_type']]);
	}
    public function index()
    {
        $account_type = AccountTypeModel::all();
        // $account_type = AccountTypeModel::with(['get_account_group'])->get();
        return view('accounting.account-type.index',compact('account_type'));
    }
    public function account_type()
    {
        $account_type = AccountTypeModel::all();
        // $account_type = AccountTypeModel::with(['get_account_group'])->get();
        return view('accounting.account-type.index',compact('account_type'));
    }
    public function show($id){
        $this->charts   = [];
        $level          = 1;
        $options        = '';
        $accounts       = AccountChartModel::where([['acctype',null],['type_id',$id]])->get();
        foreach($accounts as $key => $account){
            $item['id']                 = $account->id;
            $item['text']               = $account->code." ".$account->acc_name." ".$account->acc_namekh;
            $item['level']              = 'l'.$level;
            $options .= '<option value="'.$item['id'].'" class="'.$item['level'].'">'.$item['text'].'</option>';
            array_push($this->charts,$item);
            if($account->children->count() > 0){
                $options .= $this->sub_option($account,$level);
                $this->sub_show($account,$level);
            }
        }
        return response()->json($options);
        return response()->json($this->charts);
        $data  = AccountChartModel::where('type_id',$id)->select(DB::raw('concat(code,". ",acc_name," / ",acc_namekh) name'),'id')->pluck('name','id');


        return response()->json($data);
    }
    public function sub_option($account,$level){
        $accounts   = $account->children;
        $level++;
        $options    = '';
        foreach($accounts as $key => $account){
            $item['id']                 = $account->id;
            $item['text']               = $account->code." ".$account->acc_name." ".$account->acc_namekh;
            $item['level']              = 'l'.$level;
            $options .= '<option value="'.$item['id'].'" class="'.$item['level'].'">'.$item['text'].'</option>';
            if($account->children->count() > 0){
                $options .= $this->sub_option($account,$level);
            }
            if($key == count($accounts)-1){
                $level -=1;
            }
        }
        return $options;
    }
    public function sub_show($account,$level){
        $accounts   = $account->children;
        $level++;
        foreach($accounts as $key => $account){
            $item['id']                 = $account->id;
            $item['text']               = $account->code." ".$account->acc_name." ".$account->acc_namekh;
            $item['level']              = 'l'.$level;
            array_push($this->charts,$item);
            if($account->children->count() > 0){
                $this->sub_show($account,$level);
            }
            if($key == count($accounts)-1){
                $level -=1;
            }
        }
    }
}
