<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\JournalModel;
use App\AccountChartModel;
use DB;
use DataTables;
use Auth;
use App\ProjectModel;
use Gate;

class AccountPayableController extends Controller
{
    function __construct(){
        $this->middleware('permission:Add-Account-Payable', ['only' => ['create','store']]);
        $this->middleware('permission:List-Account-Payable', ['only' => ['index']]);
        $this->middleware('permission:Edit-Account-Payable', ['only' => ['edit','update']]);
        $this->middleware('permission:Delete-Account-Payable', ['only' => ['delete']]);
    }
    public function index(Request $request)
    {
        $acc_code       = AccountChartModel::select('code',DB::raw('CONCAT(code," ",acc_name) AS account_mixed'))
            ->where("code",21001)
            ->pluck('account_mixed', 'code')
            ->prepend('Please Select', '');
        $projects = ProjectModel::select(
            DB::raw('CONCAT(" ",name) AS project'),
            'id'
        )
            ->pluck('project', 'id');
        if($request->ajax()){
            if($request->isMethod('get')){
                $project_id = $request->project_id;
                $start_date = $request->start_date;
                $end_date   = $request->end_date;
                $last_months = $request->last_months;
                $voucher_ref = $request->voucher_ref;
                $journal_acccode = $request->journal_acccode;
                $supplier = $request->supps_id;
                $description = $request->description;
                $count_total = DB::table('nso007_journal as jn')
                                ->join('nso007_account_chart as chart', 'chart.code', '=', 'jn.journal_acccode')
                                ->leftjoin('nso007_project_stock as project', 'project.id', '=', 'jn.journal_by_project')
                                ->leftJoin("construction_supplier","construction_supplier.id","jn.journal_by_supplier")
                                ->select(
                                    'chart.acc_name',
                                    'chart.code as account_code',
                                    'jn.id',
                                    'jn.journal_des',
                                    'jn.journal_debit',
                                    'jn.journal_credit',
                                    'jn.journal_invoice',
                                    'jn.journal_paydate',
                                    'jn.voucher_type',
                                    'jn.voucher_ref',
                                    'jn.journal_status',
                                    'project.name as project_name',
                                    'jn.journal_tran_id as tran_id'
                                )
                                ->where("journal_status",0)
                                ->where("chart.code",21001)
                                ->orderBy("jn.journal_paydate","DESC")
                                ->count();
                $count_filter = DB::table('nso007_journal as jn')
                                ->join('nso007_account_chart as chart', 'chart.code', '=', 'jn.journal_acccode')
                                ->leftjoin('nso007_project_stock as project', 'project.id', '=', 'jn.journal_by_project')
                                ->leftJoin("construction_supplier","construction_supplier.id","jn.journal_by_supplier")
                                ->select(
                                    'chart.acc_name',
                                    'chart.code as account_code',
                                    'jn.id',
                                    'jn.journal_des',
                                    'jn.journal_debit',
                                    'jn.journal_credit',
                                    'jn.journal_invoice',
                                    'jn.journal_paydate',
                                    'jn.voucher_type',
                                    'jn.voucher_ref',
                                    'jn.journal_status',
                                    'project.name as project_name',
                                    'jn.journal_tran_id as tran_id'
                                )
                                ->where("journal_status",0)
                                ->where("chart.code",21001)
                                ->where(function($query) use ($project_id){
                                    if(!empty($project_id)){
                                        $query->whereIn("jn.journal_by_project",$project_id);
                                    }
                                })
                                ->where(function($query) use ($start_date,$end_date){
                                    if(!empty($start_date)&&!empty($end_date)){
                                        $query->whereBetween("jn.journal_paydate",[date("Y-m-d",strtotime($start_date)),date("Y-m-d",strtotime($end_date))]);
                                    }
                                })
                                ->where(function($query) use ($last_months){
                                    if(!empty($last_months)){
                                        $query->whereBetween("jn.journal_paydate",\Globals::the_last_month($last_months));
                                    }
                                })
                                ->where(function($query) use ($voucher_ref){
                                    if(!empty($voucher_ref)){
                                        $query->where("jn.voucher_ref",$voucher_ref);
                                    }
                                })
                                ->where(function($query) use ($journal_acccode){
                                    if(!empty($journal_acccode)){
                                        $query->whereIn("jn.journal_acccode",$journal_acccode);
                                    }
                                })
                                ->where(function($query) use ($supplier){
                                    if(!empty($supplier)){
                                        $query->whereIn('jn.journal_by_supplier',$supplier);
                                    }
                                })
                                ->where(function($query) use ($description){
                                    if(!empty($description)){
                                        $query->where("jn.journal_des","LIKE","%".$description."%");
                                    }
                                })
                                ->orderBy("jn.journal_paydate","DESC")
                                ->count();
                $data = DB::table('nso007_journal as jn')
                            ->join('nso007_account_chart as chart', 'chart.code', '=', 'jn.journal_acccode')
                            ->leftjoin('nso007_project_stock as project', 'project.id', '=', 'jn.journal_by_project')
                            ->leftJoin("construction_supplier","construction_supplier.id","jn.journal_by_supplier")
                            ->select(
                                'chart.acc_name',
                                'chart.code as account_code',
                                'jn.id',
                                'jn.journal_des',
                                'jn.journal_debit',
                                'jn.journal_credit',
                                'jn.journal_invoice',
                                'jn.journal_paydate',
                                'jn.voucher_type',
                                'jn.voucher_ref',
                                'jn.journal_status',
                                'project.name as project_name',
                                'jn.journal_tran_id as tran_id',
                                'construction_supplier.supp_name',
                                'construction_supplier.supp_phone',
                                'jn.payable_paid',
                                'jn.delete_status'
                            )
                            ->where("journal_status",0)
                            ->where("chart.code",21001)
                            ->where(function($query) use ($project_id){
                                if(!empty($project_id))
                                    $query->whereIn("jn.journal_by_project",$project_id);
                            })
                            ->where(function($query) use ($start_date,$end_date){
                                if(!empty($start_date)&&!empty($end_date)){
                                    $query->whereBetween("jn.journal_paydate",[date("Y-m-d",strtotime($start_date)),date("Y-m-d",strtotime($end_date))]);
                                }
                            })
                            ->where(function($query) use ($last_months){
                                if(!empty($last_months)){
                                    $query->whereBetween("jn.journal_paydate",\Globals::the_last_month($last_months));
                                }
                            })
                            ->where(function($query) use ($voucher_ref){
                                if(!empty($voucher_ref)){
                                    $query->where("jn.voucher_ref",$voucher_ref);
                                }
                            })
                            ->where(function($query) use ($journal_acccode){
                                if(!empty($journal_acccode)){
                                    $query->whereIn("jn.journal_acccode",$journal_acccode);
                                }
                            })
                            ->where(function($query) use ($supplier){
                                if(!empty($supplier)){
                                    $query->whereIn('jn.journal_by_supplier',$supplier);
                                }
                            })
                            ->where(function($query) use ($description){
                                if(!empty($description)){
                                    $query->where("jn.journal_des","LIKE","%".$description."%");
                                }
                            })
                            ->orderBy("jn.journal_paydate","DESC")
                            ->take(20);
            return DataTables::of($data)
                ->addIndexColumn()
                ->with([
                    "recordsTotal" => $count_total,
                    "recordsFiltered" => $count_filter,
                ])
                ->editColumn('voucher', function ($data) {
                    $voucher = "";
                    if ($data->voucher_type == 1) {
                        $voucher = "Cash Receipt";
                    } else if ($data->voucher_type == 2) {
                        $voucher = "Cash Disbursement";
                    } else if ($data->voucher_type == 3) {
                        $voucher = "Cash Reimbursement";
                    } else if ($data->voucher_type == 4) {
                        $voucher = "Cash Advance";
                    } else if ($data->voucher_type == 5) {
                        $voucher = "Advance Settlement";
                    } else if ($data->voucher_type == 6) {
                        $voucher = "Journal Entry/Adjustment";
                    }
                    return $voucher;
                })
                ->editColumn('journal_by_supplier',function($data){
                    if(!empty($data->supp_name))
                        return $data->supp_name." (".$data->supp_phone.")";
                    else return "";
                })
                ->editcolumn('journal_credit',function($data){
                    return "$".number_format($data->journal_credit,2);
                })
                ->editColumn('payable_paid',function($data){
                    return "$".number_format($data->payable_paid,2);
                })
                ->addColumn('balance',function($data){
                    return "$".number_format(($data->journal_credit - $data->payable_paid),2);
                })
                ->editColumn('account_code', function ($data) {
                    return $data->account_code . " " . $data->acc_name;
                })
                ->editColumn('journal_paydate',function($data){
                    return date("d-m-Y",strtotime($data->journal_paydate));
                })
                ->addColumn('action',function($data){
                    $btn_edit = '';
                    $btn_delete = '';
                    $btn_doprocess = '';
                    $btn_doprocess_view = '';
                    if($data->journal_status==0){
                        $btn_doprocess = '<a href="'.route('account_payable.get_pay',$data->id).'" class="btn btn-sm btn-info"><i class="fa fa-dollar-sign"></i></a> ';
                        if($data->payable_paid>0){
                            $btn_doprocess_view = '<a href="javascript:void(0)" onclick = "view_get_paid('.$data->id.')" class="btn btn-sm btn-info"><i class="fa fa-eye"></i></a> ';
                        }
                        if(Gate::check('Edit-Account-Payable'))
                            $btn_edit.= '<a href="'.route('account_payable.edit',$data->id).'" class="btn btn-sm btn-success"><i class="fa fa-edit"></i></a> ';
                        if(Gate::check('Delete-Account-Payable'))
                        if($data->delete_status==1){
                            $btn_delete.= '<a href="javascript:void(0)" data-id="'.$data->id.'" onclick="delete_account_payable('.$data->id.')" class="btn btn-sm btn-danger "><i class="fa fa-trash"></i></a>';
                        }
                    }
                    return $btn_doprocess.$btn_doprocess_view.$btn_edit.$btn_delete;
                })
                ->rawColumns(['action' => 'action'])
                ->make(true);
            }
        }

        $supps = DB::table('construction_supplier')->select(
            DB::raw('CONCAT(supp_name," | ",supp_phone) AS supplier'),'id')
            ->pluck('supplier','id');

        return view('accounting.account-payable.index', ['acc_code' => $acc_code,'projects' => $projects,'supps'=>$supps]);
    }


    public function create()
    {
        $acc_code       = AccountChartModel::select('code',DB::raw('CONCAT(code," ",acc_name) AS account_mixed'))
            ->where("code",21001)
            ->pluck('account_mixed', 'code')
            ->prepend('Please Select', '');
        return view('accounting.account-payable.create',compact('acc_code'));
    }
    public function get_pay($id){
        $acc_code       = AccountChartModel::select('code',DB::raw('CONCAT(code," ",acc_name) AS account_mixed'))
            ->where("code",21001)
            ->pluck('account_mixed', 'code')
            ->prepend('Please Select', '');
        $data = JournalModel::find($id);
        return view('accounting.account-payable.form_pay',compact('acc_code','id','data'));
    }
    public function save_pay(Request $request){
        $this->validate($request,[
            'acc_payable_id'=>'required',
            'cash_type'=>'required',
            'journal_paydate'=>'required',
            'amount'=>'required',
            'journal_acccode'=>'required'
        ]);
        $journal = JournalModel::find($request->acc_payable_id);
        $journal->payable_paid = $journal->payable_paid + $request->amount;
        $journal->delete_status = 0;
        $journal->save();
        $max            = JournalModel::max('journal_tran_id');
        $max_invoice_num = JournalModel::max('payable_receipt_num');
        $voucher_ref    = $max + 1;
        (string) $voucher_ref;
        while (strlen($voucher_ref) < 8) {
            $voucher_ref = "0" . $voucher_ref;
        }
        $voucher_ref = "V-" . $voucher_ref;

        $max_tran_journal   = JournalModel::max('journal_tran_id');
        if (!$max_tran_journal) {
            $max_tran_journal = 0;
        }
        $journal_tran_id = $max_tran_journal + 1;

        $expense = new JournalModel;
        $expense->journal_parentid = 0;
        $expense->journal_type = 50000;
        $expense->journal_acccode = $request->journal_acccode;
        $expense->voucher_type = 1;
        $expense->voucher_ref = $voucher_ref;
        $expense->journal_des = $request->description;
        $expense->journal_debit = $request->amount;
        $expense->journal_credit = 0;
        $expense->journal_paydate = date("Y-m-d",strtotime($request->journal_paydate));
        $expense->journal_by = Auth::user()->id;
        $expense->journal_transactiondate = date('Y-m-d H:i:s');
        $expense->journal_tran_id = $journal_tran_id;
        $expense->journal_by_project = $journal->journal_by_project;
        $expense->journal_status= 0;
        $expense->person_name = $request->person_name;
        $expense->journal_referenceid = $request->acc_payable_id;
        $expense->transaction_type = "Acc-Payable-Payment";
        $expense->ref_account_chart = $request->journal_acccode;
        $expense->payable_receipt_num = $max_invoice_num+1;
        $expense->delete_status = 0;
        $expense->save();

        $jj=JournalModel::select(DB::raw("Max(id) as last_id"))->first();
        $cash = new JournalModel;
        $cash->journal_parentid = $jj->last_id;
        $cash->journal_type = 10000;
        $cash->journal_acccode = $request->cash_type;
        $cash->voucher_type = 1;
        $cash->voucher_ref = $voucher_ref;
        $cash->journal_des = $request->description;
        $cash->journal_debit = 0;
        $cash->journal_credit = $request->amount;
        $cash->journal_paydate = date("Y-m-d",strtotime($request->journal_paydate));
        $cash->journal_by = Auth::user()->id;
        $cash->journal_transactiondate = date('Y-m-d H:i:s');
        $cash->journal_tran_id = $journal_tran_id;
        $cash->journal_by_project = $journal->journal_by_project;
        $cash->journal_status= 0;
        $cash->person_name = $request->person_name;
        $cash->transaction_type = "Acc-Payable-Payment";
        $cash->ref_account_chart = $request->journal_acccode;
        $cash->journal_referenceid = $request->acc_payable_id;
        $cash->payable_receipt_num = $max_invoice_num+1;
        $expense->delete_status = 0;
        $cash->save();

        return redirect()->route('account_payable.index')->with("success","Create Successfully!");
    }
    public function get_view_paid($payable_id){
        $data = JournalModel::leftJoin("nso007_account_chart","nso007_account_chart.code","nso007_journal.ref_account_chart")
            ->where("transaction_type","Acc-Payable-Payment")
            ->whereIn('journal_acccode',['11001','11002'])
            ->where("journal_referenceid",$payable_id)
            ->select("nso007_journal.*",DB::raw("DATE_FORMAT(nso007_journal.journal_paydate, '%d-%m-%Y') as paid_date"),"nso007_account_chart.acc_name")
            ->get();
        return json_encode($data);
    }

    public function store(Request $request)
    {
        $this->validate($request,[
            'journal_acccode'=>'required',
            'journal_by_project'=>'required',
            'journal_paydate'=>'required',
            'amount'=>'required'
        ]);

        $max            = JournalModel::max('journal_tran_id');
        $voucher_ref    = $max + 1;
        (string) $voucher_ref;
        while (strlen($voucher_ref) < 8) {
            $voucher_ref = "0" . $voucher_ref;
        }
        $voucher_ref = "V-" . $voucher_ref;

        $max_tran_journal   = JournalModel::max('journal_tran_id');
        if (!$max_tran_journal) {
            $max_tran_journal = 0;
        }
        $journal_tran_id = $max_tran_journal + 1;

        JournalModel::insert([
            'journal_parentid'          => 0,
            'journal_type'              => 20000,
            'journal_acccode'           => $request->journal_acccode,
            'voucher_type'              => 2,
            'voucher_ref'               => $voucher_ref,
            'journal_des'               => $request->description,
            'journal_debit'             => 0,
            'journal_credit'            => $request->amount,
            'journal_paydate'           => date("Y-m-d",strtotime($request->journal_paydate)),
            'journal_by'                => Auth::user()->id,
            'journal_invoice'           => "",
            'journal_transactiondate'   => date('Y-m-d H:i:s'),
            'journal_tran_id'           => $journal_tran_id,
            'journal_by_project'        => $request->journal_by_project,
            'journal_status'           => 0,
            'journal_by_supplier'      => $request->journal_by_supplier,
            'transaction_type'         => "Acc-Payable"
        ]);

        \Globals::set_account_status($request->journal_acccode);

        return redirect()->route('account_payable.index')->with("success","Create Successfully!");
    }


    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $data = JournalModel::find($id);
        $acc_code       = AccountChartModel::select('code',DB::raw('CONCAT(code," ",acc_name) AS account_mixed'))
            ->where("code",21001)
            ->pluck('account_mixed', 'code')
            ->prepend('Please Select', '');
        return view('accounting.account-payable.edit',compact('data','acc_code'));
    }

    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'journal_acccode'=>'required',
            'journal_by_project'=>'required',
            'journal_paydate'=>'required',
            'journal_credit'=>'required'
        ]);

        JournalModel::where("id",$id)->update([
            'journal_acccode'           => $request->journal_acccode,
            'journal_des'               => $request->description,
            'journal_credit'            => $request->journal_credit,
            'journal_paydate'           => date("Y-m-d",strtotime($request->journal_paydate)),
            'journal_by_project'        => $request->journal_by_project,
            'journal_by_supplier'      => $request->journal_by_supplier,
            'transaction_type'         => "Acc-Payable"
        ]);

        \Globals::set_account_status($request->journal_acccode);

        return redirect()->route('account_payable.index')->with("success","Update Successfully!");
    }


    public function delete()
    {
        $journal_id = $_GET['id'];
        JournalModel::find($journal_id)->delete();
        return redirect()->route('account_payable.index')->with("success","Delete Successfully!");
    }
    public function paid_delete(){
        $journal_id = $_GET['id'];
        $journal = JournalModel::find($journal_id);
        $parent_journal = JournalModel::find($journal->journal_referenceid);
        $parent_journal->payable_paid = $parent_journal->payable_paid - $journal->journal_credit;
        $parent_journal->save();
        if($parent_journal->payable_paid<=0) {
            $parent_journal_p = JournalModel::find($journal->journal_referenceid);
            $parent_journal_p->delete_status = 1;
            $parent_journal_p->save();
        }
        JournalModel::where("journal_tran_id",$journal->journal_tran_id)->where("transaction_type","Acc-Payable-Payment")->delete();
        return redirect()->route('account_payable.index')->with("success","Delete Successfully!");
    }
    public function destroy($id)
    {
        //
    }
}
