<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ClientModel extends Model
{
    protected $table="nso007_client";
    
    public function get_province()
    {
    	 return $this->belongsTo('App\ProvinceModel','province','province_id');
    }
    public function get_district(){
    	return $this->belongsTo('App\DistrictModel',"district","district_id");
    }
    public function get_commune(){
    	return $this->belongsTo('App\CommuneModel',"commune","commune_id");
    }
    public function get_village(){
    	return $this->belongsTo('App\VillageModel','village','village_id');
    }
    public function feedback(){
        return $this->hasMany("App\CustomerFeedbackModel");
    }
}
