<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudRedis;

class MachineConfiguration extends \Google\Model
{
  /**
   * @var int
   */
  public $cpuCount;
  /**
   * @var string
   */
  public $memorySizeInBytes;
  /**
   * @var int
   */
  public $shardCount;

  /**
   * @param int
   */
  public function setCpuCount($cpuCount)
  {
    $this->cpuCount = $cpuCount;
  }
  /**
   * @return int
   */
  public function getCpuCount()
  {
    return $this->cpuCount;
  }
  /**
   * @param string
   */
  public function setMemorySizeInBytes($memorySizeInBytes)
  {
    $this->memorySizeInBytes = $memorySizeInBytes;
  }
  /**
   * @return string
   */
  public function getMemorySizeInBytes()
  {
    return $this->memorySizeInBytes;
  }
  /**
   * @param int
   */
  public function setShardCount($shardCount)
  {
    $this->shardCount = $shardCount;
  }
  /**
   * @return int
   */
  public function getShardCount()
  {
    return $this->shardCount;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(MachineConfiguration::class, 'Google_Service_CloudRedis_MachineConfiguration');
