<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/


Route::get('student/notifications/{limit?}','API\Student\StudentController@notifications');

Route::group(['namespace' => 'API'], function()
{
    Route::post('register', 'AuthController@register');
    Route::post('login', 'AuthController@login');
});
Route::group(['namespace' => 'API\Frontend'], function()
{
    Route::get('home','HomeController@home');
    Route::get('test','HomeController@test');
    Route::get('course-detail/{id}','HomeController@course_detail');
    Route::get('about','HomeController@about');
    Route::get('banner','HomeController@banner');
    Route::get('package','HomeController@package');
    Route::get('testimonail','HomeController@testimonail');

    Route::get('view-all-course-by-category/{id}/{limit?}','HomeController@view_all_course_by_category');
    Route::get('free-course-by-category/{id}/{limit?}','HomeController@free_by_category');//courses_by_category
    Route::get('courses-by-category/{id}/{limit?}','HomeController@courses_by_category');//courses_by_category
    Route::post('/search-course','HomeController@search');
    Route::get('/exercise-by-course/{id}','HomeController@exercise');
    Route::get('/exercise-list/{limit?}','HomeController@exercise_list');
    Route::get('/short-course/{limit?}','HomeController@short_course');
});

Route::group(['namespace'=>'API\Student', 'middleware'=>['student','auth:api'],'prefix' => 'student'] , function () {
    Route::get('course-list','StudentController@index');
    Route::get('view-video/{id}','StudentController@view_video');
    Route::POST('change-password','StudentController@change_password');
    Route::get('notification','StudentController@notification');
    Route::POST('/answer-exercises','StudentController@submit_answer');
    Route::get('/increment-view/{video_id}','StudentController@increment_view');
});

Route::group(['namespace'=>'API', 'middleware'=>['student','auth:api']] , function () {
    Route::post('logout', 'AuthController@logout');
});
Route::group(['namespace'=>'API\Frontend', 'middleware'=>['student','auth:api']] , function () {
    Route::get('/exercise-detail/{id}','HomeController@exercise_detail');
});

Route::group(['namespace' => 'Apis\V2','prefix' => 'v2'],function(){
    Route::get('/home','ScreenController@home');
    Route::get('/exercises','ScreenController@exercise');
    Route::get('/all-courses','ScreenController@courses');
});
Route::post('/store-firebase-token', function (Request $request) {

    if(!$request->device_token) return [
        'success' => false,
        'data'    => null,
        'message' => 'Device_token is required',
    ];
    if($request->token){
        $data = \App\DeviceTokens::updateOrCreate(['token'=>$request->token],$request->all());
    }else{
        $data = \App\DeviceTokens::create($request->all());

    }
    return [
        'success' => true,
        'data'    => $data,
        'message' => 'store success',
    ];
});
