<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use Google\Client;

class NotificationController extends Controller
{

    public function sendThoySophal(Request $request)
    {
        return $this->send($request, 'thoy');
    }

    public function send2U(Request $request)
    {
        return $this->send($request, '2u');
    }

    public function send($request, $project)
    {

        try {
            Log::info('===================================Start==============================================');

            $auth = sha1('narak-send-noti');


            if ($request->auth !== $auth){

                return ['success' => false, "'message'=>'You dont have right to access... ' $auth <br> $request->auth"];
            }

            if (!$project) return ['success' => false, 'message' => 'Project invalid', 'data' => ''];

            if ($project === '2u') {
                $project_name = 'u-delviery';
                $credential_file = '2u-new.json';
            }
            if ($project === 'thoy') {
                $project_name = 'sophal-best-education';
                $credential_file = 'firebase.json';
            }

            $Bearer = self::getAccessToken($credential_file);
//        $dataPayload['click_action'] = 'FLUTTER_NOTIFICATION_CLICK';
//        $dataPayload['noti_type'] = $request->noti_type;
//        $dataPayload['noti_id'] = $request->noti_id;
//        $dataPayload['title'] = $request->title;
//        $dataPayload['body'] = $request->body;
//        $dataPayload['image'] = $request->image;
            Log::info($request->all());
            $array = [];
            if($request->data){
                $data = urldecode($request->query('data'));
                $array = json_decode($data, true);
            }


            $paylaod = [
                'message' => [
                    'token' => $request->device_token,
                    'notification' => [
                        'title' => $request->title,
                        'body' => $request->body,
                        'image' => $request->image,
                    ],
                    'data' => count($array)?$array:['nothing'=>'nothing'],
//                    'data' => count($array)?json_encode($array):['nothing'=>'nothing'],

                ],
            ];


            $dataString = json_encode($paylaod);
            $headers = [
                'Authorization: Bearer ' . $Bearer,
                'Content-Type: application/json',
            ];


            $ch = curl_init();

            curl_setopt($ch, CURLOPT_URL, "https://fcm.googleapis.com/v1/projects/$project_name/messages:send");
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);
            $response = curl_exec($ch);
            if (curl_errno($ch)) {
                // If an error occurs, capture and log the error
                $error_msg = curl_error($ch);
                Log::error('FCM error:', ['error' => $error_msg]);
            } else {
                $data = json_decode($response, 1);
                // Handle the response
                Log::info('FCM response:', ['response' => $data]);


            }
            curl_close($ch);
            Log::info('===================================End==============================================');

            return ['success' => true, 'message' => 'sent success', 'data' => $paylaod];

        } catch (\Exception $e) {
            Log::error($e);
        }
    }

    public static function getAccessToken($credential_file)
    {
        // Cache key for storing the token
        $cacheKey = 'firebase_access_token';

        // Check if token is already cached
        if (Cache::has($cacheKey)) {
            $cachedToken = Cache::get($cacheKey);
//            Log::info('Firebase Token', ['message' => 'get token in cache']);

            return $cachedToken;
        }
        $credentialsFilePath = storage_path("app/json/$credential_file");

        // Path to your service account JSON file
        $serviceAccountPath = base_path('public/belyna-2e370-firebase-adminsdk-5dgqq-a1733c75d1.json');

        // Create a new Google Client
        $client = new Client;
        $client->setAuthConfig($credentialsFilePath);
        $client->addScope('https://www.googleapis.com/auth/firebase.messaging');
        $client->useApplicationDefaultCredentials();

        // Fetch a new access token
        $token = $client->fetchAccessTokenWithAssertion();

        // Log the token (for debugging or logging purposes)
        // Store the access token in cache for 1 hour (60 minutes)
        Cache::put($cacheKey, $token['access_token'], now()->addMinutes(60));
//        Log::info('Firebase Token', ['message' => 'generate new token']);

        return $token['access_token'];
    }


}
