<?php

namespace App\Http\Controllers\Apis\V2;

use App\AboutUsModel;
use App\BannerModel;
use App\CategoryModel;
use App\CourseModel;
use App\ExerciseModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\StudentExercise;
use stdClass;
use Illuminate\Support\Str;

class ScreenController extends Controller
{
    public function home(Request $request)
    {
        $data['category'] = CategoryModel::select(
            'id',
            'category_en AS name_en',
            'category_kh AS name_km',
            'icon',
            'video'
        )->get()->map(function ($row) {
            $row->icon  = $row->icon ? domain().'/images/' . $row->icon : '';
            $row->video = $row->video ? Str::after($row->video, 'v=') : '';
            return $row;
        });
        $data['slide'] = BannerModel::whereStatus(1)->get()->map(function ($row) {
            $item           = new stdClass;
            $item->id       = $row->id;
            $item->image    = domain().'/assets/images/banner/' . $row->image;
            $item->youtube_id =Str::after($row->video, 'v=') : '';
            return $item;
        });
        $about = AboutUsModel::first();
        $data['messenger'] = strval($about->fb_link);
        return response()->json(['success' => true, 'data' => $data]);
    }
    public function exercise(Request $request)
    {
        $limit                  = $request->limit ?? 20;
        $exercise               = ExerciseModel::with('course:id,image')->whereStatus(1)->whereType('free')->paginate($limit);
        $data['total']          = $exercise->total();
        $data['total_page']     = $exercise->lastPage();
        $data['current_page']   = $exercise->currentPage();
        $data['exercise']       = $exercise->map(function ($row) {
            $result = auth('api')->check() ? StudentExercise::whereStudentId(auth('api')->user()->id)->whereExcerciseId($row->id)->count() : 0;
            return [
                'id' => $row->id,
                'title' => $row->title,
                'image' => domain().'/assets/courses/images/' . $row->course->image,
                'tested'    => $result > 0 ? 1 : 0
            ];
        });
        return response()->json(['success' => true, 'data' => $data]);
    }
    public function courses(Request $request){
        $limit      = $request->limit ?? 20;
        $courses    = CourseModel::whereStatus(1)->wherePaymentStatus('pay')->orderBy('order')->paginate($limit);
        $data       = $courses->map(function($val){
            return [
                'id'                =>  $val->id,
                'category_id'       =>  $val->category_id,
                'category_name'     =>  @$val->category->category_en,
                'course_name'       =>  $val->name,
                'price'             =>  $val->price,
                'discount_price'    =>  $val->discount_price,
                'payment_status'    =>  $val->payment_status,
                'duration'          =>  $val->duration."ខែ",
                'total_videos'      =>  $val->get_video()->count(),
                'view'              =>  $val->view,
                'image'             =>  'https://thoysophaled.com/assets/courses/images/' . $val->image,
                'rate'              =>  intval(helper_get_star($val->id)),
                'desc'              =>  $val->description,
                'created_at'        =>  date('d-m-Y', strtotime($val->created_at))
            ];
        });
        $total_page     = $courses->lastPage();
        $current_page   = $courses->currentPage();
        $description    = 'មានជិត១០០វគ្គ ជ្រើសរើសសិក្សាវគ្គណាក៏បាន។ បង់១ខែ= 10$ សិក្សាបានទាំងអស់ដោយសេរី ។ បង់១ឆ្នាំ=69$ សិក្សាដោយសេរី។ ៣ឆ្នាំ= 150$ សិក្សាដោយសេរី។ ៥ឆ្នាំ= 199$ សិក្សាដោយសេរី។ បើចង់រៀនជាវគ្គ ១វគ្គ=20$';
        return response()->json(['description' => $description,'data' => $data, 'current_page' => $current_page, 'total_page' => $total_page]);
    }
}
